/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2007.
-------------------------------------------------------------------------
$Id:$
$DateTime$
Description:  
-------------------------------------------------------------------------
History:
- 15:06:2007   : Created by Denisz Polgar

*************************************************************************/
#include "StdAfx.h"
#include "C4Projectile.h"
#include "TacticalC4Projectile.h"
#include "Actor.h"
#include "GameRules.h"

CTacticalC4Projectile::CTacticalC4Projectile()
:CC4Projectile()
{
}

//-------------------------------------------
CTacticalC4Projectile::~CTacticalC4Projectile()
{
}

//-------------------------------------------
bool CTacticalC4Projectile::Init(IGameObject *pGameObject)
{
	return CProjectile::Init(pGameObject);
}

//------------------------------------------
void CTacticalC4Projectile::HandleEvent(const SGameObjectEvent &event)
{
	if (m_destroying)
		return;

	CC4Projectile::HandleEvent(event);
}

void CTacticalC4Projectile::Update( SEntityUpdateContext &ctx, int updateSlot)
{
	CProjectile::Update(ctx, updateSlot);

	// Time to die
	float countdown=m_pAmmoParams->lifetime-m_totalLifetime;
	if (gEnv->bServer && countdown >= 0.0f)
	{
			string time;
			time.Format("%.2f", countdown);
			g_pGame->GetGameRules()->SendTextMessage(eTextMessageCenter, "@mp_BombCountdown", eRMI_ToAllClients, -1, time.c_str());
	}
}

void CTacticalC4Projectile::ProcessEvent(SEntityEvent &event)
{
	if (event.event == ENTITY_EVENT_TIMER && event.nParam[0])
	{
		Explode(true, false, ZERO, FORWARD_DIRECTION, ZERO, 0);
	}
}