/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2007.
-------------------------------------------------------------------------
$Id:$
$DateTime$
Description:  C4 projectile specific stuff for Tactical Combat
-------------------------------------------------------------------------
History:
- 15:06:2007   : Created by Denisz Polgar

*************************************************************************/

#ifndef __TACTICALC4PROJECTILE_H__
#define __TACTICALC4PROJECTILE_H__

#if _MSC_VER > 1000
# pragma once
#endif


#define MAX_STICKY_POINTS					3

class CTacticalC4Projectile : public CC4Projectile
{
public:
	CTacticalC4Projectile();
	virtual ~CTacticalC4Projectile();

	virtual bool Init(IGameObject *pGameObject);
	virtual void HandleEvent(const SGameObjectEvent &evnt);

	virtual void Update( SEntityUpdateContext &ctx, int updateSlot);
	virtual void ProcessEvent(SEntityEvent &event);

	//IHitListener
	// Unlike other projectiles, C4 should be indestructible
	virtual void OnHit(const HitInfo&){}
	virtual void OnExplosion(const ExplosionInfo&){}
	virtual void OnServerExplosion(const ExplosionInfo&){}

	struct ProjectileStaticParams
	{
		ProjectileStaticParams(){pos.Set(0,0,0); rot.SetIdentity();}
		ProjectileStaticParams(Vec3 &_pos, Quat &_rot): pos(_pos), rot(_rot) {}

		Vec3 pos;
		Quat rot;

		void SerializeWith(TSerialize ser)
		{
			ser.Value("c4Pos",pos);
			ser.Value("c4Rot",rot);
		}
	};

private:

};

#endif