#include "StdAfx.h"
#include "Nodes/G2FlowBaseNode.h"
#include "IAISystem.h"

class CFlowPathMeasureNode : public CFlowBaseNode
{
public:
	CFlowPathMeasureNode(SActivationInfo * pActInfo)
	{

	}

	~CFlowPathMeasureNode()
	{

	}

	virtual IFlowNodePtr CFlowPathMeasureNode::Clone(SActivationInfo *pActInfo) override
	{
		return new CFlowPathMeasureNode(pActInfo);
	}

	enum EInputs
	{
		IN_PATH,
		IN_POSITION,
	};

	enum EOutputs
	{
		OUT_DISTANCE_ALONG,
		OUT_DISTANCE_FROM,
		OUT_NEAREST_POINT,
	};

	virtual void GetConfiguration(SFlowNodeConfig &config) override
	{
		static const SInputPortConfig in_config[] = {
			InputPortConfig<string>( "Path",_HELP("Path to measure the distance along") ),
			InputPortConfig<Vec3>( "Position",_HELP("Position of the point to measure") ),
			{0}
		};
		static const SOutputPortConfig out_config[] = {
			OutputPortConfig<int> ("DistanceAlong", _HELP("Returns the distance ALONG the path")),
			OutputPortConfig<int> ("DistanceFromPath", _HELP("Returns the distance between the point and the path")),
			OutputPortConfig<Vec3>("NearestPoint",_HELP("Nearest point on the path") ),
			{0}
		};

		config.sDescription = _HELP( "PathMeasure node determines the location of a point relative to a AIPath" );
		config.pInputPorts = in_config;
		config.pOutputPorts = out_config;
		config.SetCategory(EFLN_WIP);
		//config.nFlags |= EFLN_TARGET_ENTITY;
	}

	virtual void ProcessEvent(EFlowEvent event, SActivationInfo *pActInfo) override
	{
		switch (event)
		{
		case eFE_Initialize:
			break;
		case eFE_Activate:
			{
				float dist;
				Vec3 nearestPt;
				float distAlongPath;
				bool success = gEnv->pAISystem->GetNearestPointOnPathReally(
					GetPortString(pActInfo, IN_PATH), GetPortVec3(pActInfo, IN_POSITION), dist, nearestPt, &distAlongPath);
				if (success)
				{
					ActivateOutput(pActInfo, OUT_DISTANCE_ALONG, distAlongPath);
					ActivateOutput(pActInfo, OUT_DISTANCE_FROM, dist);
					ActivateOutput(pActInfo, OUT_NEAREST_POINT, nearestPt);
				}
			}
			break;
		}
	}

	virtual void GetMemoryStatistics(ICrySizer *s)
	{
		s->Add(*this);
	}
};

REGISTER_FLOW_NODE("AI:PathMeasure", CFlowPathMeasureNode);