/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2007.
-------------------------------------------------------------------------
$Id$
$DateTime$
Description: Inplements the moving train in a FlowNode

-------------------------------------------------------------------------
History:
- 30:10:2007: Created by Attila Marton

*************************************************************************/

#ifndef __FLOWTRAINNODE_H__
#define __FLOWTRAINNODE_H__

#include <IFlowSystem.h>
#include "Nodes/G2FlowBaseNode.h"

class CTrainPathIterator
{
	friend class CTrainPath;
public:
	CTrainPathIterator();
	void Invalidate();

private:
	int Segment;
	float LastDistance;
};

class CTrainPath
{
public:
	CTrainPath();
	void SetPath(const std::vector<Vec3> *path);
	Vec3 GetPointAlongPath(float dist, CTrainPathIterator &iterator);

private:
	struct STrainPathNode
	{
		Vec3 Position;
		float Length, TotalLength;
	};
	std::vector<STrainPathNode> Path;
};

class CFlowTrainNode : public CFlowBaseNode
{
public:
	static std::vector<CFlowTrainNode *> gFlowTrainNodes;
	static int OnPhysicsPostStep_static(const EventPhys * pEvent);
	CFlowTrainNode( SActivationInfo * pActInfo );
	~CFlowTrainNode();
	virtual IFlowNodePtr Clone( SActivationInfo * pActInfo );
	virtual void Serialize(SActivationInfo *, TSerialize ser);
	virtual void GetConfiguration( SFlowNodeConfig &config );
	virtual void ProcessEvent( EFlowEvent event, SActivationInfo *pActInfo );
	virtual void GetMemoryStatistics(ICrySizer * s);
	int OnPhysicsPostStep(const EventPhys * pEvent);
	static bool PlayerIsOnaTrain();
private:
	void DiscoverTrainCoaches(IEntity *pEntity);
	void InitTrainCoaches();
	void AwakeCoaches();
	int GetCoachIndexPlayerIsOn();
	int GetCoachIndexPlayerIsOn2();
	void SuckCloakEnergyOnTrain();
	float GetPlayerMaxVelGround();
	void SetPlayerMaxVelGround(float vel);

	tSoundID PlayLineSound(int coachIndex, const char *sGroupAndSoundName, const Vec3 &vStart, const Vec3 &vEnd);
	void UpdateLineSounds();
	void StartSounds();
	void SplitLineSound();
	void TrainStopSounds();
	void StopAllSounds();
	float GetSpeedSoundParam(int coachIndex);
	void SetSoundParams();
	void StartBreakSoundShifted();

	enum EInputs
	{
		IN_PATH,
		IN_SPEED,
		IN_START_DISTANCE,
		IN_SPLIT_COACH,
		IN_HORN_SOUND,
		IN_BREAK_SOUND,
	};
	CTrainPath m_path;
	float m_speed;
	float m_distanceOnPath; //train last coach end distance on path
	int m_splitCoachIndex;  //coach index where to split train (0 is the train engine)

	bool m_bFirstUpdate;
	CTimeValue m_offTrainStartTime;
	int m_coachIndex;

	float m_splitDistanceOnPath; //the splitted coaches end coach distance on path
	float m_splitSpeed; //splitted coaches speed

	struct STrainCoach
	{
		STrainCoach();
		IEntity *m_pEntity;
		int m_frontWheelBase, m_backWheelBase;
		float m_wheelDistance; //wheel half distance from center
		float m_coachOffset;  //coach half length
		float m_distanceOnPath; //coach center distance on path
		IEntitySoundProxy* m_pEntitySoundsProxy;
		tSoundID m_runSoundID;
		tSoundID m_breakSoundID;
		CTrainPathIterator m_frontWheelIterator[2], m_backWheelIterator[2];
	};

	tSoundID m_hornSoundID;	
	tSoundID m_engineStartSoundID;

	std::vector<STrainCoach> m_coaches;
	static float m_playerMaxVelGround;
	int m_startBreakSoundShifted;
};

#endif