/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2004.
-------------------------------------------------------------------------
$Id$
$DateTime$
Description: Implements the Trooper alien.

-------------------------------------------------------------------------
History:
- 21:7:2005: Created by Mikko Mononen

*************************************************************************/
#ifndef __TROOPER_H__
#define __TROOPER_H__

#if _MSC_VER > 1000
# pragma once
#endif

#include "Alien.h"

#define LOOKIK_BLEND_RATIOS 5
#define TARGET_BEAM_COUNT		3

struct STrooperBeam
{
	bool active;
	int effectSlot;
	EntityId beamTargetId;

	STrooperBeam()
	{
		memset(this,0,sizeof(STrooperBeam));
	}

	void CreateBeam(IEntity *owner,const char *effect,EntityId targetId);
	void RemoveBeam(IEntity *owner);
	void Update(IEntity *owner,float frameTime);
};

class CTrooper :
	public CAlien
{
public:
	enum EJumpState {
		JS_None,
		JS_JumpStart,
		JS_ApplyImpulse,
		JS_Flying,
		JS_ApproachLanding,
		JS_Landing,
		JS_Landed,
		JS_Last = JS_Landed
	};

	enum EBeamType
	{
		BT_ALL = -1,
		BT_DISCOVERY = 0,
		BT_SEARCH,
		BT_SEEK,
		BT_TARGETS,
		BT_TARGET_SEEK=BT_TARGETS,
		BT_TARGET,
		BT_COUNT
	};

	enum EBeamState
	{
		BS_ON = 0,
		BS_OFF = 1,
		BS_SUSPEND,

		BS_RESUME			// Not a real state, only used to trigger specialized ON actions
	};

	struct SJumpParams 
	{
		Vec3 dest;
		Vec3 velocity;
		float duration;
		Vec3 addVelocity;
		EJumpState state;
		CTimeValue startTime;
		bool bUseLandAnim;
		bool bUseStartAnim;
		bool bFreeFall;
		bool bUseAnimEvent;
		bool bRelative;
		bool bUseSpecialAnim;
		bool bTrigger;
		EJumpAnimType specialAnimType;
		EAnimationMode specialAnimAGInput;
		string specialAnimAGInputValue;
		float landPreparationTime;
		float defaultLandPreparationTime;
		bool bPlayingSpecialAnim;
		float prevInAir;
		float landDepth;
		Vec3 curVelocity;
		Vec3 initLandVelocity;
		bool bUseLandEvent;

		SJumpParams():dest(ZERO),velocity(ZERO),addVelocity(ZERO), curVelocity(ZERO),initLandVelocity(ZERO)
		{
			Reset();
		}

		void Serialize (TSerialize ser )
		{
			ser.BeginGroup("JumpParams");
			ser.Value("dest",dest);
			ser.Value("velocity",velocity);
			ser.Value("curVelocity",curVelocity);
			ser.Value("addVelocity",addVelocity);
			ser.Value("bRelative",bRelative);
			ser.Value("duration",duration);
			ser.EnumValue("state",state, JS_None,JS_Last);
			ser.Value("bTrigger",bTrigger);
			ser.Value("startTime",startTime);
			ser.Value("bUseLandAnim",bUseLandAnim);
			ser.Value("bUseStartAnim",bUseStartAnim);
			ser.Value("bUseAnimEvent",bUseAnimEvent);
			ser.Value("bUseSpecialAnim",bUseSpecialAnim);
			ser.EnumValue("specialAnimType",specialAnimType,JUMP_ANIM_FLY,JUMP_ANIM_LAND);
			ser.EnumValue("specialAnimAGInput",specialAnimAGInput,AIANIM_SIGNAL,AIANIM_ACTION);
			ser.Value("specialAnimAGInputValue",specialAnimAGInputValue);
			ser.Value("defaultLandPreparationTime",defaultLandPreparationTime);
			ser.Value("landPreparationTime",landPreparationTime);
			ser.Value("bPlayingSpecialAnim",bPlayingSpecialAnim);
			ser.Value("prevInAir",prevInAir);
			ser.Value("landDepth",landDepth);
			ser.Value("initLandVelocity",initLandVelocity);
			ser.Value("bUseLandEvent",bUseLandEvent);
			ser.EndGroup();
		}


		void Reset()
		{
			dest = ZERO;
			velocity = ZERO;
			curVelocity = ZERO;
			addVelocity = ZERO;
			initLandVelocity = ZERO;
			duration = 0.f;
			state = JS_None;
			startTime = 0.f;
			bUseLandAnim = false;
			bFreeFall = false;
			bUseStartAnim = false;
			bUseAnimEvent = false;
			bRelative = false;
			bTrigger = false;
			bUseSpecialAnim = false;
			specialAnimType = JUMP_ANIM_FLY;
			specialAnimAGInput = AIANIM_ACTION;
			landPreparationTime = 0.1f;
			defaultLandPreparationTime = 0.1f;
			bPlayingSpecialAnim = false;
			prevInAir = 0;
			landDepth = 0;
			bUseLandEvent = false;
		}
	};

	CTrooper() : CAlien(), 
		m_heightVariance(0),	
		m_heightVarianceLow(0),	
		m_heightVarianceHigh(0),
		m_heightVarianceFreq(0),
		m_heightVarianceRandomize(0),
		m_shieldProjector(0),
		m_maxShieldEnergy(0.0f),
		m_shieldEnergy(0.0f),
		m_bProjectionMalfunction(false),
		m_bShutdownShield(false),
		m_nextMalfunctionCheck(0.0f),
		m_nextShieldManagement(0.0f),
		m_pShieldAttachment(NULL),
		m_pShieldSphereAttachment(NULL),
		m_shieldBeamEffectSlot(-1),
		m_lastDegenerationTime(0),
		m_aliveGroupId(-1),
		m_shieldPhysicsId(-1),
		m_pShieldGeom(NULL),
		m_bShielded(false),
		m_scannerBeamType(BT_ALL),
		m_scannerBeamTimeout(-1),
		m_scannerBeamPeriod(-1),
		m_scannerBeamBreak(0),
		m_scannerBeamNextcycle(-1),
		m_scannerBeamState(BS_OFF),
		m_pScannerBeamAttachment(NULL),
		m_pLeftExhaust(NULL),
		m_pRightExhaust(NULL),
		m_pExhaustEffect(NULL),
		m_reloadStartTime(-1),
		m_reloadDuration(-1)
	{
		m_modelQuat.SetIdentity();
	}

	virtual ~CTrooper();

	virtual bool CreateCodeEvent(SmartScriptTable &rTable);

	virtual void Kill();
	virtual void Revive(bool fromInit = false);

	virtual bool Init( IGameObject * pGameObject );
	virtual void Update(SEntityUpdateContext&, int updateSlot);

	virtual void RagDollize( bool fallAndPlay );
	virtual void Fall(Vec3 hitPos = Vec3(0,0,0), bool forceFall = false, float sleepTime = 0.0f);
	virtual void StandUp();

	virtual void SetActorMovement(SMovementRequestParams &control);

	virtual void SetParams(SmartScriptTable &rTable,bool resetFirst);

	virtual void ProcessRotation(float frameTime);
	virtual void ProcessMovement(float frameTime);

	virtual void ProcessAnimation(ICharacterInstance *pCharacter,float frameTime);

	virtual void SetActorStance(SMovementRequestParams &control, int& actions);

	//virtual bool UpdateStance();

	virtual void ResetAnimations();

	virtual void UpdateStats(float frameTime);

	virtual bool IsFlying(){return false;}

	virtual void BindInputs( IAnimationGraphState * pAGState );

	//Player can grab troopers
	virtual int	 GetActorSpecies() { return eGCT_TROOPER; }

	void GetMemoryStatistics(ICrySizer * s);

	virtual void SetAnimTentacleParams(pe_params_rope& rope, float animBlend);

	virtual void AnimationEvent(ICharacterInstance *pCharacter, const AnimEventInstance &event);

	virtual void UpdateAnimGraph( IAnimationGraphState * pState );

	virtual bool ForceBleed();

	void FullSerialize( TSerialize ser );
	void PostSerialize();

	// Guardian effects
	virtual void SetShieldProjector(EntityId projector);
	virtual void ActivateShieldProjection(bool activate);
	virtual bool HasActiveShieldProjection() const {return m_maxShieldEnergy > 0;}
	virtual void AddShieldTarget(EntityId targetId, float energy);
	virtual void RemoveShieldTarget(EntityId targetId);
	virtual float GetReceivedShieldEnergy(IEntity **ppProjector=NULL) const;
	virtual void SetReceivedShieldEnergy(float energy);
	virtual float GetProjectedShieldEnergy(EntityId targetId) const;
	virtual void SetProjectedShieldEnergy(EntityId targetId, float energy);
	
	virtual bool CanLaunchShockwave();
	// Salvaging
	// EXP 1 Rev 2.: Salvager dumped
	
	virtual void SetNanoSuitDisruption(bool disrupt, float effect_scale = 1.0f);
	virtual void ProcessEMPEffect(float effect_time);

	virtual bool IsWaterWeak() const {return false;}

private:
	void InitHeightVariance(SmartScriptTable &rTable);
	void Jump();
  void JumpEffect();

	void ResetShields();
	void ClearShieldEffect();
	void ResetFallen();

	bool EnableSearchBeam(EBeamType type, EBeamState state, float period, float period2, float timeout);
	bool IsSlotAvailable(EBeamType type);
	void LockThisSlot();
	void ReleaseUsedSlot();

	void ResetReloading();

	void ManageShields(const SEntityUpdateContext& ctx);

	void UpdateShielding(const SEntityUpdateContext& ctx);
	void UpdateScannerBeams(const SEntityUpdateContext& ctx);
	void UpdateReloading(const SEntityUpdateContext& ctx);
protected:
	typedef std::map<EStance,Vec3> TStanceMapCollSize;
	//Quat m_modelQuat;//the model rotation
	//QuatT m_modelAddQuat;//additional model rotation used for banking/tilting etc
	CTimeValue m_lastNotMovingTime;  
	f32		m_customLookIKBlends[LOOKIK_BLEND_RATIOS];
	float	m_oldSpeed;
	float m_heightVarianceLow;
	float m_heightVarianceHigh;
	float m_heightVariance;
	float m_heightVarianceFreq;
	float m_heightVarianceRandomize;

	float m_fDistanceToPathEnd;
	float m_Roll;
	float m_Rollx;
	float m_steerInertia;
	Vec3	m_landModelOffset;
	Vec3	m_steerModelOffset;
	Vec3  m_oldVelocity;
	//float m_Rollz;
	bool	m_bExactPositioning;
	CTimeValue m_lastExactPositioningTime;
	SJumpParams m_jumpParams;
	string m_overrideFlyAction;
	bool m_bOverrideFlyActionAnim;
	static const float CTentacle_maxTimeStep;
	static const float CMaxHeadFOR;
	CTimeValue m_lastTimeOnGround;
	Vec3 m_lastCheckEnvironmentPos;
	bool m_bNarrowEnvironment;
	//TStanceMapCollSize m_CollSize;
	float m_oldDirStrafe ;
	float m_oldDirFwd ;
	float m_fTtentacleBlendRotation;

	static const float ClandDuration;
	static const float ClandStiffnessMultiplier;

	struct SShieldTarget
	{
		SShieldTarget(float _power)
		{
			power=_power;
			shield_ok=FLT_MAX;
		}

		SShieldTarget()
		{
			power=0;
			shield_ok=FLT_MAX;
		}

		void Serialize(TSerialize ser)
		{
			ser.Value("power", power);
			
			if (ser.IsReading())
			{
				shield_ok=FLT_MAX;
			}
		}

		float power;
		float shield_ok;
	};

	// Guardian effects
	EntityId m_shieldProjector;
	float m_maxShieldEnergy;
	float m_shieldEnergy;
	bool m_bProjectionMalfunction;
	bool m_bShutdownShield;
	float m_nextMalfunctionCheck;
	IAttachment* m_pShieldAttachment;
	IAttachment* m_pShieldSphereAttachment;
	int m_shieldBeamEffectSlot;
	typedef std::map<EntityId, SShieldTarget> TShieldTargets;
	TShieldTargets m_ShieldTargets;
	TShieldTargets m_loadShieldTargets;
	// Shield cache for bleeding fast query
	bool m_bShielded;

	// Shield physics
	int m_shieldPhysicsId;
	phys_geometry *m_pShieldGeom;

	// Shield management
	float m_nextShieldManagement;

	// Fallen administration
	float m_lastDegenerationTime;
	int m_aliveGroupId;

	// Scanners

	// Scanner limit slots
	static int s_scannerBeamCount [BT_COUNT];

	// Scanner parameters
	EBeamType m_scannerBeamType;
	float m_scannerBeamPeriod;									// Suspend beam after period seconds. If -1, do not care about limits
	float m_scannerBeamBreak;										// Go back to active from suspended after break seconds
	
	// Scanner states and timing
	EBeamState m_scannerBeamState;							// ON, OFF or PENDING. Could be stored differently, but clearer this way
	float m_scannerBeamNextcycle;								// The time at which next beam cycle (suspension/acivation) should start
	float m_scannerBeamTimeout;									// Shutdown scanner here
	float m_nextBeamScan;												// Used to schedule alteration in beam scan directions
	bool m_bScanHorizontal;

	IAttachment* m_pScannerBeamAttachment;
	SSearchBeamStats m_targetBeams [TARGET_BEAM_COUNT];
	

	// Reloading effect
	IAttachment *m_pLeftExhaust;
	IAttachment *m_pRightExhaust;
	IAttachment *m_pExhaustEffect;
	QuatT m_leftExhaustDefaultT;
	QuatT m_rightExhaustDefaultT;
	QuatT m_leftExhaustTargetT;
	QuatT m_rightExhaustTargetT;
	float m_reloadStartTime;
	float m_reloadDuration;

	IAnimationGraph::InputID m_idAngleXInput;
	IAnimationGraph::InputID m_idAngleZInput;
	IAnimationGraph::InputID m_idActionInput;
	IAnimationGraph::InputID m_idSignalInput;
	IAnimationGraph::InputID m_idMovementInput;
};


#endif //__TROOPER_H__
