////////////////////////////////////////////////////////////////////////////
//
//  Crytek Engine Source File.
//  Copyright (C), Crytek Studios, 2010.
// -------------------------------------------------------------------------
//  File name:   ParticleMemory.cpp
//  Version:     v1.00
//  Created:     18/03/2010 by Corey Spink
//  Compilers:   Visual Studio.NET
//  Description: All the particle system's specific memory needs
// -------------------------------------------------------------------------
//  History:
//
////////////////////////////////////////////////////////////////////////////

#include "StdAfx.h"
#include "ParticleMemory.h"
#include "Cry3DEngineBase.h"

namespace ParticleMemory
{
	void ParticleMemoryManager::Init(const uint32 a_particleSize, const uint32 a_emitterSize)
	{
		m_memoryPoolSize = PARTICLE_POOL_MEMORY_SIZE + LOC_SUB_EMITTER_POOL_MEMORY_SIZE;
		const uint32 particleMemorySize = (uint32)PARTICLE_POOL_MEMORY_SIZE;

		const uint32 EMITTER_ALIGNMENT = max(LOC_EMITTER_ALIGNMENT, SUB_EMITTER_ALIGNMENT);
		const uint32 MAX_ALIGNMENT = max(EMITTER_ALIGNMENT, PARTICLE_ALIGNMENT);
		const uint32 REQUIRED_ALIGNMENT = Align(max(a_particleSize, a_emitterSize), MAX_ALIGNMENT);
		uint8* baseMemoryPointer = (uint8*)CryModuleMemalign(m_memoryPoolSize, REQUIRED_ALIGNMENT);
		uint8* currentParticleMemoryPointer = baseMemoryPointer;

		const uint32 particleSizeAligned = Align(a_particleSize, PARTICLE_ALIGNMENT);
		const uint32 maxParticles = (uint32)(particleMemorySize/(float)particleSizeAligned);
		const uint32 totalParticleMemorySize = maxParticles * particleSizeAligned;
		m_particlePoolMemory = (void*)currentParticleMemoryPointer;
		g_particlePool.Init(m_particlePoolMemory, maxParticles, particleSizeAligned);

		currentParticleMemoryPointer += totalParticleMemorySize;
		if(a_emitterSize > 0)
		{
			currentParticleMemoryPointer = Align(currentParticleMemoryPointer, EMITTER_ALIGNMENT);
			const uint32 availableMemoryForEmitters = m_memoryPoolSize - ((uint32)currentParticleMemoryPointer - (uint32)baseMemoryPointer);
			const uint32 emitterSizeAligned = Align(a_emitterSize, EMITTER_ALIGNMENT);
			const uint32 maxEmitters = (uint32)(availableMemoryForEmitters/(float)emitterSizeAligned);
			const uint32 totalEmitterMemorySize = maxEmitters * emitterSizeAligned;
			m_emitterPoolMemory = (void*)currentParticleMemoryPointer;
			assert((totalParticleMemorySize + totalEmitterMemorySize) <= m_memoryPoolSize);
			assert(((uint32)m_emitterPoolMemory + totalEmitterMemorySize) <= ((uint32)baseMemoryPointer + m_memoryPoolSize));
			g_emitterPool.Init(m_emitterPoolMemory, maxEmitters, emitterSizeAligned);
		}
	}

	void ParticleMemoryManager::Reset()
	{
		CryModuleMemalignFree(m_particlePoolMemory);
	}

	void ParticleMemoryManager::GetMemoryUsage(ICrySizer* pSizer)
	{
		g_ParticleHeap.GetMemoryUsage(pSizer);
		pSizer->AddObject(m_particlePoolMemory, m_memoryPoolSize);
	}

	CParticleHeap g_ParticleHeap;
	ParticleFixedSizeElementPoolSynchronized g_particlePool;
	ParticleFixedSizeElementPoolSynchronized g_emitterPool;
	ParticleMemoryManager g_particleMemoryManager;
}
