////////////////////////////////////////////////////////////////////////////
//
//  Crytek Engine Source File.
//  Copyright (C), Crytek Studios, 2010.
// -------------------------------------------------------------------------
//  File name:   ParticleMemory.h
//  Version:     v1.00
//  Created:     18/03/2010 by Corey Spink
//  Compilers:   Visual Studio.NET
//  Description: All the particle system's specific memory needs
// -------------------------------------------------------------------------
//  History:
//
////////////////////////////////////////////////////////////////////////////

#ifndef __particlememory_h__
#define __particlememory_h__
#pragma once

#include "PoolAllocator.h"
#include "ParticleSystemConstants.h"
#include "ParticleFixedSizeElementPool.h"
#include "CryPool/PoolAlloc.h"

//////////////////////////////////////////////////////////////////////////
// Specify particle heap allocator.
// Specify heap block size, and for now, allow multiple blocks.
typedef stl::HeapAllocator<stl::PSyncNone, !LIMIT_MEMORY_GROWTH> CParticleHeapBase;
struct CParticleHeap: CParticleHeapBase
{
	CParticleHeap()
		: CParticleHeapBase(PARTICLE_HEAP_SIZE) {}	

};

typedef stl::PoolCommonAllocator<CParticleHeap> ParticleAllocator;

namespace ParticleMemory
{
	class ParticleMemoryManager
	{
	public:
		ParticleMemoryManager()
			: m_particlePoolMemory(NULL)
			, m_emitterPoolMemory(NULL)
		{}
		~ParticleMemoryManager() {}

		void Init(const uint32 a_particleSize, const uint32 a_maxEmitterSize);
		void Reset();

		void GetMemoryUsage(ICrySizer* pSizer);

	private:
		void* m_particlePoolMemory;
		void* m_emitterPoolMemory;
		uint32 m_memoryPoolSize;
	};

	extern CParticleHeap g_ParticleHeap;
	extern ParticleFixedSizeElementPoolSynchronized g_particlePool;
	extern ParticleFixedSizeElementPoolSynchronized g_emitterPool;

	extern ParticleMemoryManager g_particleMemoryManager;

	extern void GetMemoryUsage(ICrySizer *pSizer );
}

#endif // __particlememory_h__
	
