//file acts as Uber-file to include all required SPU files for faster scanning and workaround for missing cross translation unit inlining
#ifdef __SPU__

#define USE_SPU_LOCAL_TIMER

// to activate UpdateParticles, uncomment the USE_SPU defines and
// SPU_ENTRY in particleemitter.cpp and partman.cpp

// scan timer, to provide functions to init spu local timer
#include <platform.h>
#include <ISystem.h>
#include <IVisualLog.h>
#include <IMusicSystem.h>
#include "../CrySystem/Timer.h"
#include "../CryCommon/MTPseudoRandom.cpp"

//duplicate rand function to prevent double inclusion of platform_impl.h (why can't crycg see these???)
ILINE uint32 cry_rand32()
{
	return gSpuRandomNumberGen.Generate();
}
ILINE unsigned int cry_rand()
{	
	return gSpuRandomNumberGen.Generate() & RAND_MAX; 
}
ILINE float cry_frand()
{	
	return gSpuRandomNumberGen.GenerateFloat();
}


// use a global var on SPU, to transport the renderefameID from the entry function
// to the CreateCachePos function used for CRenderMesh2::GetRandomPos (used for some particles)
class CDevBufferMan;
SPU_LOCAL int gRendererFrameID = 0;
SPU_LOCAL SPU_DOMAIN_MAIN CDevBufferMan *g_pDevBufMan = NULL;

// == Compute Vertices Job == //
#include "partpolygon.cpp"
#include "ParticleEmitter.cpp"
#include "ParticleSubEmitter.cpp"
#include "ParticleContainer.cpp"
#include "VisAreas.cpp"																

// == UpdateParticles Job == //
#include "particle.cpp"
#include "ParticleEnviron.cpp"
#include "terrain_hmap.cpp"
#include "ParticleEffect.cpp"		

// == common stuff mostly needed in UpdateParticles == //
#include "StatObjConstr.cpp"
#include "SurfaceTypeManager.cpp"
#include "Material.h"

class CCryDXPSRenderDevice;
class CCryDXPSBuffer;

#ifndef DIRECT3D10
	#define DIRECT3D10
#endif
#define D3DDevice ID3D11Device
#define D3DVertexBuffer ID3D11Buffer
#define D3DIndexBuffer ID3D11Buffer
class CCryDXPSResource;
class D3D11_BUFFER_DESC;
#include "../RenderDll/XRenderD3D9/DXPS/Layer0/CCryDXPS.hpp"
#include "../RenderDll/XRenderD3D9/DXPS/Device/Resource/Buffer/CCryDXPSBuffer.hpp"
#include "../RenderDll/XRenderD3D9/DXPS/CCryDXPSMisc.hpp"
#include "../RenderDll/Common/DevBuffer.h"
#include "../RenderDll/Common/RenderMesh2.h"

#include "ParticleFixedSizeElementPool.cpp"

#include UNIQUE_VIRTUAL_WRAPPER(IMaterial)
#include UNIQUE_VIRTUAL_WRAPPER(IRenderMesh)
#include UNIQUE_VIRTUAL_WRAPPER(IMaterialLayer)
#include UNIQUE_VIRTUAL_WRAPPER(IMaterialManager)

#endif //__SPU__