////////////////////////////////////////////////////////////////////////////
//
//  Crytek Engine Source File.
//  Copyright (C), Crytek Studios, 2010.
// -------------------------------------------------------------------------
//  File name:   ParticleSystemConstants.h
//  Version:     v1.00
//  Created:     19/03/2010 by Corey Spink
//  Compilers:   Visual Studio.NET
//  Description: All the defines to control max sizes of structures, memory pools, etc
// -------------------------------------------------------------------------
//  History:
//
////////////////////////////////////////////////////////////////////////////

#ifndef __particlesystemconstants_h__
#define __particlesystemconstants_h__
#pragma once

static const size_t PARTICLE_HEAP_SIZE = 1*1024*1024;
static const bool LIMIT_MEMORY_GROWTH = false;

#if defined(_PS3) || defined(XENON)
static const size_t PARTICLE_POOL_MEMORY_SIZE = (size_t)(2.25f*1024.0f*1024.0f);
static const size_t LOC_SUB_EMITTER_POOL_MEMORY_SIZE = (size_t)(0.75f*1024.0f*1024.0f);
#else
static const size_t PARTICLE_POOL_MEMORY_SIZE = (size_t)(15.0f*1024.0f*1024.0f);
static const size_t LOC_SUB_EMITTER_POOL_MEMORY_SIZE = (size_t)(5.0f*1024.0f*1024.0f);
#endif 

#define PARTICLE_ALIGNMENT (uint32)128
#define LOC_EMITTER_ALIGNMENT (uint32)16
#define SUB_EMITTER_ALIGNMENT (uint32)16

#endif // __particlesystemconstants_h__
