#############################################################################
## Crytek Source File
## Copyright (C) 2006, Crytek Studios
##
## Creator: Sascha Demetrio
## Date: Jul 31, 2006
## Description: GNU-make based build system
#############################################################################

PROJECT_TYPE := module
PROJECT_VCPROJ := Cry3DEngine.vcproj

-include $(PROJECT_CODE)/Project_override.mk

PROJECT_CPPFLAGS_COMMON += \
	-I$(CODE_ROOT)/CryEngine/CryCommon \
	-I$(CODE_ROOT)/Tools/PS3JobManager

ifeq ($(OPTION_PROFILE),1)
  PROJECT_XFLAGS += -O2 $(PS3_MATHOPT)
endif

ifeq ($(MKOPTION_UNITYBUILD),1)
PROJECT_SOURCES_CPP_REMOVE := StdAfx.cpp \
	CGF/CGFLoader.cpp \
	CGF/CGFSaver.cpp \
	CGF/ChunkFile.cpp \
	CGF/ReadOnlyChunkFile.cpp \
	MeshCompiler/MeshCompiler.cpp \
	MeshCompiler/NvTriStrip/NvTriStrip.cpp \
	MeshCompiler/NvTriStrip/NvTriStripObjects.cpp \
	COcclusionCuller.cpp \
	COcclusionCullerClipper.cpp \
	COcclusionCullerPoly.cpp \
	CullBuffer.cpp \
	cbuffer.cpp \
	CZBufferCuller.cpp \
	3DEngineLight.cpp \
	3DEngineRender.cpp \
	3dEngine.cpp \
	3dEngineLoad.cpp \
	3dEngineMerge.cpp \
	BasicArea.cpp \
	Brush.cpp \
	BrushLM.cpp \
	CRAMSolution.cpp \
	CVoxDataNode.cpp \
	CVoxMeshNode.cpp \
	CloudsManager.cpp \
	ColorBleeding.cpp \
	Cry3DEngine.cpp \
	Decal.cpp \
	DecalManager.cpp \
	IndexedMesh.cpp \
	IsoMesh.cpp \
	LMSerializationManager.cpp \
	LightEntity.cpp \
	MatMan.cpp \
	Material.cpp \
	ObjectsTree.cpp \
	ObjectsTree_Serialize.cpp \
	PhysCallbacks.cpp \
	PostProcessEffects.cpp \
	RenderMeshMerger.cpp \
	RenderMeshUtils.cpp \
	SkyLightManager.cpp \
	SkyLightNishita.cpp \
	SurfaceTypeManager.cpp \
	TerrainModifications.cpp \
	TerrainTextureCache.cpp \
	TimeOfDay.cpp \
	Vegetation.cpp \
	VisAreaCompile.cpp \
	VisAreaMan.cpp \
	VisAreaManCompile.cpp \
	VisAreas.cpp \
	cvars.cpp \
	RoadRenderNode.cpp \
	RopeRenderNode.cpp \
	AutoCubeMapRenderNode.cpp \
	DecalRenderNode.cpp \
	DistanceCloudRenderNode.cpp \
	FogVolumeRenderNode.cpp \
	IrradianceVolumeRenderNode.cpp \
	PrismRenderNode.cpp \
	WaterWaveRenderNode.cpp \
	CloudRenderNode.cpp \
	StatObjConstr.cpp \
	StatObjFar.cpp \
	StatObjLoad.cpp \
	StatObjPhys.cpp \
	StatObjRend.cpp \
	StatObjStream.cpp \
	ObjMan.cpp \
	ObjManCullQueue.cpp \
	ObjManDraw.cpp \
	ObjManDrawEntity.cpp \
	ObjManFar.cpp \
	ObjManShadows.cpp \
	ObjManStreaming.cpp \
	ObjectsTree_MT.cpp \
	VolumeObjectDataCreate.cpp \
	VolumeObjectRenderNode.cpp \
	VoxLM.cpp \
	VoxMan.cpp \
	VoxNodeSerialize.cpp \
	VoxTerrain.cpp \
	WaterVolumeRenderNode.cpp \
	WaterVolumes.cpp \
	particle.cpp \
	partman.cpp \
	ParticleEffect.cpp \
	ParticleEmitter.cpp \
	ParticleEnviron.cpp \
	partpolygon.cpp \
	polygonize.cpp \
	terrain.cpp \
	terrain_compile.cpp \
	terrain_damage.cpp \
	terrain_det_tex.cpp \
	terrain_hmap.cpp \
	terrain_hmap_occlusion.cpp \
	terrain_init.cpp \
	terrain_light.cpp \
	terrain_load.cpp \
	terrain_node.cpp \
	terrain_node_compile.cpp \
	terrain_panorama.cpp \
	terrain_render.cpp \
	terrain_sector.cpp \
	terrain_sector_beach.cpp \
	terrain_sector_render.cpp \
	terrain_sector_tex.cpp \
	terrain_voxel.cpp \
	terrain_water_quad.cpp \
	terran_edit.cpp \
	VoxManMatGroup.cpp \
	ParticleMemory.cpp \
	ParticleFixedSizeElementPool.cpp \
	ParticleContainer.cpp \
	3DEngineMemory.cpp

ifeq ($(MKOPTION_SNC),1)
	PROJECT_SOURCES_CPP_REMOVE += ObjectsTree_Serialize.cpp
endif

PROJECT_SOURCES_CPP_ADD += \
	Cry3DEngine_main_uber.cpp\
	Cry3DEngine_main2_uber.cpp\
	Cry3DEngine_obj_uber.cpp\
	Cry3DEngine_volume_uber.cpp\
	Cry3DEngine_cull_cgf_rend_terrain_uber.cpp\
	Cry3DEngine_particles_uber.cpp
endif

# Disabled for cm_backend builds for now 
ifneq ($(MKOPTION_CRYCG_CM),1)
PROJECT_SCAN_CPP := Cry3DEngineSPU.cpp ParticleSpu.cpp
endif 

#PROJECT_XFLAGS := -O0 -g

# vim:ts=8:sw=2
