////////////////////////////////////////////////////////////////////////////
//
//  Crytek Engine Source File.
//  Copyright (C), Crytek Studios, 2002.
// -------------------------------------------------------------------------
//  File name:   statobjconstr.cpp
//  Version:     v1.00
//  Created:     28/5/2001 by Vladimir Kajalin
//  Compilers:   Visual Studio.NET
//  Description: loading
// -------------------------------------------------------------------------
//  History:
//
////////////////////////////////////////////////////////////////////////////

#include "StdAfx.h"

#include "StatObj.h"
#include "IndexedMesh.h"
#include "../RenderDll/Common/Shadow_Renderer.h"
#include <IRenderer.h>
#include <CrySizer.h>

#include "CGF/CGFLoader.h"
#include "CGF/CGFSaver.h"
#include "CGF/ReadOnlyChunkFile.h"

#define GEOM_INFO_FILE_EXT "ginfo"
#define MESH_NAME_FOR_MAIN "main"

extern const char* stristr(const char* szString, const char* szSubstring);

extern void TransformMesh( CMesh &mesh,Matrix34 tm );

void CStatObj::StreamAsyncOnComplete(IReadStream* pStream, unsigned nError)
{
  FUNCTION_PROFILER_3DENGINE;
	pStream->SetUserData((DWORD_PTR)NULL);

	if(pStream->IsError())
	{ // file was not loaded successfully
    m_eStreamingStatus = ecss_Ready;
    Error("CStatObj::StreamAsyncOnComplete: Error loading CGF: %s Error# %d", m_szFileName.c_str(), nError);
		return;
	}

	ObjMeshPairs* pObjMeshPairs = GetTemporaryPool()->New<ObjMeshPairs>();

  if(!LoadCGF_RenderMeshOnly( pStream->GetBuffer(), pStream->GetBytesRead(), pObjMeshPairs ))
  {
    Error("CStatObj::StreamOnComplete_LoadCGF_FromMemBlock, filename=%s", m_szFileName.c_str());
  }

	pStream->SetUserData((DWORD_PTR)pObjMeshPairs);
}

void CStatObj::StreamOnComplete(IReadStream* pStream, unsigned nError)
{
	FUNCTION_PROFILER_3DENGINE;
	ObjMeshPairs* pObjMeshPairs = (ObjMeshPairs*)pStream->GetParams().dwUserData;

	if(pStream->IsError())
	{ // file was not loaded successfully
		if(pObjMeshPairs)
		{
			for(ObjMeshPairs::iterator it = pObjMeshPairs->begin();it != pObjMeshPairs->end();++it)
      {
        GetRenderer()->DeleteRenderMesh(it->second);
      }
			GetTemporaryPool()->Delete(pObjMeshPairs);
			pStream->SetUserData((DWORD_PTR)NULL);
		}
		m_eStreamingStatus = ecss_NotLoaded;
		Error("CStatObj::StreamOnComplete: Error loading CGF: %s Error# %d", m_szFileName.c_str(), nError);
		return;
	}

	if(pObjMeshPairs == NULL)
	{
		m_eStreamingStatus = ecss_NotLoaded;
		assert(0);
		Error("CStatObj::StreamOnComplete: Error postprocessing CGF: %s", m_szFileName.c_str());
		return;
	}

  for(uint32 nGroupId=0; nGroupId<m_pObjManager->m_lstStaticTypes.size(); nGroupId++)
  {
    StatInstGroup & rGroup = m_pObjManager->m_lstStaticTypes[nGroupId];
    if(rGroup.pStatObj == this)
      rGroup.Update(GetCVars(), Get3DEngine()->GetGeomDetailScreenRes());
  }

  m_eStreamingStatus = ecss_Ready;

	// setting up render meshes
	for(ObjMeshPairs::iterator it = pObjMeshPairs->begin();it != pObjMeshPairs->end();++it)
	{
		if(it->first)
			it->first->SetRenderMesh(it->second);
	}

	GetTemporaryPool()->Delete(pObjMeshPairs);

  m_pReadStream = 0;
}

//////////////////////////////////////////////////////////////////////////
void CStatObj::StartStreaming( bool bFinishNow, IReadStream_AutoPtr* ppStream )
{
  assert(!m_pParentObject);

  assert(m_eStreamingStatus == ecss_NotLoaded);

	if(m_eStreamingStatus != ecss_NotLoaded)
		return;

  // start streaming
	StreamReadParams params;
	params.dwUserData = 0;
	params.nSize = 0;
	params.pBuffer = NULL;
	params.nLoadTime = 10000;
	params.nMaxLoadTime = 10000;
	params.nFlags |= SRP_FLAGS_ASYNC_PROGRESS;

#ifdef _DEBUG
	params.nFlags |= SRP_FLAGS_FORCE_SYNC_CALLBACKS;
#endif

  if(m_szFileName.empty())
  {
    assert(!"CStatObj::StartStreaming: CGF name is empty");
    m_eStreamingStatus = ecss_Ready;
		if(ppStream)*ppStream = NULL;
    return;
  }

#if defined(PS3) && 0
  MTrace::EnableThreadBreak();
#endif 
	m_pReadStream = GetSystem()->GetStreamEngine()->StartRead(eStreamTaskTypeGeometry, m_szFileName, this, &params);
#if defined(PS3) && 0
  MTrace::DisableThreadBreak();
#endif 

	if(ppStream)
		(*ppStream) = m_pReadStream;
	if(!bFinishNow)
		m_eStreamingStatus = ecss_InProgress;
	else if(!ppStream)
		m_pReadStream->Wait();
}

void CStatObj::ReleaseStreamableContent()
{
  assert(!m_pParentObject);

  bool bLodsAreLoadedFromSeparateFile = m_pLod0 ? m_pLod0->m_bLodsAreLoadedFromSeparateFile : m_bLodsAreLoadedFromSeparateFile;

  if(!bLodsAreLoadedFromSeparateFile)
  {
    for(int nLod = 0; nLod<MAX_STATOBJ_LODS_NUM; nLod++)
    {
      CStatObj * pLod = (CStatObj*)GetLodObject(nLod);

      if(!pLod)
        continue;

      pLod->SetRenderMesh(0);
      pLod->FreeFoliageData();
      pLod->m_eStreamingStatus = ecss_NotLoaded;

      if(pLod->m_pParentObject)
      {
        pLod->m_pParentObject->SetRenderMesh(0);
        pLod->m_pParentObject->FreeFoliageData();
        pLod->m_pParentObject->m_eStreamingStatus = ecss_NotLoaded;
      }
    }
  }

  for(int s=0; s<GetSubObjectCount(); s++)
  {
    SSubObject & sub = *GetSubObject(s);
    if(!sub.pStatObj)
      continue;

    if(bLodsAreLoadedFromSeparateFile)
    {
      CStatObj * pSubLod = (CStatObj*)sub.pStatObj;

      if(!pSubLod)
        continue;

      pSubLod->SetRenderMesh(0);
      pSubLod->FreeFoliageData();
      pSubLod->m_eStreamingStatus = ecss_NotLoaded;

      if(pSubLod->m_pParentObject)
      {
        pSubLod->m_pParentObject->SetRenderMesh(0);
        pSubLod->m_pParentObject->FreeFoliageData();
        pSubLod->m_pParentObject->m_eStreamingStatus = ecss_NotLoaded;
      }
    }
    else
    {
      for(int nLod = 0; nLod<MAX_STATOBJ_LODS_NUM; nLod++)
      {
        CStatObj * pSubLod = (CStatObj*)sub.pStatObj->GetLodObject(nLod);

        if(!pSubLod)
          continue;

        pSubLod->SetRenderMesh(0);
        pSubLod->FreeFoliageData();
        pSubLod->m_eStreamingStatus = ecss_NotLoaded;

        if(pSubLod->m_pParentObject)
        {
          pSubLod->m_pParentObject->SetRenderMesh(0);
          pSubLod->m_pParentObject->FreeFoliageData();
          pSubLod->m_pParentObject->m_eStreamingStatus = ecss_NotLoaded;
        }
      }
    }
  }         

  SetRenderMesh(0);
  FreeFoliageData();

  UnMergeSubObjectsRenderMeshes();

  m_eStreamingStatus = ecss_NotLoaded;
}

int CStatObj::GetStreamableContentMemoryUsage()
{
  assert(!m_pParentObject);

  bool bLodsAreLoadedFromSeparateFile = m_pLod0 ? m_pLod0->m_bLodsAreLoadedFromSeparateFile : m_bLodsAreLoadedFromSeparateFile;
  bool bCountLods = !bLodsAreLoadedFromSeparateFile;

  if(m_arrRenderMeshesPotentialMemoryUsage[bCountLods]<0)
  {
    int nCount=0;

    if(bCountLods)
    {
      if(m_pLODs)
        for(int nLod = 1; nLod<MAX_STATOBJ_LODS_NUM; nLod++)
      {
        CStatObj * pLod = (CStatObj*)m_pLODs[nLod];

        if(!pLod)
          continue;

        nCount += pLod->m_nRenderMeshMemoryUsage;
      }
    }

    nCount += m_nRenderMeshMemoryUsage;

    for(int s=0; s<GetSubObjectCount(); s++)
    {
      SSubObject & sub = *GetSubObject(s);
      
      if(!sub.pStatObj)
        continue;

      if(bCountLods)
      {
        CStatObj *pSubStatObj = (CStatObj*)sub.pStatObj;
        if(pSubStatObj->m_pLODs)
        {
          for(int nLod = 1; nLod<MAX_STATOBJ_LODS_NUM; nLod++)
          {
            CStatObj *pSubLod = pSubStatObj->m_pLODs[nLod];

            if(!pSubLod)
              continue;

            nCount += pSubLod->m_nRenderMeshMemoryUsage;
          }
        }
      }

      nCount += ((CStatObj*)sub.pStatObj)->m_nRenderMeshMemoryUsage;
    }         

    m_arrRenderMeshesPotentialMemoryUsage[bCountLods] = nCount;
  }

  if(m_pMergedObject)
  {
    if( IRenderMesh * pRM = m_pMergedObject->GetRenderMesh() )
      m_nMergedMemoryUsage = pRM->GetVerticesCount()*(sizeof(SPipTangents) + sizeof(SVF_P3S_C4B_T2S)) + pRM->GetIndicesCount()*sizeof(uint16);
    else
      m_nMergedMemoryUsage = 0;
  }
  else
  if(!GetCVars()->e_StatObjMerge)
  {
    m_nMergedMemoryUsage = 0;
  }

  return m_nMergedMemoryUsage + m_arrRenderMeshesPotentialMemoryUsage[bCountLods];
}

void CStatObj::UpdateStreamingPrioriryInternal(const Matrix34A & objMatrix, float fImportance)
{
  int nRoundId = GetObjManager()->m_nUpdateStreamingPrioriryRoundId;

  if(m_pParentObject && m_bSubObject) 
  { // stream parent for sub-objects
    m_pParentObject->UpdateStreamingPrioriryInternal(objMatrix, fImportance);
  }
  else if(!m_bSubObject)
  { // stream object itself
    if(m_bUseStreaming)
    {
      if(UpdateStreamingPrioriryLowLevel(fImportance, nRoundId))
        GetObjManager()->RegisterForStreaming(this);
    }
  }
  else if(m_pLod0)
  { // sub-object lod without parent
    m_pLod0->UpdateStreamingPrioriryInternal(objMatrix, fImportance);
    assert(!m_pLod0->m_bLodsAreLoadedFromSeparateFile);
  }
  else if(m_bUseStreaming)
    assert(!"Invalid CGF hierarchy");
}

void CStatObj::UpdateSubObjectsMerging()
{
  if (m_nFlags & STATIC_OBJECT_HIDDEN)
    return;

  if(m_eStreamingStatus != ecss_Ready)
    return;

  // sub meshes merging
  if (GetCVars()->e_StatObjMerge)
  {
    if (!m_bMerged && !m_bUnmergable)
      MergeSubObjectsRenderMeshes();
  }
  else
  {
    if(m_bMerged)
      UnMergeSubObjectsRenderMeshes();
  }
}

bool CStatObj::UpdateStreamableComponents(float fImportance, Matrix34A & objMatrix, IRenderNode * pRenderNode, float fEntDistance)
{
  FUNCTION_PROFILER_3DENGINE;

  if(m_nFlags&STATIC_OBJECT_HIDDEN)
    return false;

  if ((m_nFlags & STATIC_OBJECT_COMPOUND) && SubObjectCount())
  {
    for(int s=0,num = SubObjectCount(); s<num; s++)
    {
      IStatObj::SSubObject &subObj = SubObject(s);

      if (subObj.pStatObj && !subObj.bHidden && subObj.nType == STATIC_SUB_OBJECT_MESH)
      {
        Matrix34 subObjMatrix = objMatrix * subObj.tm;

        CStatObj *pSubStatObj = ((CStatObj*)subObj.pStatObj);

        if(pSubStatObj->m_nLoadedTrisCount<3)
          continue;

        int nNewLod = pSubStatObj->GetLod(subObjMatrix, fEntDistance, pRenderNode);

        for(int l=nNewLod; l<=(nNewLod+1) && l<MAX_STATOBJ_LODS_NUM; l++)
          if(CStatObj * pLod = (CStatObj *)pSubStatObj->GetLodObject(l))
            pLod->UpdateStreamingPrioriryInternal(objMatrix, fImportance);
      }
    }
  }
  else if(m_nLoadedTrisCount>=3)
  {
    Matrix34 objMatrixNA = objMatrix;

    int nNewLod = GetLod(objMatrixNA, fEntDistance, pRenderNode);

    for(int l=nNewLod; l<=(nNewLod+1) && l<MAX_STATOBJ_LODS_NUM; l++)
      if(CStatObj * pLod = (CStatObj *)GetLodObject(l))
        pLod->UpdateStreamingPrioriryInternal(objMatrix, fImportance);
  }

  return true;
}

int CStatObj::FindNearesLoadedLOD(int nLodIn, const SRendParams & rParams)
{
  // make sure requested lod is loaded
/*  if(CStatObj * pObjForStreamIn = nLodIn ? m_pLODs[nLodIn] : this)
  {
    bool bRenderNodeValid(rParams.pRenderNode && ((int)(void*)(rParams.pRenderNode)>0) && rParams.pRenderNode->m_fWSMaxViewDist);
    float fImportance = bRenderNodeValid ? (1.f - (rParams.fDistance / rParams.pRenderNode->m_fWSMaxViewDist)) : 0.5f;
    pObjForStreamIn->UpdateStreamingPrioriryInternal(fImportance);
  }*/

  // if requested lod is not ready - find nearest ready one
  int nLod = nLodIn;

  if(nLod==0 && !GetRenderMesh())
    nLod++;

  while(nLod && nLod<MAX_STATOBJ_LODS_NUM && (!m_pLODs || !m_pLODs[nLod] || !m_pLODs[nLod]->GetRenderMesh()))
    nLod++;

  if(nLod>=MAX_STATOBJ_LODS_NUM)
    nLod = nLodIn;

  return nLod;
}
