////////////////////////////////////////////////////////////////////////////
//
//  Crytek Engine Source File.
//  Copyright (C), Crytek Studios, 2002.
// -------------------------------------------------------------------------
//  File name:   terrain_det_tex.cpp
//  Version:     v1.00
//  Created:     28/5/2001 by Vladimir Kajalin
//  Compilers:   Visual Studio.NET
//  Description: terrain detail textures
// -------------------------------------------------------------------------
//  History:
//
////////////////////////////////////////////////////////////////////////////

#include "StdAfx.h"
#include "terrain.h"
#include "terrain_sector.h"
#include "3dEngine.h"
#include "VoxMan.h"
#include "IndexedMesh.h"
#include "MeshCompiler/MeshCompiler.h"
#include "VoxTerrain.h"

#if 0

int CVoxMeshNode::SaveMesh(CMemoryBlock * pMemBlock, EEndian eEndian)
{
  if(!m_pVoxObj)
    return 0;

  if(!m_pVoxObj->GetRenderMesh(0) || !m_pVoxObj->GetRenderMesh(0)->GetSysIndicesCount())
    return 0;

  if(!pMemBlock)
    return m_pVoxObj->GetCompiledMeshDataSize();

  int nSize=0;
  byte * pMesh = m_pVoxObj->GetCompiledMeshData(nSize, eEndian);
  pMemBlock->SetData(pMesh, nSize);
  delete[] pMesh;

  return nSize;
}

int CVoxMeshNode::SaveTexture(CMemoryBlock * pMemBlock, EEndian eEndian)
{
  if(!m_pVoxObj)
    return 0;

  if(!m_pVoxObj->GetRenderMesh(0) || !m_pVoxObj->GetRenderMesh(0)->GetSysIndicesCount() || !m_pVoxObj->m_pNodeTex)
    return 0;

  int nWidth = m_pVoxObj->m_pNodeTex->GetWidth();

  int nSize = nWidth*nWidth*sizeof(ColorB);

  if(pMemBlock)
  {
    byte * pImage = new byte[nSize];
    pImage = m_pVoxObj->m_pNodeTex->GetData32(0,0,pImage);
    pMemBlock->SetData(pImage, nSize);
    delete [] pImage;
  }

  return nSize;
}

void CVoxMeshNode::LoadMesh(CMemoryBlock * pMemBlock, EEndian eEndian, bool bDataIsAlligned)
{
//  PrintMessage("Loading terrain node mesh (size = %d) ...", (int)m_fNodeSize);

  InitVoxelObject();

  m_pVoxObj->SetCompiledMeshData((byte*)pMemBlock->GetData(), pMemBlock->GetSize(), eEndian, bDataIsAlligned);

  m_pVoxTerrain->m_rebuildLine.Delete(this);
}

void CVoxMeshNode::LoadTexture(CMemoryBlock * pMemBlock, EEndian eEndian)
{
  int nTexDim = (int)sqrtf((float)(pMemBlock->GetSize()/sizeof(ColorB)));

//  PrintMessage("Loading terrain node texture (size = %dx%d) ...", nTexDim, nTexDim);

  assert(nTexDim*nTexDim*sizeof(ColorB) == pMemBlock->GetSize());

  ETEX_Format eTexFormat = eTF_A8R8G8B8;

  int nTexId = m_pVoxObj->m_pNodeTex ? m_pVoxObj->m_pNodeTex->GetTextureID() : 0;
  nTexId = GetRenderer()->DownLoadToVideoMemory((byte*)pMemBlock->GetData(), nTexDim, nTexDim, 
    eTexFormat, eTexFormat, 0, false, FILTER_NONE, nTexId);

  m_pVoxObj->m_pNodeTex = GetRenderer()->EF_GetTextureByID(nTexId);

//  PrintMessagePlus(" ok");
}

int CVoxMeshNode::Save(byte * & pData, int & nDataSize, bool bSaveMesh, EEndian eEndian)
{
  if(pData)
  {
    // get node data
    SVoxNodeMeshChunk * pCunk = (SVoxNodeMeshChunk*)pData;
    pCunk->ucVersion = VOXNODE_MESH_CHUNK_VERSION;

    // fill ChildsMask
    pCunk->ucChildsMask = 0;
    for(int i=0; i<8; i++)
      if(m_arrChilds[i])
        pCunk->ucChildsMask |= (1<<i);

    UPDATE_PTR_AND_SIZE(pData,nDataSize,sizeof(SVoxNodeMeshChunk));

    if(bSaveMesh)
    {
      { // export mesh
        CMemoryBlock memblock;
        SaveMesh(&memblock, eEndian);
        pCunk->nMeshBlockSize = memblock.GetSize();
        memcpy(pData, memblock.GetData(), memblock.GetSize()); 
        UPDATE_PTR_AND_SIZE(pData,nDataSize,memblock.GetSize());
      }
      { // export texture
        CMemoryBlock memblock;
        SaveTexture(&memblock, eEndian);
        pCunk->nTextureBlockSize = memblock.GetSize();
        memcpy(pData, memblock.GetData(), memblock.GetSize()); 
        UPDATE_PTR_AND_SIZE(pData,nDataSize,memblock.GetSize());
      }
    }
    else
    {
      pCunk->nMeshBlockSize=0;
      pCunk->nTextureBlockSize=0;
    }
  }
  else // just count size
  {
    nDataSize += sizeof(SVoxNodeMeshChunk);
    if(bSaveMesh)
    {
      nDataSize += SaveMesh(NULL, eEndian);
      nDataSize += SaveTexture(NULL, eEndian);
    }
  }

  // count number of nodes loaded
  int nNodesNum = 1;

  // process childs
  for(int i=0; i<8; i++)
    if(m_arrChilds[i])
      nNodesNum += m_arrChilds[i]->Save(pData, nDataSize, bSaveMesh, eEndian);

  return nNodesNum;
}
/*
int CVoxDataNode::Save(byte * & pData, int & nDataSize, EEndian eEndian)
{
  if(pData)
  {
    // get node data
    SVoxNodeDataChunk * pCunk = (SVoxNodeDataChunk*)pData;
    pCunk->fChildsSumm = m_fIsoVal;
    pCunk->ucMatId = m_nMatId;

    // fill ChildsMask
    pCunk->ucChildsMask = 0;
    for(int i=0; i<8; i++)
      if(m_arrChilds[i])
        pCunk->ucChildsMask |= (1<<i);

    UPDATE_PTR_AND_SIZE(pData,nDataSize,sizeof(SVoxNodeDataChunk));
  }
  else // just count size
  {
    nDataSize += sizeof(SVoxNodeDataChunk);
  }

  // count number of nodes loaded
  int nNodesNum = 1;

  // process childs
  for(int i=0; i<8; i++)
    if(m_arrChilds[i])
      nNodesNum += m_arrChilds[i]->Save(pData, nDataSize, eEndian);

  return nNodesNum;
}
*/
int CVoxMeshNode::Load(FILE * & f, int & nDataSize, bool bUpdateMesh, EEndian eEndian) { return Load_T(f, nDataSize, bUpdateMesh, eEndian); }
int CVoxMeshNode::Load(uint8 * & f, int & nDataSize, bool bUpdateMesh, EEndian eEndian) { return Load_T(f, nDataSize, bUpdateMesh, eEndian); }
/*
int CVoxDataNode::Load(FILE * & f, int & nDataSize, EEndian eEndian) { return Load_T(f, nDataSize, eEndian); }
int CVoxDataNode::Load(uint8 * & f, int & nDataSize, EEndian eEndian) { return Load_T(f, nDataSize, eEndian); }
*/
template <class T> int CVoxMeshNode::Load_T(T * & f, int & nDataSize, bool bUpdateMesh, EEndian eEndian)
{
  SVoxNodeMeshChunk chunk;
  if(!CTerrain::LoadDataFromFile(&chunk, 1, f, nDataSize, eEndian))
    return 0;

  assert(chunk.ucVersion == VOXNODE_MESH_CHUNK_VERSION);
  if(chunk.ucVersion != VOXNODE_MESH_CHUNK_VERSION)
    return 0;

  m_fNodeSize = m_nodeBox.GetSize().z;

  static CMemoryBlock mbLoadingCache;

  if(chunk.nMeshBlockSize + chunk.nTextureBlockSize)
    PrintMessage("Loading terrain node (%d kb) ... ", (int)(chunk.nMeshBlockSize + chunk.nTextureBlockSize)/1024);

  if(chunk.nMeshBlockSize)
  {
    mbLoadingCache.Allocate(chunk.nMeshBlockSize);

    if(!CTerrain::LoadDataFromFile((uint8*)mbLoadingCache.GetData(), chunk.nMeshBlockSize, f, nDataSize, eEndian))
      return 0;

    LoadMesh(&mbLoadingCache, eEndian, true);
  }

  if(chunk.nTextureBlockSize)
  {
    mbLoadingCache.Allocate(chunk.nTextureBlockSize);

    if(!CTerrain::LoadDataFromFile((uint8*)mbLoadingCache.GetData(), chunk.nTextureBlockSize, f, nDataSize, eEndian))
      return 0;

    LoadTexture(&mbLoadingCache, eEndian);
  }

  if(chunk.nMeshBlockSize + chunk.nTextureBlockSize)
    PrintMessagePlus(" ok");

  // count number of nodes loaded
  int nNodesNum = 1;

  // process childs
  for(int nChildId=0; nChildId<8; nChildId++)
  {
    if(chunk.ucChildsMask & (1<<nChildId))
    {
      if(!m_arrChilds[nChildId])
        m_arrChilds[nChildId] = new CVoxMeshNode(GetChildBBox(nChildId), this);

      int nNewNodesNum = m_arrChilds[nChildId]->Load_T(f, nDataSize, bUpdateMesh, eEndian);

      if(!nNewNodesNum)
        return 0; // data error

      nNodesNum += nNewNodesNum;
    }
  }

  if(bUpdateMesh)
    if(!HasChilds())
      ScheduleRebuild();

  return nNodesNum;
}
/*
template <class T> int CVoxDataNode::Load_T(T * & f, int & nDataSize, EEndian eEndian)
{
  SVoxNodeDataChunk chunk;
  if(!CTerrain::LoadDataFromFile(&chunk, 1, f, nDataSize, eEndian))
    return 0;

  m_fIsoValPrev = m_fIsoVal = chunk.fChildsSumm;
  m_nMatId = chunk.ucMatId;

  // count number of nodes loaded
  int nNodesNum = 1;

  // process childs
  for(int nChildId=0; nChildId<8; nChildId++)
  {
    if(chunk.ucChildsMask & (1<<nChildId))
    {
      if(!m_arrChilds[nChildId])
        m_arrChilds[nChildId] = new CVoxDataNode(m_nMatId);

      int nNewNodesNum = m_arrChilds[nChildId]->Load_T(f, nDataSize, eEndian);

      if(!nNewNodesNum)
        return 0; // data error

      nNodesNum += nNewNodesNum;
    }
  }

  return nNodesNum;
}*/

#endif