/////////////////////////////////////////////////////////////////////////////////////////
//
//  Crytek Engine Source File.
//  Copyright (C), Crytek Studios, 2009.
// --------------------------------------------------------------------------------------
//  File name:   Adapters.h
//  Created:     02/02/2009 by Matthew
//  Description: Implements adapters for AI objects from external interfaces to internal
//               This is purely a translation layer without concrete instances
//               They can have no state and must remain abstract
//
//               * Note that this is fast becoming redundant! Mainly shells now *
//
// --------------------------------------------------------------------------------------
//  History:
//
/////////////////////////////////////////////////////////////////////////////////////////

#ifndef __AI_ADAPTERS_H_
#define __AI_ADAPTERS_H_

#pragma once

#include <IAgent.h>
#include "AIObject.h"
#include "Reference.h"

#include <IAIGroup.h>

CWeakRef<CAIObject> GetWeakRefSafe(IAIObject * pObj);


class CPipeUserAdapter
	: public IPipeUser
{
public:
	virtual ~CPipeUserAdapter() {}

	virtual void SetAttentionTarget(CWeakRef<CAIObject> refTarget) = 0;
	virtual bool SelectPipe(int id, const char *name, CWeakRef<CAIObject> refArgument, int goalPipeId = 0, bool resetAlways = false)=0;
	virtual IGoalPipe* InsertSubPipe(int id, const char *name, CWeakRef<CAIObject> refArgument = NILREF, int goalPipeId = 0)=0;

private:
	void SetAttentionTarget(IAIObject *pObject) 
		{ CCCPOINT(CPipeUserInterface_SetAttentionTarget); this->SetAttentionTarget(	GetWeakRefSafe(pObject) ); }
	bool SelectPipe(int id, const char *name, IAIObject *pArgument = 0, int goalPipeId = 0, bool resetAlways = false)
		{ return SelectPipe( id, name, GetWeakRefSafe(pArgument), goalPipeId, resetAlways ); }
	IGoalPipe* InsertSubPipe(int id, const char *name, IAIObject *pArgument = 0, int goalPipeId = 0)
		{ return InsertSubPipe( id, name, GetWeakRefSafe(pArgument), goalPipeId); }

};

class CPuppetAdapter
	: public IPuppet
{
public:
	virtual ~CPuppetAdapter() {};

};

class CAIVehicleAdapter
	: public IAIVehicle
{
public:
	virtual ~CAIVehicleAdapter()  {};
};

class CAIGroupAdapter
	: public IAIGroup
{
public:
	virtual CWeakRef<CAIObject>	GetAttentionTarget(bool bHostileOnly=false, bool bLiveOnly=false, const CWeakRef<CAIObject> refSkipTarget = NILREF) const = 0;

private:
	IAIObject*	GetAttentionTarget(bool bHostileOnly=false, bool bLiveOnly=false) const;
};

#endif //__AI_ADAPTERS_H_