#############################################################################
## Crytek Source File
## Copyright (C) 2006, Crytek Studios
##
## Creator: Sascha Demetrio
## Date: Jul 31, 2006
## Description: GNU-make based build system
#############################################################################

PROJECT_TYPE := module
PROJECT_VCPROJ := CryAISystem.vcproj

-include $(PROJECT_CODE)/Project_override.mk

PROJECT_CPPFLAGS_COMMON += \
	-I$(CODE_ROOT)/CryEngine/CryCommon \
	-I$(CODE_ROOT)/Sandbox/Editor/AI/NavDataGeneration/LayeredNavMesh

ifeq ($(MKOPTION_UNITYBUILD),1)
PROJECT_SOURCES_CPP_REMOVE := StdAfx.cpp \
	BehaviorTree/ActivationConditions.cpp \
	BehaviorTree/ActivationConditionsTable.cpp \
	BehaviorTree/BehaviorTree.cpp \
	BehaviorTree/BehaviorTree_node.cpp \
	BehaviorTree/DefaultActivationConditions.cpp \
	BehaviorTree/PersonalActivationConditions.cpp \
	BehaviorTree/PersonalBehaviorTree.cpp \
	BehaviorTree/ProfileDictionary.cpp \
	BehaviorTree/SignalConditions.cpp \
	BehaviorTree/Slot.cpp \
	BehaviorTree/SlotData.cpp \
	BehaviorTree/SlotGroup.cpp \
	BehaviorTree/SubTactic.cpp \
	BehaviorTree/Tactic.cpp \
	BehaviorTree/TacticInfo.cpp \
	BehaviorTree/TacticsManager.cpp \
	BehaviorTree/dag.cpp \
	BehaviorTree/dag_grid.cpp \
	BehaviorTree/dag_node.cpp \
	BehaviorTree/GlobalActivationConditions.cpp \
	NewBehaviourTree/Tree.cpp \
	NewBehaviourTree/TreeProfileManager.cpp \
	../../Sandbox/Editor/AI/NavDataGeneration/LayeredNavMesh/ExportFormat.cpp \
	../../Sandbox/Editor/AI/NavDataGeneration/LayeredNavMesh/LnmExportFormat.cpp \
	../../Sandbox/Editor/AI/NavDataGeneration/LayeredNavMesh/PickingAccelerator.cpp \
	../../Sandbox/Editor/AI/NavDataGeneration/LayeredNavMesh/PolygonCont.cpp \
	../../Sandbox/Editor/AI/NavDataGeneration/LayeredNavMesh/Tess/Tess.cpp \
	../../Sandbox/Editor/AI/NavDataGeneration/LayeredNavMesh/Tess/TessMesh.cpp \
	Adapters.cpp \
	SmartPathFollower.cpp \
	PathFollower.cpp \
	PathMarker.cpp \
	PathObstacles.cpp \
	Pathfinder.cpp \
	LayeredNavMesh/DynamicObstacles.cpp \
	LayeredNavMesh/DynamicVertex.cpp \
	LayeredNavMesh/LayeredNavMeshRegion.cpp \
	LayeredNavMesh/PolygonSetOps.cpp \
	CTriangulator.cpp \
	NavPath.cpp \
	Navigation.cpp \
	FlightNavRegion.cpp \
	Free2DNavRegion.cpp \
	RoadNavRegion.cpp \
	TriangularNavRegion.cpp \
	VolumeNavRegion.cpp \
	Waypoint3DSurfaceNavRegion.cpp \
	WaypointHumanNavRegion.cpp \
	EmotionalSystem/EmotionalInfo.cpp \
	EmotionalSystem/EmotionalSystem.cpp \
	EmotionalSystem/PersonalEmotional.cpp \
	GroupSystem/EntityGroup.cpp \
	GroupSystem/FormationData.cpp \
	GroupSystem/FormationDataManager.cpp \
	GroupSystem/FormationSet.cpp \
	GroupSystem/GroupMember.cpp \
	GroupSystem/GroupSystem.cpp \
	GroupSystem/SteeringAgent.cpp \
	GroupSystem/SteeringEnviroment.cpp \
	AIActions.cpp \
	AIActor.cpp \
	AICollision.cpp \
	AIDbgRecorder.cpp \
	AIDebugDrawHelpers.cpp \
	AIDynHideObjectManager.cpp \
	AIGroup.cpp \
	AIGroupTactic.cpp \
	AIHideObject.cpp \
	AILightManager.cpp \
	AILog.cpp \
	AIMemStats.cpp \
	AIObject.cpp \
	AIPIDController.cpp \
	AIPlayer.cpp \
	AIRadialOcclusion.cpp \
	AIRecorder.cpp \
	AISignal.cpp \
	AIVehicle.cpp \
	CAISystem.cpp \
	CAISystemPhys.cpp \
	CAISystemUpdate.cpp \
	CryAISystem.cpp \
	AStarSolver.cpp \
	AllNodesContainer.cpp \
	BasicLifecycleContainers.cpp \
	BlackBoard.cpp \
	BuildingIDManager.cpp \
	CentralInterestManager.cpp \
	CodeCoverageGUI.cpp \
	CodeCoverageManager.cpp \
	CodeCoverageTracker.cpp \
	Cover/CoverPath.cpp \
	Cover/CoverSampler.cpp \
	Cover/CoverScorer.cpp \
	Cover/CoverSurface.cpp \
	CalculationStopper.cpp \
	CoordinationSystem/CoordinationTaskCommunication.cpp \
	CoordinationSystem/CoordinationActor.cpp \
	CoordinationSystem/CoordinationActorAssignment.cpp \
	CoordinationSystem/CoordinationLoop.cpp \
	CoordinationSystem/CoordinationManager.cpp \
	CoordinationSystem/CoordinationPlan.cpp \
	CoordinationSystem/CoordinationRole.cpp \
	CoordinationSystem/CoordinationRoleSequence.cpp \
	CoordinationSystem/CoordinationSetup.cpp \
	CoordinationSystem/CoordinationStep.cpp \
	CoordinationSystem/CoordinationTaskAction.cpp \
	CoordinationSystem/CoordinationTaskReadability.cpp \
	CoordinationSystem/CoordinationTaskSignal.cpp \
	HideSpot.cpp \
	Shape2.cpp \
	DebugDraw.cpp \
	Environment.cpp \
	FireCommand.cpp \
	Formation.cpp \
	GameSpecific/GoalOp_G02.cpp \
	GameSpecific/GoalOp_G04.cpp \
	GameSpecific/GoalOp_Crysis2.cpp \
	GoalOp.cpp \
	GoalOpFactory.cpp \
	GoalPipe.cpp \
	Graph.cpp \
	GraphNodeManager.cpp \
	GraphStructures.cpp \
	GraphUtility.cpp \
	Heuristic.cpp \
	IAgent.cpp \
	Leader.cpp \
	LeaderAction.cpp \
	LifecycleManager.cpp \
	MetadataDatabase.cpp\
	ObjectContainer.cpp \
	ObjectTracker.cpp \
	ObstacleAllocator.cpp \
	PerceptionManager.cpp \
	PerceptionSystem.cpp \
	PerceptionHandler/CrysisPerceptionHandler.cpp \
	PerceptionHandler/Crysis2PerceptionHandler.cpp \
	PerceptionHandler/PerceptionHandlerAutoReg.cpp \
	PerceptionHandler/WarfacePerceptionExtraData.cpp \
	PerceptionHandler/BasePerceptionHandler.cpp \
	PerceptionHandler/WarfacePerceptionHandler.cpp \
	PersonalInterestManager.cpp \
	PipeManager.cpp \
	PipeUser.cpp \
	PolygonSetOps/BspTree2d.cpp \
	PolygonSetOps/Polygon2d.cpp \
	Puppet.cpp \
	PuppetPhys.cpp \
	PuppetRateOfDeath.cpp \
	Shape.cpp \
	ShapeContainer.cpp \
	SmartObjects.cpp \
	StatsManager.cpp \
	TickCounter.cpp \
	UnitAction.cpp \
	UnitImg.cpp \
	VertexList.cpp \
	WorldOctree.cpp \
	Readability/ActorResourceMgr.cpp \
	Readability/CoopReadabilitiesSystem.cpp \
	Readability/ReadabilitySequence.cpp \
	Readability/ReadabilitySequenceMgr.cpp \
	Readability/ReadabilitySequenceSet.cpp \
	Readability/ReadabilitySession.cpp \
	Readability/SoundResourceMgr.cpp \
	Readability/SoundResourceSet.cpp \
	TacticalPointSystem/TacticalPointQuery.cpp \
	TacticalPointSystem/TacticalPointSystem.cpp \
	ScriptBind_AI.cpp \
	ScriptBind_AI2.cpp \
	Scriptbind_AI_G02.cpp \
	Scriptbind_AI_G04.cpp \
	Navigation/CustomNavRegion.cpp	\
	AIConsoleVariables.cpp	\
	AISignalCRCs.cpp	\
	Communication/CommunicationChannel.cpp	\
	Communication/CommunicationChannelManager.cpp	\
	Communication/CommunicationManager.cpp	\
	Communication/CommunicationPlayer.cpp \
	CoordinationSystem/CoordinationTaskSync.cpp	\
	TargetSelection/TargetTrack.cpp	\
	TargetSelection/TargetTrackCommon.cpp	\
	TargetSelection/TargetTrackGroup.cpp	\
	TargetSelection/TargetTrackManager.cpp	\
	TargetSelection/TargetTrackModifiers.cpp


PROJECT_SOURCES_CPP_ADD += \
  CryAISystem_nav_uber.cpp\
  CryAISystem_main_uber.cpp\
  CryAISystem_util_uber.cpp\
  CryAISystem_util2_uber.cpp\
  CryAISystem_readscript_uber.cpp
endif  

# vim:ts=8:sw=8

