/********************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2006-2007.
---------------------------------------------------------------------
File name:   ActorEffectValueList.h
$Id$
$DateTime$
Description: Manages wound data for a single puppet
---------------------------------------------------------------------
History:
- 17:03:2007 : Created by Ricardo Pillosu

*********************************************************************/
#ifndef _ACTOR_EFFECT_VALUE_LIST_H_
  #define _ACTOR_EFFECT_VALUE_LIST_H_

#include "ActorEffects.h"
#include "IWoundSystem.h"

struct SActorEffectValue
{
	SWoundArea							sWoundArea;
	SActorEffectValueHolder	sValue;
  float										fTotalTime;
  float										fElapsedTime;
	bool										bPersistent;
	string									sTag;
	
	SActorEffectValue();
	SActorEffectValue( const SWoundArea& sWoundArea, const SActorEffectValueHolder& sValue, float fTime, bool bPersistent, const string& sTag );
	
	bool operator==(const SActorEffectValue& rhs) const;
	bool operator!=( const SActorEffectValue& rhs ) const;

	void													Set( const SActorEffectValueHolder& sNewValue );
	const SActorEffectOutputValue	GetOutputValue() const;
	const SWoundArea							GetWoundArea() const;
	float													GetDurationRemaining() const;
};

class CActorEffectValueList
{

  public:
    // Base ----------------------------------------------------------
    CActorEffectValueList();
    virtual               ~CActorEffectValueList();
    bool                  Init( SActorEffect const* pConf );
    bool                  Update( float fElapsedTime );
		void                  Reset();

    // Util ----------------------------------------------------------
		void													AddValue( const SWoundArea *pWoundArea,
																						const SActorEffectValueHolder& sValue, 
																						float fTime, 
																						bool bPersistent, 
																						const string& sTag );
		bool													DeleteValue( string sTag, bool bStopAtFirst=true );
    void													ClearValues();
		SActorEffect const*						GetConf() const;
		const SWoundArea							GetCurrentWoundArea() const;
		const SActorEffectOutputValue	GetCurrentValue() const;
		float													GetCurrentValueDurationRemaining() const;

  private:
		void              SubtractTime( float fElapsedTime );
    SActorEffectValue GetInitialValueToCalc() const;
    SActorEffectValue CalcValue() const;
    SActorEffectValue OperateValueBasedOnPolitics( SActorEffectValue const*  pCurrentValue,
                                                   SActorEffectValue const*  pNewValue ) const;

  private:
    bool                            m_bInit;
    SActorEffectValue               m_CurrentValue;
    SActorEffect const*             m_pConf;
    std::list<SActorEffectValue *>  m_listActorEffectsValues;
};
#endif // _ACTOR_EFFECT_VALUE_LIST_H_
