/********************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2006-2007.
---------------------------------------------------------------------
File name:   ActorEffects.h
$Id$
$DateTime$
Description: Deals with different effects values applied on actors
---------------------------------------------------------------------
History:
- 16:04:2007 : Created by Ricardo Pillosu

*********************************************************************/
#ifndef _ACTOR_EFFECTS_H_
  #define _ACTOR_EFFECTS_H_

#include "IActorEffects.h"

class CPersonalActorEffect;

enum EActorEffectChoiceTypes
{
	EAECT_INVALID     = -1,
	EAECT_NO,
	EAECT_YES,
	EAECT_NEVER,
	EAECT_ALWAYS,
	EAECT_COUNT
};

enum EActorEffectValuePolitics
{
  EAEVP_INVALID                       = 0,
  EAEVP_USE_LOWER_VALUES,
  EAEVP_USE_HIGHER_VALUES,
  EAEVP_USE_MULTIPLIED_VALUES,
  EAEVP_USE_SUMMED_VALUES,
  EAEVP_USE_NEWER_VALUES,
  EAEVP_USE_OLDER_VALUES,
  EAEVP_USE_NEWER_VALUES_DISCARD_REST,
	EAEVP_CHOICE_FAVOUR_YES,
	EAEVP_CHOICE_FAVOUR_YES_LOWEST_DELAY,
	EAEVP_CHOICE_FAVOUR_YES_HIGHEST_DELAY,
	EAEVP_CHOICE_FAVOUR_NO,
	EAEVP_PASS_THROUGH,
	EAEVP_COUNT
};

struct SActorEffectValueHolder
{
	EActorEffectsValueType		eValueType;
	union 
	{
		float										fValue;
		EActorEffectChoiceTypes	eChoiceValue;
		EActorEffectWoundFlags	eFlagValue;
	};

	SActorEffectValueHolder();
	SActorEffectValueHolder( float fValue );
	SActorEffectValueHolder( EActorEffectChoiceTypes eChoiceValue );
	SActorEffectValueHolder( EActorEffectWoundFlags eFlagValue );

	bool ChoiceAsBool() const;
};

struct SActorEffect
{
  EActorEffectTypes					eEffectType;
	EActorEffectValuePolitics ePolitics;
	SActorEffectValueHolder		sDefaultValue;

  SActorEffect();
	SActorEffect( EActorEffectTypes eEffectType, EActorEffectValuePolitics ePolitics, const SActorEffectValueHolder& sDefaultValue );
};

class CActorEffects 
	: public IActorEffects
{

  public:

    /*$1- Singleton Stuff ----------------------------------------------------*/
    static CActorEffects&   ref();
    static bool             Create();
    void                    Shutdown();
    void                    Reset();
	void					ResetPersonalEffects( EntityId IdEntity );

    /*$1- Basics -------------------------------------------------------------*/
    void  Init();
    bool  Update( float fElapsedTime );

		/*$1- IEditorSetGameModeListener ----------------------------------------*/
		void										OnEditorSetGameMode( bool bGameMode );

    /*$1- Utils --------------------------------------------------------------*/
		
		bool										CreateValue( EActorEffectTypes eEffectType,
																				 EActorEffectValuePolitics ePolitics,
																				 const SActorEffectValueHolder& sValue );
    void										AddEffectValue( EActorEffectTypes eEffectType, 
																						EntityId IdEntity, 
																						const SWoundArea *pWoundArea,
																						const SActorEffectValueHolder& sValue,
																						float fTime, 
																						bool bPersistent=false, 
																						const string& sTag="" );
    bool										DeleteEffectValue( EActorEffectTypes eEffect, EntityId IdEntity, string sTag );
		EActorEffectTypes       GetEffectTypeFromName( const char* cEffectName ) const;
		const char*             GetEffectNameFromType( EActorEffectTypes eEffect ) const;
		EActorEffectChoiceTypes	GetEffectChoiceTypeFromName( const char* cEffectName ) const;
		const char*							GetEffectChoiceNameFromType( EActorEffectChoiceTypes eEffect ) const;
		EActorEffectWoundFlags	GetEffectWoundFlagFromName( const char* cEffectName ) const;
		const char*							GetEffectWoundFlagNameFromType( EActorEffectWoundFlags eEffect ) const;
		const string						GetEffectValueString( const SActorEffectOutputValue& sValue ) const;

  protected:

    /*$1- Creation and destruction via singleton -----------------------------*/
    CActorEffects();
    virtual ~CActorEffects();

    /*$1- Utils --------------------------------------------------------------*/
    SActorEffect*           GetActorEffectConf( EActorEffectTypes eEffect ) const;
    CPersonalActorEffect*   GetPersonalActorEffect( EntityId IdEntity ) const;
    CPersonalActorEffect*   CreatePersonalEffect( EntityId IdEntity );
		void										AssignActorEffectTypeNames();
		void										AssignActorEffectChoiceTypeNames();
		void										AssignActorEffectWoundFlagNames();

  private:

    /*$1- Members ------------------------------------------------------------*/
    bool                                m_bInit;
    static CActorEffects*               m_pInstance;
		std::vector<string>									m_vecActorEffectTypeNames;
		std::vector<string>									m_vecActorEffectChoiceTypeNames;
		std::vector<string>									m_vecActorEffectWoundFlagNames;
		std::vector<SActorEffect *>         m_vecActorEffects;
    std::vector<CPersonalActorEffect *> m_vecPersonalActorEffects;
};
#endif // _ACTOR_EFFECTS_H_
