/********************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2006-2007.
---------------------------------------------------------------------
File name:   PersonalActorEffect.h
$Id$
$DateTime$
Description: Manages wound data for a single puppet
---------------------------------------------------------------------
History:
- 14:03:2007 : Created by Ricardo Pillosu

*********************************************************************/
#ifndef _PERSONAL_ACTOR_EFFECT_H_
  #define _PERSONAL_ACTOR_EFFECT_H_

#include "AIProxy.h"

struct SActorEffectValueHolder;
struct SActorEffect;
class CActorEffectValueList;

class CPersonalActorEffect : public IAIProxyListener
{
    // Methods -------------------------------------------------------

  public:
    // Base ----------------------------------------------------------
    CPersonalActorEffect();
    virtual               ~CPersonalActorEffect();
    bool                  Init( EntityId Id );
    bool                  Update( float fElapsedTime );
    void                  Reset();

    // Utils ---------------------------------------------------------
    EntityId              GetEntityId() const;
    bool                  IsPlayer() const;
    SActorEffect const*   GetConf() const;
		void									AddEffect( SActorEffect const* pConf, 
																		 const SWoundArea *pWoundArea,
																		 const SActorEffectValueHolder& sValue, 
																		 float fTime, 
																		 bool bPersistent, 
																		 const string& sTag );
    bool                  DeleteEffect( SActorEffect const* pConf, string sTag );

  private:
    CActorEffectValueList*  GetEffectList( SActorEffect const* pConf ) const;
    CActorEffectValueList*  CreateEffectList( SActorEffect const* pConf );
    IActor*                 GetActor();
    IActor const*           GetActor() const;

	// IAIProxyListener
	void SetListener(bool bAdd);
	virtual void OnAIProxyEnabled(bool bEnabled);
	// ~IAIProxyListener

  private:
    bool                                  m_bInit;
    EntityId                              m_EntityId;
    std::vector<CActorEffectValueList *>  m_vecActorEffectValues;
};
#endif // _PERSONAL_ACTOR_EFFECT_H_
