/********************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2006-2007.
---------------------------------------------------------------------
File name:   HitLocations.h
$Id$
$DateTime$
Description: Stores and manages Body Hit Locations
---------------------------------------------------------------------
History:
- 02:03:2007 : Created by Ricardo Pillosu

*********************************************************************/
#ifndef _HIT_LOCATIONS_H_
  #define _HIT_LOCATIONS_H_

#include "HitLocationTable.h"
#include "IWoundSystem.h"
#include "IFileChangeMonitor.h"

class CHitLocations 
	: public IHitLocation, 
		public IFileChangeListener
{

  public:

    /*$1- Singleton Stuff ----------------------------------------------------*/
    static CHitLocations&   ref();
    static bool             Create();
    void                    Shutdown();

		/*$1-IFileChangeListener -------------------------------------------------*/
		void							OnFileChange( const char* sFilename );

    /*$1-Utils ---------------------------------------------------------------*/
    bool              Init();
    bool              Reload();
		SHitLocation			GetHitLocation( float fShootRange );
		SHitLocation			GetHitLocation( float fShootRange, const std::vector<SHitLocation>& vecSkipLocations, bool& bNoneLeft );
		float							GetHitLocationProbability( EBodyHitLocations eBodyLocation, float fShootRange );
		EBodyHitLocations GetHitLocationFromName( const char* cBodyLocationName ) const;
    const char*       GetHitLocationName( EBodyHitLocations eBodyLocation ) const;
    const char*       GetHitSideName( EHitLocSide eSide ) const;

  protected:

    /*$1- Creation and destruction via singleton -----------------------------*/
    CHitLocations();
    virtual ~CHitLocations();

  private:
    CHitLocationTable*  GetTableFromRange( float fShootRange );
    void                AssignHitLocationNames();
    void                ClearData();

  /*$1- Members --------------------------------------------------------------*/
  public:

  private:
    bool                              m_bInit;
    static CHitLocations*             m_pInstance;
    std::vector<string>               m_vecBodyHitLocationNames;
    std::vector<CHitLocationTable *>  m_vecTables;
};
#endif // _HIT_LOCATIONS_H_
