#include "StdAfx.h"
#include "FaceGen.h"

CFaceGen::CFaceGen(void)
: m_Mode(0)
, undos(0)
, minz(0.0f)
{
}

CFaceGen::~CFaceGen(void)
{
}

int CFaceGen::Load( const void* mem, size_t length )
{
	union USign
	{
		char a[4];
		int i;
	};

	USign sig;

	sig=*((USign*)((char*)mem+24));
	if(sig.i!='BPBV')
		return 0;

	int NBones     =((int*)mem)[0];
	int NPBVertices=((int*)mem)[1];
	int NUVVertices=((int*)mem)[2];
	int NVCVertices=((int*)mem)[3];
	int NVertices  =((int*)mem)[4];
	int NIndices   =((int*)mem)[5];

	VPBBuffer.resize(NPBVertices);
	VUVBuffer.resize(NUVVertices);
	VVCBuffer.resize(NVCVertices);
	VBuffer.resize(NVertices);
	IBuffer.resize(NIndices);

	char* curp=(char*)mem+24;

	sig=*((USign*)((char*)curp));
	curp+=4;
	memcpy(&VPBBuffer[0],((char*)curp),NPBVertices*sizeof(SVertexPosAndBind));
	curp+=NPBVertices*sizeof(SVertexPosAndBind);

	sig=*((USign*)((char*)curp));
	curp+=4;
	memcpy(&VUVBuffer[0],((char*)curp),NUVVertices*sizeof(SVertexUV));
	curp+=NUVVertices*sizeof(SVertexUV);

	sig=*((USign*)((char*)curp));
	curp+=4;
	memcpy(&VVCBuffer[0],((char*)curp),NVCVertices*sizeof(SVertexVC));
	curp+=NVCVertices*sizeof(SVertexVC);

	sig=*((USign*)((char*)curp));
	curp+=4;
	memcpy(&VBuffer[0],((char*)curp),NVertices*sizeof(SVertex));
	curp+=NVertices*sizeof(SVertex);

	sig=*((USign*)((char*)curp));
	curp+=4;
	memcpy(&IBuffer[0],((char*)curp),NIndices*sizeof(IBuffer[0]));
	curp+=NIndices*sizeof(IBuffer[0]);

	bones.resize(NBones);
	sig=*((USign*)((char*)curp));
	curp+=4;

	for(int i=0;i<NBones;i++)
	{
		sig=*((USign*)((char*)curp));
		SBoneInfo& curBone=bones[i];
		curp+=4;
//		fwrite(&(bones[i].isCurve)  ,sizeof(bones[i].isCurve)  ,1,binF);
//		fwrite(&(bones[i].isClosed) ,sizeof(bones[i].isClosed) ,1,binF);
//		fwrite(&(bones[i].matrix)   ,sizeof(bones[i].matrix)   ,1,binF);
//		fwrite(&(bones[i].nSegments),sizeof(bones[i].nSegments),1,binF);
//		fwrite(&NKnots,sizeof(NKnots),1,binF);

		int isCurve=*((int*)curp);
		curBone.isCurve  =isCurve;
		curp+=4;
		curBone.isClosed =*((int*)curp);
		curp+=4;
		memcpy(&(curBone.matrix),curp,sizeof(float)*12);
		curp+=sizeof(float)*12;
		curBone.nSegments=*((int*)curp);
		curp+=4;
//		sig=*((USign*)((char*)curp));
//		curp+=4;
		curBone.nameStart=*((int*)curp);
		curp+=4;
		curBone.nameLength=*((int*)curp);
		curp+=4;
		int nKnots=*((int*)curp);
		curBone.nKnots   =nKnots;
		curp+=4;

		if(nKnots)
		{
			curBone.knots.resize(curBone.nKnots);
			for(int j=0;j<curBone.nKnots;j++)
			{
				curBone.knots[j].pts[0]=*((Vec3*)curp);
				curp+=12;
				curBone.knots[j].pts[1]=*((Vec3*)curp);
				curp+=12;
				curBone.knots[j].pts[2]=*((Vec3*)curp);
				curp+=12;
				curBone.knots[j].type  =*((unsigned int*)curp);
				curp+=4;
			}
		}
	}

	std::vector<char>names;
	int namesLen=*((int*)curp);
	curp+=4;
	names.resize(namesLen);
	memcpy(&(names[0]),curp,namesLen);


	boneMods.resize(0);
	for(size_t i=0;i<GetBones().size();i++)
	{
		if(GetBones()[i].isCurve)
		{
		for(size_t j=0;j<GetBones()[i].knots.size();j++)
		{
			for(size_t k=0;k<3;k++)
			{
				SBoneMod mod;
				mod.bone=(int)i;
				mod.knot=(int)j;
				mod.vec=(int)k;
					mod.trans=Vec3(0,0,0);
				GetBones()[i].knots[j].N[k]=((int)boneMods.size());
				boneMods.push_back(mod);
			}
		}
	}
		else
		{
			SBoneMod mod;
			mod.bone=(int)i;
			mod.knot=(int)0;
			mod.vec=(int)-1;
			mod.trans=Vec3(0,0,0);
			SBoneInfo &bone=GetBones()[i];
			bone.nSegments   =0;
			bone.knots.resize(1);
			bone.knots[0].pts[0]=Vec3(bone.matrix[3][0],bone.matrix[3][1],bone.matrix[3][2]);
			bone.knots[0].N[0]=((int)boneMods.size());
			boneMods.push_back(mod);
		}
	}

	for(size_t i=0;i<GetBones().size();i++)
	{
		GetBones()[i].name=&(names[GetBones()[i].nameStart]);
		m_boneNamesMap[GetBones()[i].name]=(int)i;
	}

	VNormals.resize(VPBBuffer.size());
	VPositions.resize(VPBBuffer.size());
	return 1;
}

void CFaceGen::CalcVertexNormals()
{
	std::vector<Vec3>normals;
	std::vector<float>weights;
	normals.resize(VPBBuffer.size(),Vec3(0,0,0));
	weights.resize(VPBBuffer.size(),0.0f);
	for(size_t i=0;i<IBuffer.size()/3;i++)
	{
		size_t index0=VBuffer[IBuffer[i*3  ]].PBIndex;
		size_t index1=VBuffer[IBuffer[i*3+1]].PBIndex;
		size_t index2=VBuffer[IBuffer[i*3+2]].PBIndex;
		Vec3 faceNormal;
		Vec3 vertex0to1=VPositions[index1]-VPositions[index0];
		Vec3 vertex0to2=VPositions[index2]-VPositions[index0];
		faceNormal=vertex0to1^vertex0to2;
		faceNormal.Normalize();
		float weight=1.0f;

		normals[index0]+=faceNormal*weight;
		normals[index1]+=faceNormal*weight;
		normals[index2]+=faceNormal*weight;

		weights[index0]+=weight;
		weights[index1]+=weight;
		weights[index2]+=weight;
	}
	for(size_t i=0;i<VNormals.size();i++)
	{
		VNormals[i]=normals[i];
		VNormals[i].Normalize();
	}
}

template <typename T> T Bezier(const T& y0,const T& y1,const T& y2,const T& y3,float t)
{
	float dt=1.0f-t;
	return dt*dt*dt*y0+3*dt*dt*t*y1+3*dt*t*t*y2+t*t*t*y3;
}

template <typename T> T Linear(const T& y0,const T& y1,float t)
{
	float dt=1.0f-t;
	return dt*y0+t*y1;
}

float CalcW(const Vec3& p0,const Vec3& p1, float onebylen=0.15f)
{
	Vec3 lpos=p1-p0;
	float wi=(1.0f*onebylen/0.15f)/(0.0001f+lpos.GetLength()*0.15f);
	wi-=.1f;
	if(wi<0)
		wi=0;
	return wi;
}

void CFaceGen::CalcCurveWeights()
{
	for(size_t i=0;i<VPBBuffer.size();i++)
	{
		Vec3 vpos=VPBBuffer[i].p;
		float w=0;
		for(int j=0;j<(int)GetBoneCount();j++)
		{
			for(int k=0;k<(int)GetBones()[j].nSegments;k++)
			{
				const Vec3
					&bp00=GetBP0(j,k,0),
					&bp01=GetBP0(j,k,2),
					&bp02=GetBP0(j,k+1,1),
					&bp03=GetBP0(j,k+1,0);

				Vec3 p0;
				const int steps=8;
				for(int l=0;l<steps;l++)
				{
					p0=Bezier(bp00,bp01,bp02,bp03,1.0f/steps*l);
					float wi=CalcW(vpos,p0);
					if(wi>0)
					{
						w+=wi;
					}
				}
			}
		}
	}
}




void CFaceGen::CalcVertexPositions()
{
	for(size_t i=0;i<VPBBuffer.size();i++)
	{
		if((m_Mode==2)||(m_Mode==3))
		{
			Vec3 vpos=VPBBuffer[i].p;

			float w=0;
			Vec3 dp(0,0,0);

			if(m_Mode==2)
			for(size_t j=0;j<boneMods.size()/3;j++)
			{
				float wi=CalcW(vpos,GetBP0i(j*3),0.15f*boneMods[j*3].w);
				if(wi>0)
				{
					w+=wi;
					dp+=boneMods[j*3].trans*wi;
				}
			}

			if(m_Mode==3)
			for(int j=0;j<(int)GetBoneCount();j++)
			{
				for(int k=0;k<(int)GetBones()[j].nSegments;k++)
				{
					Vec3
						bp10=CalcBP(j,k,0),
						bp11=CalcBP(j,k,2),
						bp12=CalcBP(j,k+1,1),
						bp13=CalcBP(j,k+1,0);

					const Vec3
						&bp00=GetBP0(j,k,0),
						&bp01=GetBP0(j,k,2),
						&bp02=GetBP0(j,k+1,1),
						&bp03=GetBP0(j,k+1,0);

					Vec3 dp0=bp00-bp03;
					float len=dp0.GetLength();
					len=sqrt(len)+3;
//					len+=1;

					{
						Vec3 p0,p1;
						const int steps=4;
						for(int l=0;l<steps;l++)
						{
							p0=Bezier(bp00,bp01,bp02,bp03,1.0f/steps*l);
							p1=Bezier(bp10,bp11,bp12,bp13,1.0f/steps*l);
							

							float wgt=Linear(
								boneMods[GetBoneModIndex(j,k  ,0)].w,
								boneMods[GetBoneModIndex(j,k+1,0)].w,
								1.0f/steps*l
							);
							
							float wi=CalcW(vpos,p0,1.0f/len*wgt);
							if(wi>0)
							{
								w+=wi;
								dp+=(p1-p0)*wi;
							}
						}
					}
				}
			}


			dp/=w;
			VPositions[i]=vpos+dp;
			continue;
		}
		else if(m_Mode==4)
		{
			Vec3 vpos=VPBBuffer[i].p;

			float w=0;
			Vec3 dp(0,0,0);
			for(size_t j=0;j<boneMods.size();j++)
			{
				float wi=CalcW(vpos,GetBP0i(j*3));
				w+=wi;
				dp+=boneMods[j].trans*wi;
			}
			dp/=w;
			VPositions[i]=vpos+dp;
			continue;
		}

		bool transformed=false;
		Vec3 pos(0,0,0);
		float wsum=0;
		for(int j=0;j<VPBBuffer[i].boneN;j++)
		{
			int nb=VPBBuffer[i].s[j].nb;
			int ns=VPBBuffer[i].s[j].ns;
			if(nb<GetBoneCount())
			{
				if(GetBones()[nb].isCurve)
				{
					transformed=true;
					Vec3 bp0=CalcBP(nb,ns,0);
					Vec3 bp1=CalcBP(nb,ns,2);
					Vec3 bp2=CalcBP(nb,ns+1,1);
					Vec3 bp3=CalcBP(nb,ns+1,0);

					Vec3 bp00=GetBP0(nb,ns,0);
					Vec3 bp01=GetBP0(nb,ns,2);
					Vec3 bp02=GetBP0(nb,ns+1,1);
					Vec3 bp03=GetBP0(nb,ns+1,0);

					Vec3 newbpos   =Bezier(bp0,bp1,bp2,bp3,VPBBuffer[i].s[j].d);
					Vec3 newtangent=Bezier(bp0,bp1,bp2,bp3,VPBBuffer[i].s[j].d-.01f);
					newtangent-=newbpos;

					Vec3 oldbpos   =Bezier(bp00,bp01,bp02,bp03,VPBBuffer[i].s[j].d);
					Vec3 oldtangent=Bezier(bp00,bp01,bp02,bp03,VPBBuffer[i].s[j].d-.01f);
					oldtangent-=oldbpos;

					newtangent.Normalize();
					oldtangent.Normalize();

					Vec3 axis;
					axis=oldtangent^newtangent;
					float cosangle=oldtangent*newtangent;


					Vec3 vpos=VPBBuffer[i].p;
					vpos-=oldbpos;
					//					Vec4 newpos(vpos.x,vpos.y,vpos.z,1);
					Vec3 newpos(vpos);
					if(cosangle<0.999)
					{
						float angle=acos(cosangle);
						axis.Normalize();
						Quat qrot=Quat::CreateRotationAA(angle,axis);
						newpos=vpos*qrot;
//						D3DXQuaternionRotationAxis(&qrot,&axis,angle);
//						D3DXMATRIX mat;
//						D3DXMatrixRotationQuaternion(&mat,&qrot);
//						D3DXVec3Transform(&newpos,&vpos,&mat);
					}
					if(m_Mode==0)
						pos+=(Vec3(newpos.x,newpos.y,newpos.z)+newbpos)*VPBBuffer[i].s[j].w;
					else if(m_Mode==1)
						pos+=(VPBBuffer[i].p+newbpos-oldbpos)*VPBBuffer[i].s[j].w;
					wsum+=VPBBuffer[i].s[j].w;

				}
				else
				{
					Vec3 bp0=CalcBP(nb,ns,0);
					Vec3 bp00=GetBP0(nb,ns,0);
					wsum+=VPBBuffer[i].s[j].w;
					Vec3 scaled=bp00+(VPBBuffer[i].p-bp00)*GetBoneMods()[bones[nb].knots[0].N[0]].scale;
					pos+=(scaled+bp0-bp00)*VPBBuffer[i].s[j].w;
//					pos+=VPBBuffer[i].p*VPBBuffer[i].s[j].w;
//					wsum+=VPBBuffer[i].s[j].w;
			}
			}
			else
			{
				pos+=VPBBuffer[i].p*VPBBuffer[i].s[j].w;
				wsum+=VPBBuffer[i].s[j].w;
			}
		}
		if(!transformed)
		{
			wsum=1.0f;
			pos=VPBBuffer[i].p;
		}
		VPositions[i]=pos/wsum;
	}
}


void CFaceGen::SaveState(void* statebuf)
{
	Vec3* vecbuf=(Vec3*)statebuf;
	for(size_t i=0;i<boneMods.size();i++)
		vecbuf[i]=boneMods[i].trans;
};

void CFaceGen::LoadState(void* statebuf)
{
	Vec3* vecbuf=(Vec3*)statebuf;
	for(size_t i=0;i<boneMods.size();i++)
		boneMods[i].trans=vecbuf[i];
	CalcVertexNormals();
	CalcVertexPositions();
};


void CFaceGen::BackUp()
{
	return;
/*	for(size_t i=undos;i>0;i--)
		if(undoBuffer.size())
			undoBuffer.pop_back();
	undos=0;
	std::vector<Vec3> tempBV;
	undoBuffer.push_back(tempBV);
	for(size_t i=0;i<boneMods.size();i++)
		undoBuffer.back().push_back(boneMods[i].trans);
*/
};

void CFaceGen::Reset()
{
	BackUp();
	Vec3 zero(0.0f,0.0f,0.0f);
	for(size_t i=0;i<boneMods.size();i++)
	{
		boneMods[i].trans=zero;
	}
};

void CFaceGen::Undo()
{
	return;
	if(undos<(int)undoBuffer.size())
	{
		undos++;
		int UBPos=((int)undoBuffer.size())-undos;
		if(UBPos>0)
		{
			std::vector<Vec3>& state=undoBuffer[UBPos];
			for(size_t i=0;i<boneMods.size();i++)
			{
				boneMods[i].trans=state[i];
			}
		}
	}
};

void CFaceGen::Redo()
{
	return;
	if(undos>1)
	{
		undos--;
		int UBPos=((int)undoBuffer.size())-undos;
		if(UBPos>0)
		{
			std::vector<Vec3>& state=undoBuffer[UBPos];
			for(size_t i=0;i<boneMods.size();i++)
			{
				boneMods[i].trans=state[i];
			}
		}
	}
};

void CFaceGen::SetBP(int b,int p, int i, const Vec3& pos)
{
	Vec3 op=GetBP0(b,p,i);
	op=pos-op;
	boneMods[bones[b].knots[p].N[i]].trans=op;
}

int CFaceGen::FindKeyPointByName(const string& name)
{
	std::map<string,int>::iterator found=keyPointMap.find(name);
	if(found!=keyPointMap.end())
		return found->second;
	else
		return -1;
}

int CFaceGen::AddKeyPoint(const string& name, int index)
{
	if(FindKeyPointByName(name)!=-1)
		return -1;
	else
	{
		keyPointMap[name]=index;
		return 1;
	}
}

void CFaceGen::ProcessBackLinks()
{
	if(!keyPoints.size())
		return;
	for(size_t i=0;i<boneMods.size();i++)
	{
		SBoneMod& bm=boneMods[i];
		Vec3 pos,oldpos;
		oldpos=pos=CalcBP(bm.bone,bm.knot,bm.vec);
		for(size_t l=0;l<3;l++)
		{
			Vec3 newpos;
/*			if(bm.links[l].wts[0]==1.0f)
		{
				const SFaceFeatureKeyPoint& kp=keyPoints[bm.links[l].idx[0]];
				newpos=CalcBP(kp.boneN,kp.knotN,0);
		}
			else*/
		{
				if((bm.links[l].idx[0]==-1)||(bm.links[l].idx[1]==-1)||(bm.links[l].idx[2]==-1))
					continue;
				const SFaceFeatureKeyPoint& kp0=keyPoints[bm.links[l].idx[0]];
				const SFaceFeatureKeyPoint& kp1=keyPoints[bm.links[l].idx[1]];
				const SFaceFeatureKeyPoint& kp2=keyPoints[bm.links[l].idx[2]];

				Vec3 p10=CalcBP(kp0.boneN,kp0.knotN,0);
				Vec3 p11=CalcBP(kp1.boneN,kp1.knotN,0);
				Vec3 p12=CalcBP(kp2.boneN,kp2.knotN,0);

				newpos=
					p10*bm.links[l].wts[0]+
					p11*bm.links[l].wts[1]+
					p12*bm.links[l].wts[2];
			}
			switch(l)
			{
			case 0: pos.x=newpos.x;break;
			case 1: pos.y=newpos.y;break;
			case 2: pos.z=newpos.z;break;
			}
		}
		Vec3 dp=pos-oldpos;
		bm.trans=bm.trans+dp;
		if(bm.vec==0)
		{
			boneMods[i+1].trans=boneMods[i+1].trans+dp;
			boneMods[i+2].trans=boneMods[i+2].trans+dp;
		}
//		SetBP(bm.bone,bm.knot,bm.vec,pos);
	}

	return;
// Obsolete
/*
	for(size_t i=0;i<backLinks.size();i++)
	{
		const SBackLink& bl=backLinks[i];
		if((bl.keyPointLinks.size())==1)
		{
			const SFaceFeatureKeyPoint& kp=keyPoints[bl.keyPointLinks[0]];
			Vec3 pos=CalcBP(kp.boneN,kp.knotN,0);
			SetBP(bl.bone,bl.knot,bl.vec,pos);
		}
		else if(bl.keyPointLinks.size()==3)
		{
			const SFaceFeatureKeyPoint& kp0=keyPoints[bl.keyPointLinks[0]];
			const SFaceFeatureKeyPoint& kp1=keyPoints[bl.keyPointLinks[1]];
			const SFaceFeatureKeyPoint& kp2=keyPoints[bl.keyPointLinks[2]];
			Vec3 p00=GetBP0(kp0.boneN,kp0.knotN,0);
			Vec3 p01=GetBP0(kp1.boneN,kp1.knotN,0);
			Vec3 p02=GetBP0(kp2.boneN,kp2.knotN,0);
			p01-=p00;
			p02-=p00;

			Vec3 pX0=GetBP0(bl.bone,bl.knot,bl.vec);
			pX0-=p00;

			float d=(p01.x*p02.z-p02.x*p01.z);
			float x=(pX0.x*p02.z-p02.x*pX0.z)/d;
			float y=(p01.x*pX0.z-pX0.x*p01.z)/d;

			Vec3 p10=CalcBP(kp0.boneN,kp0.knotN,0);
			Vec3 p11=CalcBP(kp1.boneN,kp1.knotN,0);
			Vec3 p12=CalcBP(kp2.boneN,kp2.knotN,0);
			p11-=p10;
			p12-=p10;

			Vec3 pos=p10+x*p11+y*p12;
			Vec3 oldpos=CalcBP(bl.bone,bl.knot,bl.vec);
			pos.y=oldpos.y;
			SetBP(bl.bone,bl.knot,bl.vec,pos);

		}
	}
	*/
}


void CFaceGen::CalcMinZ()
{
	minz=FLT_MAX;
	if(GetBoneModIndex(6,1,0)!=-1)
	{
		float z=GetBP0(6,1,0).z;
		minz=z-20;
	}
	else
	{
		for(size_t i=0; i<VPBBuffer.size();i++)
			if(VPBBuffer[i].p.z<minz)
				minz=VPBBuffer[i].p.z;
	}
}

void CFaceGen::Drop()
{
	for(size_t i=0; i<VPBBuffer.size();i++)
		VPBBuffer[i].p.z-=minz;
	for(size_t i=0; i<bones.size(); i++)
	{
		std::vector<SBoneInfo::SBezierKnot>& knots=bones[i].knots;
		for(size_t j=0; j<knots.size(); j++)
		{
			for(size_t k=0; k<3; k++)
			{
				knots[j].pts[k].z-=minz;
			}
		}
	}
}

void CFaceGen::AutoFaceBack()
{
	if(GetBoneModIndex(6,1,0)!=-1)
	{
		if(GetBP0(6,1,0).y>0)
			FaceBack();
	}
}

void CFaceGen::FaceBack()
{
	for(size_t i=0; i<VPBBuffer.size();i++)
	{
		Vec3 p=VPBBuffer[i].p;
		VPBBuffer[i].p=Vec3(-p.x,-p.y,p.z);
	}
	for(size_t i=0; i<bones.size(); i++)
	{
		std::vector<SBoneInfo::SBezierKnot>& knots=bones[i].knots;
		for(size_t j=0; j<knots.size(); j++)
		{
			for(size_t k=0; k<3; k++)
			{
				Vec3 p=knots[j].pts[k];
				knots[j].pts[k]=Vec3(-p.x,-p.y,p.z);
			}
		}
	}
}

unsigned int CFaceGen::FindNearestVertex(const Vec3& pos) const
{
	Vec3 localPos=pos*100;
	localPos.z-=minz;
	localPos=Vec3(-localPos.x,-localPos.y,localPos.z);
	float minlen=FLT_MAX;
	unsigned int minN = 0;
	for(size_t i=0; i<VPBBuffer.size();i++)
	{
		Vec3 dp=VPBBuffer[i].p-localPos;
		float len=dp.GetLengthSquared();
		if(len<minlen)
		{
			minlen=len;
			minN=(unsigned int)i;
		}
	}
	return minN;
}

void CFaceGen::FindNearestVertexShift(const Vec3& pos, Vec3& shift) const
{
	unsigned int np=FindNearestVertex(pos);
	Vec3 dp=VPositions[np]-VPBBuffer[np].p;
	shift=Vec3(-dp.x,-dp.y,dp.z)*0.01f;
}

unsigned int CFaceGen::FindNearestUVVertex(const Vec2& uv) const
{
	float minlen=FLT_MAX;
	unsigned int minN = 0;
	for(size_t i=0; i<VBuffer.size();i++)
	{
		size_t index=VBuffer[i].UVIndex;
		Vec2 duv=Vec2(VUVBuffer[index].u.x,VUVBuffer[index].u.y)-uv;
		float len=max(fabs(duv.x),fabs(duv.y));
		if(len<minlen)
		{
			minlen=len;
			minN=(unsigned int)VBuffer[i].PBIndex;
		}
	}
	return minN;
}

void CFaceGen::FindNearestUVVertexShift(const Vec3& pos, const Vec2& uv, Vec3& shift) const
{
	unsigned int np=FindNearestVertex(pos);
//  unsigned int np=FindNearestUVVertex(uv);
	Vec3 dp=VPBBuffer[np].p-VPositions[np];
	shift=Vec3(dp.x,dp.y,-dp.z)*0.01f;
}


void CFaceGen::Destroy()
{
	delete this;
}

SBoneMod* CFaceGen::GetBoneMod(size_t index)
{
	if(index<GetBoneMods().size())
		return &GetBoneMods()[index];
	else
		return 0;
}

void CFaceGen::SetBoneModTrans(size_t index, const Vec3& trans)
{
	SBoneMod* bm=GetBoneMod(index);
	if(bm)
		bm->trans=trans;
}

bool CFaceGen::GetBoneModTrans(const char* name, size_t knot, size_t vec, Vec3& trans, float& scale)const
{
	int boneN=GetBoneNByName(name);
	if(boneN==-1)
		return false;
	const SBoneInfo& bone=bones[boneN];
	if(bone.isCurve)
	{
		if(
			(knot<bone.knots.size())&&
			(vec<3)
			)
		{
			trans=boneMods[bone.knots[knot].N[vec]].trans;
			return true;
		}
	}
	else
	{
		if((knot==0)&&(vec==~0))
		{
			trans=boneMods[bone.knots[0].N[0]].trans;
			scale=boneMods[bone.knots[0].N[0]].scale;
			return true;
		}
	}
	return true;
}

void CFaceGen::FetchTransform(const IFaceGen* fg)
{
	for(size_t i=0;i<boneMods.size();i++)
	{
		const char* name=bones[boneMods[i].bone].name.c_str();
		fg->GetBoneModTrans(name,boneMods[i].knot,boneMods[i].vec,boneMods[i].trans,boneMods[i].scale);
	}
}

void CFaceGen::ScaleAttachments()
{
	// glasses
	{
		Vec3 centr0=GetBP0(15,6,0);
		Vec3 left0 =GetBP0(5,3,0);
		Vec3 right0=GetBP0(5,9,0);
		Vec3 centr =CalcBP(15,6,0);
		Vec3 left  =CalcBP(5,3,0);
		Vec3 right =CalcBP(5,9,0);

		Vec3 dll0=centr0-left0;
		Vec3 dlr0=centr0-right0;
		Vec3 dll=centr-left;
		Vec3 dlr=centr-right;
		Vec3 dc=centr-centr0;

		float dist0=dll0.GetLength();
		dist0=max(dist0,dlr0.GetLength());

		float dist=dll.GetLength();
		dist=max(dist,dlr.GetLength());

		float scale=dist/dist0;
		int bn=GetBoneNByName("Goggles");
		if(bn!=-1)
		{
			SBoneInfo& gogBone=GetBones()[bn];
			GetBoneMod(gogBone.knots[0].N[0])->scale=scale;
			GetBoneMod(gogBone.knots[0].N[0])->trans=dc;
		}
	}
	// helmet
	{
		Vec3 left0 =GetBP0(13,2,0);
		Vec3 right0=GetBP0(13,4,0);
		Vec3 front0=GetBP0(13,0,0);
		Vec3 back0 =GetBP0(13,3,0);
		Vec3 centr0 =(left0+right0+back0+front0)*0.25f;
		Vec3 left  =CalcBP(13,2,0);
		Vec3 right =CalcBP(13,4,0);
		Vec3 front =CalcBP(13,0,0);
		Vec3 back  =CalcBP(13,3,0);
		Vec3 centr =(left+right+back+front)*0.25f;

		Vec3 dll0=centr0-left0;
		Vec3 dlr0=centr0-right0;
		Vec3 dlf0=centr0-front0;
		Vec3 dlb0=centr0-back0;
		Vec3 dll=centr-left;
		Vec3 dlr=centr-right;
		Vec3 dlf=centr-front;
		Vec3 dlb=centr-back;
		//		Vec3 dc=(left-left0)+(right-right0)+(front-front0)+(back-back0);
		Vec3 dc=centr-centr0;

		float scale=max(
			max(dll.GetLength()/dll0.GetLength(),dlr.GetLength()/dlr0.GetLength()),
			max(dlf.GetLength()/dlf0.GetLength(),dlb.GetLength()/dlb0.GetLength())
			)
			;

		int bn=GetBoneNByName("Helmet");
		if(bn!=-1)
		{
			SBoneInfo& helmBone=GetBones()[bn];
			GetBoneMod(helmBone.knots[0].N[0])->scale=scale;
			GetBoneMod(helmBone.knots[0].N[0])->trans=dc;
		}
	}
}
