/*************************************************************************
  Crytek Source File.
  Copyright (C), Crytek Studios, 2001-2004.
 -------------------------------------------------------------------------
  $Id$
  $DateTime$
  
 -------------------------------------------------------------------------
  History:
  - 11:8:2004   11:40 : Created by Mrcio Martins

*************************************************************************/
#include "StdAfx.h"
#include "GameServerChannel.h"
#include "GameClientChannel.h"
#include "GameServerNub.h"
#include "GameContext.h"
#include "CryAction.h"
#include "GameRulesSystem.h"



ICVar *CGameServerChannel::sv_timeout_disconnect=0;

CGameServerChannel::CGameServerChannel(INetChannel *pNetChannel, CGameContext *pGameContext, CGameServerNub *pServerNub)
: m_pServerNub(pServerNub), m_channelId(0), m_hasLoadedLevel(false), m_onHold(false)
{
	Init( pNetChannel, pGameContext );
	CRY_ASSERT(pNetChannel);

	SetupNetChannel(pNetChannel);

	if (!sv_timeout_disconnect)
		sv_timeout_disconnect=gEnv->pConsole->GetCVar("sv_timeout_disconnect");

	gEnv->pConsole->AddConsoleVarSink( this );
  CCryAction::GetCryAction()->OnActionEvent(SActionEvent(eAE_channelCreated,1));
}

CGameServerChannel::~CGameServerChannel()
{
	gEnv->pConsole->RemoveConsoleVarSink( this );
  CCryAction::GetCryAction()->OnActionEvent(SActionEvent(eAE_channelDestroyed,1));

	Cleanup();
}

void CGameServerChannel::SetupNetChannel(INetChannel *pNetChannel)
{
	pNetChannel->SetServer(GetGameContext()->GetNetContext(), true);
  INetChannel::SPerformanceMetrics pm;
	if (!gEnv->bMultiplayer)
		pm.pPacketRateDesired = gEnv->pConsole->GetCVar("g_localPacketRate");
	else
		pm.pPacketRateDesired = gEnv->pConsole->GetCVar("sv_packetRate");
	pm.pBitRateDesired = gEnv->pConsole->GetCVar("sv_bandwidth");
	pNetChannel->SetPerformanceMetrics(&pm);
}

void CGameServerChannel::Release()
{
	if (GetNetChannel())
		delete this;
}

bool CGameServerChannel::OnBeforeVarChange( ICVar *pVar,const char *sNewValue )
{
	return true;
}

void CGameServerChannel::OnAfterVarChange( ICVar *pVar )
{
	if (0 == (pVar->GetFlags() & VF_NOT_NET_SYNCED_INTERNAL))
	{
		if (GetNetChannel() && !GetNetChannel()->IsLocal())
		{
			SClientConsoleVariableParams params( pVar->GetName(), pVar->GetString() );
#if FAST_CVAR_SYNC
			SSendableHandle& id = GetConsoleStreamId( params.key );
			INetSendablePtr pSendable = new CSimpleNetMessage<SClientConsoleVariableParams>(params, CGameClientChannel::SetConsoleVariable);
			pSendable->SetGroup('cvar');
			GetNetChannel()->SubstituteSendable( pSendable, 1, &id, &id );
#else
			INetSendablePtr pSendable = new CSimpleNetMessage<SClientConsoleVariableParams>(params, CGameClientChannel::SetConsoleVariable);
			pSendable->SetGroup('cvar');
			GetNetChannel()->AddSendable( pSendable, 1, &m_consoleVarSendable, &m_consoleVarSendable );
#endif
		}
	}
}

void CGameServerChannel::OnDisconnect(EDisconnectionCause cause, const char *description)
{
	//CryLogAlways("CGameServerChannel::OnDisconnect(%d, '%s')", cause, description?description:"");
  CCryAction::GetCryAction()->OnActionEvent(SActionEvent(eAE_clientDisconnected,int(cause),description));

	IGameRules *pGameRules = CCryAction::GetCryAction()->GetIGameRulesSystem()->GetCurrentGameRules();

	if (pGameRules && IsOnHold())
	{
		pGameRules->OnClientDisconnect(GetChannelId(), cause, description, false);
		Cleanup();

		return;
	}

	if (sv_timeout_disconnect && pGameRules && sv_timeout_disconnect->GetIVal()>0 && pGameRules->ShouldKeepClient(GetChannelId(), cause, description))
	{
		if (m_pServerNub->PutChannelOnHold(this))
		{
			pGameRules->OnClientDisconnect(GetChannelId(), cause, description, true);
			m_hasLoadedLevel=false;
			return;
		}
	}

	if (pGameRules)
		pGameRules->OnClientDisconnect(GetChannelId(), cause, description, false);
	Cleanup();
}

void CGameServerChannel::Cleanup()
{
	if (GetPlayerId())
	{
		gEnv->pEntitySystem->RemoveEntity( GetPlayerId(), true );
	}
}

void CGameServerChannel::DefineProtocol(IProtocolBuilder *pBuilder)
{
	pBuilder->AddMessageSink(this, CGameClientChannel::GetProtocolDef(), CGameServerChannel::GetProtocolDef());
	CCryAction::GetCryAction()->GetIGameObjectSystem()->DefineProtocol( true, pBuilder );
	CCryAction::GetCryAction()->GetGameContext()->DefineContextProtocols(pBuilder, true);
	gEnv->pGame->ConfigureGameChannel(true, pBuilder);
}

void CGameServerChannel::SetPlayerId( EntityId playerId )
{
	//check for banned status here
	if(m_pServerNub->CheckBanned(GetNetChannel()))
		return;

	if(CGameServerChannel* pServerChannel = m_pServerNub->GetOnHoldChannelFor(GetNetChannel()))
	{
		//cleanup onhold channel if it was not associated with us
		//normally it should be taken while creating channel, but for now, this doesn't happen
		m_pServerNub->RemoveOnHoldChannel(pServerChannel, false);
	}

	CGameChannel::SetPlayerId( playerId );
	if (GetNetChannel()->IsLocal())
		CGameClientChannel::SendSetPlayerId_LocalOnlyWith( playerId, GetNetChannel() );
}

bool CGameServerChannel::CheckLevelLoaded() const
{
	return m_hasLoadedLevel;
}

void CGameServerChannel::AddUpdateLevelLoaded( IContextEstablisher * pEst )
{
	if (!m_hasLoadedLevel)
		AddSetValue( pEst, eCVS_InGame, &m_hasLoadedLevel, true, "AllowChaining" );
}

#ifndef OLD_VOICE_SYSTEM_DEPRECATED
NET_IMPLEMENT_SIMPLE_ATSYNC_MESSAGE( CGameServerChannel, MutePlayer, eNRT_ReliableUnordered, eMPF_BlocksStateChange )
{
	if(GetNetChannel()->IsLocal())
		return true;

	CCryAction::GetCryAction()->GetGameContext()->GetNetContext()->GetVoiceContext()->Mute(param.requestor, param.id, param.mute);

	return true;
}
#endif