#############################################################################
## Crytek Source File
## Copyright (C) 2006, Crytek Studios
##
## Creator: Sascha Demetrio
## Date: Jul 31, 2006
## Description: GNU-make based build system
#############################################################################

PROJECT_TYPE := module
PROJECT_VCPROJ := CryAction.vcproj

-include $(PROJECT_CODE)/Project_override.mk

ifeq ($(findstring Linux,$(ARCH)),Linux)
  ifeq ($(OPTION_PROFILE),1)
    PROJECT_XFLAGS_VehicleSystem_VehicleSystem_FactoryRegistration_cpp := $(ARCH_XFLAGS) -O0
    PROJECT_XFLAGS_AnimationGraph_AnimationGraphManager_RegisterFactories_cpp := $(ARCH_XFLAGS) -O0
    PROJECT_XFLAGS_Serialization_GameSerialize_FactoryRegistration_cpp := $(ARCH_XFLAGS) -O0
  endif
endif

PROJECT_CPPFLAGS_COMMON += \
	-I$(CODE_ROOT)/CryEngine/CryCommon
	
ifeq ($(MKOPTION_SNC),1)
  PROJECT_CPPFLAGS_COMMON += --diag_suppress=175
endif

PROJECT_SOURCES_CPP_REMOVE := StdAfx.cpp

ifeq ($(MKOPTION_UNITYBUILD),1)
PROJECT_SOURCES_CPP_REMOVE += AnimationGraph/AGAnimation.cpp \
	AnimationGraph/AGAdditive.cpp \
	AnimationGraph/AGAttachmentEffect.cpp \
	AnimationGraph/AGColliderMode.cpp \
	AnimationGraph/AGFacial.cpp \
	AnimationGraph/AGForceStartImmediately.cpp \
	AnimationGraph/AGLookIkOverride.cpp \
	AnimationGraph/AGMovementControlMethod.cpp \
	AnimationGraph/AGOutput.cpp \
	AnimationGraph/AGParams.cpp \
	AnimationGraph/AGSetInput.cpp \
	AnimationGraph/AGSound.cpp \
	AnimationGraph/AGTransitionParams.cpp \
	AnimationGraph/AGWaitForUBAllowed.cpp \
	AnimationGraph/AnimEvent.cpp \
	AnimationGraph/AnimPhysicsNodes.cpp \
	AnimationGraph/AnimatedCharacter.cpp \
	AnimationGraph/AnimatedCharacterPPS.cpp \
	AnimationGraph/AnimatedCharacterPPS_Common.cpp \
	AnimationGraph/AnimatedCharacterPPS_Debug.cpp \
	AnimationGraph/AnimatedCharacterPPS_ParamCalculation.cpp \
	AnimationGraph/AnimatedCharacterPPS_StateSelection.cpp \
	AnimationGraph/AnimationGraph.cpp \
	AnimationGraph/AnimationGraphCVars.cpp \
	AnimationGraph/AnimationGraphManager.cpp \
	AnimationGraph/AnimationGraphManager_RegisterFactories.cpp \
	AnimationGraph/AnimationGraphState.cpp \
	AnimationGraph/AnimationGraphStates.cpp \
	AnimationGraph/AnimationGraphTemplate.cpp \
	AnimationGraph/AnimationTrigger.cpp \
	AnimationGraph/DebugHistory.cpp \
	AnimationGraph/ExactPositioning.cpp \
	AnimationGraph/HumanBlending.cpp \
	AnimationGraph/MGDelayEntering.cpp \
	AnimationGraph/MGDelayLeaving.cpp \
	AnimationGraph/MGEndMusic.cpp \
	AnimationGraph/MGMood.cpp \
	AnimationGraph/MGStinger.cpp \
	AnimationGraph/MGTheme.cpp \
	AnimationGraph/PreprocessLinksAndStates.cpp \
	AnimationGraph/RangeMerger.cpp \
	AnimationGraph/StateIndex.cpp \
	AnimationGraph/AnimationRandomizer.cpp \
	Animation/PoseModifier/IKTorsoAim.cpp \
	AIDebugRenderer.cpp \
	AIFaceManager.cpp \
	AIHandler.cpp \
	AIProxy.cpp \
	AIReadabilityManager.cpp \
	ActionFilter.cpp \
	ActionGame.cpp \
	ActionMap.cpp \
	ActionMapManager.cpp \
	ActorEffectsManager/ActorEffectValueList.cpp \
	ActorEffectsManager/ActorEffects.cpp \
	ActorEffectsManager/PersonalActorEffect.cpp \
	ActorSystem.cpp \
	Analyst.cpp \
	BodyHitLocations/HitLocationTable.cpp \
	BodyHitLocations/HitLocations.cpp \
	CheckPoint/CheckPointSystem.cpp \
	BreakablePlane.cpp \
	CallbackTimer.cpp \
	CharacterPartsManager.cpp \
	CombatLog/CombatLog.cpp \
	CryAction.cpp \
	CryActionCVars.cpp \
	DebrisMgr/DebrisMgr.cpp \
	DeferredRaycastWrapper.cpp \
	DeferredRaycastManager.cpp \
	GameSpecific/GoalOp_Crysis2.cpp \
	DevMode.cpp \
	ViewSystem/View.cpp \
	ViewSystem/ViewSystem.cpp \
	VisualLog/VisualLog.cpp \
	EntityTags.cpp \
	EquipmentManager.cpp \
	FaceGen/FaceGen.cpp \
	GameSession/GameSessionHandler.cpp \
	Inventory.cpp \
	ItemParams.cpp \
	ItemSystem.cpp \
	Level.cpp \
	LevelSystem.cpp \
	LivePreview/RealtimeRemoteUpdate.cpp \
	Main.cpp \
	MetadataRecorder/MetadataRecorder.cpp \
	MusicLogic/MusicLogic.cpp \
	MusicLogic/ScriptBind_MusicLogic.cpp \
	PersistantDebug.cpp \
	PlayerProfiles/BMPHelper.cpp \
	PlayerProfiles/PlayerProfile.cpp \
	PlayerProfiles/PlayerProfileImplFS.cpp \
	PlayerProfiles/PlayerProfileImplRSFHelper.cpp \
	PlayerProfiles/PlayerProfileImplConsole.cpp \
	PuppetRateOfDeath.cpp \
	PlayerProfiles/PlayerProfileManager.cpp \
	RangeSignalingSystem/AngleAlert.cpp \
	RangeSignalingSystem/PersonalRangeSignaling.cpp \
	RangeSignalingSystem/Range.cpp \
	RangeSignalingSystem/RangeSignaling.cpp \
	RemoteControl/RConClientListener.cpp \
	RemoteControl/RConServerListener.cpp \
	TweakMenu/TweakMetadataCVAR.cpp \
	TweakMenu/TweakMetadata.cpp \
	TweakMenuController.cpp \
	TweakMenu/AtomicFiles.cpp \
	TweakMenu/TweakCommon.cpp \
	TweakMenu/TweakMetadataLUA.cpp \
	TweakMenu/LuaVarUtils.cpp \
	TweakMenu/TweakItemSimple.cpp \
	TweakMenu/TweakMetadataCommand.cpp \
	TweakMenu/TweakMenu.cpp \
	TweakMenu/TweakTraverser.cpp \
	TweakMenu/TweakMenuController.cpp \
	SignalTimers/PersonalSignalTimer.cpp \
	SignalTimers/SignalTimers.cpp \
	SimpleHttpServer/SimpleHttpServerListener.cpp \
	Statistics/GameStatistics.cpp \
	Statistics/StatsSizer.cpp \
	Statistics/ScriptBind_GameStatistics.cpp \
	Statistics/StatisticsHelpers.cpp \
	SubtitleManager.cpp \
	TestSystem/TestManager.cpp \
	TestSystem/TestProfiler.cpp \
	TestSystem/TimeDemoRecorder.cpp \
	TimeOfDayScheduler.cpp \
	UIDraw/UIDraw.cpp \
	UISystem.cpp \
	AI/CommunicationVoiceLibrary.cpp \
	AI/CommunicationHandler.cpp \
	Animation/PoseModifier/LookAtSimple.cpp \
	CooperativeAnimationManager/CooperativeAnimationManager.cpp \
	CooperativeAnimationManager/CooperativeAnimation.cpp \
	DialogSystem/DialogActorContext.cpp \
	DialogSystem/DialogLoader.cpp \
	DialogSystem/DialogLoaderMK2.cpp \
	DialogSystem/DialogScript.cpp \
	DialogSystem/DialogSession.cpp \
	DialogSystem/DialogSystem.cpp \
	DialogSystem/FlowDialogNode.cpp \
	DialogSystem/ScriptBind_DialogSystem.cpp \
	EffectSystem/BloodSplats.cpp \
	EffectSystem/Effect.cpp \
	EffectSystem/EffectSystem.cpp \
	EffectSystem/GroundEffect.cpp \
	FlowSystem/FlowData.cpp \
	FlowSystem/FlowGraph.cpp \
	FlowSystem/FlowSerialize.cpp \
	FlowSystem/FlowSystem.cpp \
	FlowSystem/FlowSystemCVars.cpp \
	FlowSystem/Inspectors/FlowFilters.cpp \
	FlowSystem/Inspectors/FlowInspectorDefault.cpp \
	FlowSystem/Nodes/AngularInterpolatorNode.cpp \
	FlowSystem/Nodes/ComputeLightingNode.cpp \
	FlowSystem/Nodes/EntitiesInRangeNode.cpp \
	FlowSystem/Nodes/FlowCVarsNode.cpp \
	FlowSystem/Nodes/FlowPlatformNode.cpp \
	FlowSystem/Nodes/FlowCameraNodes.cpp \
	FlowSystem/Nodes/FlowCompositeNode.cpp \
	FlowSystem/Nodes/FlowConditionNode.cpp \
	FlowSystem/Nodes/FlowDelayNode.cpp \
	FlowSystem/Nodes/FlowEngineEffectsNodes.cpp \
	FlowSystem/Nodes/FlowEngineNodes.cpp \
	FlowSystem/Nodes/FlowEntityNode.cpp \
	FlowSystem/Nodes/FlowEnvironmentNodes.cpp \
	FlowSystem/Nodes/FlowFlashInvokeNode.cpp \
	FlowSystem/Nodes/FlowGameNodes.cpp \
	FlowSystem/Nodes/FlowHUDNodes.cpp \
	FlowSystem/Nodes/FlowInputNode.cpp \
	FlowSystem/Nodes/FlowInterpolNodes.cpp \
	FlowSystem/Nodes/FlowInventoryNodes.cpp \
	FlowSystem/Nodes/FlowLogInput.cpp \
	FlowSystem/Nodes/FlowLogNode.cpp \
	FlowSystem/Nodes/FlowLogicNodes.cpp \
	FlowSystem/Nodes/FlowMathNodes.cpp \
	FlowSystem/Nodes/FlowMissionNodes.cpp \
	FlowSystem/Nodes/FlowMovieNodes.cpp \
	FlowSystem/Nodes/FlowMusicLogicControlNode.cpp \
	FlowSystem/Nodes/FlowNodeAI.cpp \
	FlowSystem/Nodes/FlowNodeAIAction.cpp \
	FlowSystem/Nodes/FlowNode_ColliderMode.cpp \
	FlowSystem/Nodes/FlowNoiseNodes.cpp \
	FlowSystem/Nodes/FlowPhysicsNodes.cpp \
	FlowSystem/Nodes/FlowPlotNode.cpp \
	FlowSystem/Nodes/FlowSaveGameNode.cpp \
	FlowSystem/Nodes/FlowScriptedNode.cpp \
	FlowSystem/Nodes/FlowSoundDialog.cpp \
	FlowSystem/Nodes/FlowSoundMoodNode.cpp \
	FlowSystem/Nodes/FlowSoundVolumeNodes.cpp \
	FlowSystem/Nodes/FlowStartNode.cpp \
	FlowSystem/Nodes/FlowStatsNodes.cpp \
	FlowSystem/Nodes/FlowStringNodes.cpp \
	FlowSystem/Nodes/FlowTimeNode.cpp \
	FlowSystem/Nodes/FlowTrackEventNode.cpp \
	FlowSystem/Nodes/FlowVideoPlayerNode.cpp \
	FlowSystem/Nodes/FlowWeaponNodes.cpp \
	FlowSystem/Nodes/GameTokenNode.cpp \
	FlowSystem/Nodes/IndexerNode.cpp \
	FlowSystem/Nodes/LinearInterpolatorNode.cpp \
	FlowSystem/Nodes/MultiplexerNode.cpp \
	FlowSystem/Nodes/OwnerAngularInterpolatorNode.cpp \
	FlowSystem/Nodes/OwnerAngularRotationNode.cpp \
	FlowSystem/Nodes/OwnerLinearInterpolatorNode.cpp \
	FlowSystem/Nodes/PlayCGANode.cpp \
	FlowSystem/Nodes/PlaySequenceNode.cpp \
	FlowSystem/Nodes/PlaySoundNode.cpp \
	FlowSystem/Nodes/Vehicle/FlowVehicleAttachment.cpp \
	FlowSystem/Nodes/Vehicle/FlowVehicleBase.cpp \
	FlowSystem/Nodes/Vehicle/FlowVehicleDamage.cpp \
	FlowSystem/Nodes/Vehicle/FlowVehicleHorn.cpp \
	FlowSystem/Nodes/Vehicle/FlowVehicleLights.cpp \
	FlowSystem/Nodes/Vehicle/FlowVehicleMoveActionMult.cpp \
	FlowSystem/Nodes/Vehicle/FlowVehicleMovement.cpp \
	FlowSystem/Nodes/Vehicle/FlowVehiclePassenger.cpp \
	FlowSystem/Nodes/Vehicle/FlowVehicleSeat.cpp \
	FlowSystem/Nodes/Vehicle/FlowVehicleTurret.cpp \
	FlowSystem/Nodes/FlowExecuteStringNode.cpp \
	GameObjects/CameraSource.cpp \
	GameObjects/GameObject.cpp \
	GameObjects/GameObjectDispatch.cpp \
	GameObjects/GameObjectSystem.cpp \
	GameObjects/GameObjectSystem_FactoryRegistration.cpp \
	GameObjects/Interactor.cpp \
	GameObjects/WorldQuery.cpp \
	GameRulesSystem.cpp \
	GameTokens/GameToken.cpp \
	GameTokens/GameTokenSystem.cpp \
	GameplayRecorder/GameplayRecorder.cpp \
	MaterialEffects/IMFXEffect.cpp \
	MaterialEffects/MFXDecalEffect.cpp \
	MaterialEffects/MFXEffect.cpp \
	MaterialEffects/MFXFlowGraphEffect.cpp \
	MaterialEffects/MFXParticleEffect.cpp \
	MaterialEffects/MFXRandomEffect.cpp \
	MaterialEffects/MFXSoundEffect.cpp \
	MaterialEffects/MaterialEffects.cpp \
	MaterialEffects/MaterialEffectsCVars.cpp \
	MaterialEffects/MaterialFGManager.cpp \
	MaterialEffects/MaterialHUDFXNodes.cpp \
	MaterialEffects/ScriptBind_MaterialEffects.cpp \
	MaterialEffects/MFXForceFeedbackFX.cpp \
	ForceFeedbackSystem/ForceFeedbackSystem.cpp \
	Network/NetDebug.cpp \
	Network/BreakReplicator.cpp \
	Network/CET_ActionMap.cpp \
	Network/CET_CVars.cpp \
	Network/CET_ClassRegistry.cpp \
	Network/CET_DemoMode.cpp \
	Network/CET_EntitySystem.cpp \
	Network/CET_GameRules.cpp \
	Network/CET_LevelLoading.cpp \
	Network/CET_NetConfig.cpp \
	Network/CET_View.cpp \
	Network/CVarListProcessor.cpp \
	Network/ClassRegistryReplicator.cpp \
	Network/DeformingBreak.cpp \
	Network/DownloadTask.cpp \
	Network/ExplosiveObjectState.cpp \
	Network/GameChannel.cpp \
	Network/GameClientChannel.cpp \
	Network/GameClientNub.cpp \
	Network/GameContext.cpp \
	Network/GameContext_RegisterExtensions.cpp \
	Network/GameQueryListener.cpp \
	Network/GameServerChannel.cpp \
	Network/GameServerNub.cpp \
	Network/GameStats.cpp \
	Network/GameStatsConfig.cpp \
	Network/GenericPlaybackListener.cpp \
	Network/GenericRecordingListener.cpp \
	Network/JointBreak.cpp \
	Network/NetworkCVars.cpp \
	Network/ObjectSelector.cpp \
	Network/PhysicsSync.cpp \
	Network/PlaneBreak.cpp \
	Network/ProceduralBreak.cpp \
	Network/ProceduralBreakingBaseListener.cpp \
	Network/ProceduralBreakingPlaybackListener.cpp \
	Network/ProceduralBreakingRecordingListener.cpp \
	Network/ScriptBind_Network.cpp \
	Network/ScriptRMI.cpp \
	Network/ScriptSerialize.cpp \
	Network/ServerTimer.cpp \
	Network/SimulateRemoveEntityParts.cpp \
	Network/VoiceController.cpp \
	Network/VoiceListener.cpp \
	ScriptBind_Action.cpp \
	ScriptBind_ActionMapManager.cpp \
	ScriptBind_ActorSystem.cpp \
	ScriptBind_Inventory.cpp \
	ScriptBind_ItemSystem.cpp \
	ScriptBind_UI.cpp \
	ScriptBind_VehicleSystem.cpp \
	Serialization/BinarySaveGame.cpp \
	Serialization/GameSerialize.cpp \
	Serialization/GameSerialize_FactoryRegistration.cpp \
	Serialization/SerializeScriptTableReader.cpp \
	Serialization/SerializeScriptTableWriter.cpp \
	Serialization/ViewNoteSaveGame.cpp \
	Serialization/XMLScriptLoader.cpp \
	Serialization/XmlLoadGame.cpp \
	Serialization/XmlSaveGame.cpp \
	VehicleSystem.cpp \
	VehicleSystem/VehicleUsableActionFlip.cpp \
	VehicleSystem/ScriptBind_Vehicle.cpp \
	VehicleSystem/ScriptBind_VehicleSeat.cpp \
	VehicleSystem/Vehicle.cpp \
	VehicleSystem/VehicleAnimation.cpp \
	VehicleSystem/VehicleCVars.cpp \
	VehicleSystem/VehicleComponent.cpp \
	VehicleSystem/VehicleDamageBehaviorAISignal.cpp \
	VehicleSystem/VehicleDamageBehaviorDestroy.cpp \
	VehicleSystem/VehicleDamageBehaviorDetachPart.cpp \
	VehicleSystem/VehicleDamageBehaviorEffect.cpp \
	VehicleSystem/VehicleDamageBehaviorGroup.cpp \
	VehicleSystem/VehicleDamageBehaviorHitPassenger.cpp \
	VehicleSystem/VehicleDamageBehaviorImpulse.cpp \
	VehicleSystem/VehicleDamageBehaviorIndicator.cpp \
	VehicleSystem/VehicleDamageBehaviorMovementNotification.cpp \
	VehicleSystem/VehicleDamageBehaviorSink.cpp \
	VehicleSystem/VehicleDamageBehaviorSpawnDebris.cpp \
	VehicleSystem/VehicleDamages.cpp \
	VehicleSystem/VehicleDamagesGroup.cpp \
	VehicleSystem/VehicleDamagesTemplateRegistry.cpp \
	VehicleSystem/VehicleHelper.cpp \
	VehicleSystem/VehiclePartAnimated.cpp \
	VehicleSystem/VehiclePartAnimatedJoint.cpp \
	VehicleSystem/VehiclePartAttachment.cpp \
	VehicleSystem/VehiclePartBase.cpp \
	VehicleSystem/VehiclePartDetachedEntity.cpp \
	VehicleSystem/VehiclePartEntity.cpp \
	VehicleSystem/VehiclePartLight.cpp \
	VehicleSystem/VehiclePartMassBox.cpp \
	VehicleSystem/VehiclePartStatic.cpp \
	VehicleSystem/VehiclePartSubPart.cpp \
	VehicleSystem/VehiclePartSubPartWheel.cpp \
	VehicleSystem/VehiclePartTread.cpp \
	VehicleSystem/VehicleSeat.cpp \
	VehicleSystem/VehicleSeatActionAnimation.cpp \
	VehicleSystem/VehicleSeatActionLights.cpp \
	VehicleSystem/VehicleSeatActionMovement.cpp \
	VehicleSystem/VehicleSeatActionPassengerIK.cpp \
	VehicleSystem/VehicleSeatActionRotateTurret.cpp \
	VehicleSystem/VehicleSeatActionSound.cpp \
	VehicleSystem/VehicleSeatActionSteeringWheel.cpp \
	VehicleSystem/VehicleSeatActionWeapons.cpp \
	VehicleSystem/VehicleSeatGroup.cpp \
	VehicleSystem/VehicleSeatSerializer.cpp \
	VehicleSystem/VehicleSystem_FactoryRegistration.cpp \
	VehicleSystem/VehicleUsableActionEnter.cpp \
	VehicleSystem/VehicleUtils.cpp \
	VehicleSystem/VehicleViewActionThirdPerson.cpp \
	VehicleSystem/VehicleViewBase.cpp \
	VehicleSystem/VehicleViewFirstPerson.cpp \
	VehicleSystem/VehicleViewThirdPerson.cpp \
	WoundSystem/PersonalWoundManager.cpp \
	WoundSystem/WeaponTypeData.cpp \
	WoundSystem/WeaponTypeTable.cpp \
	WoundSystem/WeaponTypes.cpp \
	WoundSystem/WoundManagerConf.cpp \
	WoundSystem/WoundManagers.cpp \
	WoundSystem/WoundSystem.cpp \
	WoundSystem/WoundSystemTweaks.cpp \
	WoundSystem/WoundTypeTable.cpp \
	WoundSystem/WoundTypes.cpp

PROJECT_SOURCES_CPP_ADD += CryAction_animgraph_uber.cpp\
  CryAction_main_uber.cpp\
  CryAction_main2_uber.cpp\
  CryAction_system_uber.cpp\
  CryAction_flowsystem_uber.cpp\
	CryAction_script_ser_wound_uber.cpp\
	CryAction_vehicle_uber.cpp\

endif

# vim:ts=8:sw=8

