/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2006.
-------------------------------------------------------------------------
$Id$
$DateTime$
Description: 

-------------------------------------------------------------------------
History:
- 20:09:2007   15:38 : Created by Andrey Grigoryev

*************************************************************************/

#include "StdAfx.h"
#include "StatsLogger.h"

CStatsLogger::CStatsLogger(void) : m_root(0), m_roundNum(0), m_time("")
{
}

CStatsLogger::~CStatsLogger(void)
{
	SaveFile();
}

void CStatsLogger::LevelStart(const char* mapname)
{
	SaveFile();
	m_roundNum++;

	//Create new element for new round
	m_root = gEnv->pSystem->CreateXmlNode("level");
	m_root->setAttr("mapname", mapname);
}


void CStatsLogger::PlayerPos(int plrId, const char* plrName, const char* preset, int plrTeam, Vec3& coords, f32 groundHeight, bool spectator, CTimeValue time)
{
	if(m_root != 0)
	{
		XmlNodeRef plrNode = gEnv->pSystem->CreateXmlNode("player");
		plrNode->setAttr("id", plrId);
		plrNode->setAttr("name", plrName);
		plrNode->setAttr("preset", preset);
		plrNode->setAttr("team", plrTeam);
		plrNode->setAttr("time", time.GetMilliSecondsAsInt64());
		plrNode->setAttr("spectator", spectator);
		XmlNodeRef posNode = gEnv->pSystem->CreateXmlNode("position");
		posNode->setAttr("x", coords.x);
		posNode->setAttr("y", coords.y);
		posNode->setAttr("z", coords.z);
		posNode->setAttr("ground", groundHeight);
		plrNode->addChild(posNode);
		m_root->addChild(plrNode);
	}
}

void CStatsLogger::SaveFile()
{
	if(m_roundNum == 0)
	{
		time_t ltime;
		time( &ltime );
		tm *today = localtime( &ltime );
		strftime(m_time.m_str, m_time.MAX_SIZE, "%y-%m-%d_%H_%M_%S", today);		

		gEnv->pCryPak->MakeDir(string().Format("%s/StatsLogs/Game_%s", gEnv->pCryPak->GetAlias("%USER%"), m_time.c_str()));
	}
	if(m_root != 0 && m_roundNum != 0)
	{
		ICVar *dumpFlag = gEnv->pConsole->GetCVar("sv_dumpstats");
		int flag = 1;
		if(dumpFlag)
			flag = dumpFlag->GetIVal();
		if(flag)
		{
			//save current file
			m_root->saveToFile(string().Format("%s/StatsLogs/Game_%s/round_%04u.xml",gEnv->pCryPak->GetAlias("%USER%"), m_time.c_str(), m_roundNum));
		}
	}
}



int64 CStatsLogger::GetTimePeriod(void)
{
	ICVar* period = gEnv->pConsole->GetCVar("sv_dumpstatsperiod");
	return period->GetIVal();
}

void CStatsLogger::Kill(int plr, Vec3& coords, string wname, int victimId)
{
	if(m_root != 0)
	{
		XmlNodeRef node = gEnv->pSystem->CreateXmlNode("event");
		node->setAttr("name", "Kill");
		node->setAttr("player", plr);
		node->setAttr("weapon", wname);
		node->setAttr("victim", victimId);
		XmlNodeRef posNode = gEnv->pSystem->CreateXmlNode("position");
		posNode->setAttr("x", coords.x);
		posNode->setAttr("y", coords.y);
		posNode->setAttr("z", coords.z);
		node->addChild(posNode);
		m_root->addChild(node);
	}
}

void CStatsLogger::Death(int plr, Vec3& coords, int shooterId)
{
	if(m_root != 0)
	{
		XmlNodeRef node = gEnv->pSystem->CreateXmlNode("event");
		node->setAttr("name", "Death");
		node->setAttr("player", plr);
		node->setAttr("shooter", shooterId);
		XmlNodeRef posNode = gEnv->pSystem->CreateXmlNode("position");
		posNode->setAttr("x", coords.x);
		posNode->setAttr("y", coords.y);
		posNode->setAttr("z", coords.z);
		node->addChild(posNode);
		m_root->addChild(node);
	}
}

void CStatsLogger::StartPush(int plr, Vec3& coords)
{
	if(m_root != 0)
	{
		XmlNodeRef node = gEnv->pSystem->CreateXmlNode("event");
		node->setAttr("name", "StartPush");
		node->setAttr("player", plr);
		XmlNodeRef posNode = gEnv->pSystem->CreateXmlNode("position");
		posNode->setAttr("x", coords.x);
		posNode->setAttr("y", coords.y);
		posNode->setAttr("z", coords.z);
		node->addChild(posNode);
		m_root->addChild(node);
	}
}

void CStatsLogger::EndPush(int plr, Vec3& coords)
{
	if(m_root != 0)
	{
		XmlNodeRef node = gEnv->pSystem->CreateXmlNode("event");
		node->setAttr("name", "EndPush");
		node->setAttr("player", plr);
		XmlNodeRef posNode = gEnv->pSystem->CreateXmlNode("position");
		posNode->setAttr("x", coords.x);
		posNode->setAttr("y", coords.y);
		posNode->setAttr("z", coords.z);
		node->addChild(posNode);
		m_root->addChild(node);
	}
}

void CStatsLogger::Kick(int plr, Vec3& coords)
{
	if(m_root != 0)
	{
		XmlNodeRef node = gEnv->pSystem->CreateXmlNode("event");
		node->setAttr("name", "Kick");
		node->setAttr("player", plr);
		XmlNodeRef posNode = gEnv->pSystem->CreateXmlNode("position");
		posNode->setAttr("x", coords.x);
		posNode->setAttr("y", coords.y);
		posNode->setAttr("z", coords.z);
		node->addChild(posNode);
		m_root->addChild(node);
	}
}

void CStatsLogger::FallNPlay(int plr, Vec3& coords)
{
	if(m_root != 0)
	{
		XmlNodeRef node = gEnv->pSystem->CreateXmlNode("event");
		node->setAttr("name", "FallNPlay");
		node->setAttr("player", plr);
		XmlNodeRef posNode = gEnv->pSystem->CreateXmlNode("position");
		posNode->setAttr("x", coords.x);
		posNode->setAttr("y", coords.y);
		posNode->setAttr("z", coords.z);
		node->addChild(posNode);
		m_root->addChild(node);
	}
}

void CStatsLogger::ClimbAlone(int plr, Vec3& coords)
{
	if(m_root != 0)
	{
		XmlNodeRef node = gEnv->pSystem->CreateXmlNode("event");
		node->setAttr("name", "ClimbAlone");
		node->setAttr("player", plr);
		XmlNodeRef posNode = gEnv->pSystem->CreateXmlNode("position");
		posNode->setAttr("x", coords.x);
		posNode->setAttr("y", coords.y);
		posNode->setAttr("z", coords.z);
		node->addChild(posNode);
		m_root->addChild(node);
	}
}

void CStatsLogger::ClimbAssist(int plr, Vec3& coords)
{
	if(m_root != 0)
	{
		XmlNodeRef node = gEnv->pSystem->CreateXmlNode("event");
		node->setAttr("name", "ClimbAssist");
		node->setAttr("player", plr);
		XmlNodeRef posNode = gEnv->pSystem->CreateXmlNode("position");
		posNode->setAttr("x", coords.x);
		posNode->setAttr("y", coords.y);
		posNode->setAttr("z", coords.z);
		node->addChild(posNode);
		m_root->addChild(node);
	}
}

void CStatsLogger::ClimbCoop(int plr, Vec3& coords)
{
	if(m_root != 0)
	{
		XmlNodeRef node = gEnv->pSystem->CreateXmlNode("event");
		node->setAttr("name", "ClimbCoop");
		node->setAttr("player", plr);
		XmlNodeRef posNode = gEnv->pSystem->CreateXmlNode("position");
		posNode->setAttr("x", coords.x);
		posNode->setAttr("y", coords.y);
		posNode->setAttr("z", coords.z);
		node->addChild(posNode);
		m_root->addChild(node);
	}
}
