/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2006.
-------------------------------------------------------------------------
$Id$
$DateTime$
Description: 

-------------------------------------------------------------------------
History:
- 20:09:2007   15:38 : Created by Andrey Grigoryev

*************************************************************************/

#ifndef __STATSLOGGER_H__
#define __STATSLOGGER_H__

#if _MSC_VER > 1000
# pragma once
#endif

class CStatsLogger
{
public:
	CStatsLogger(void);
	~CStatsLogger(void);

	void LevelStart(const char* mapname);
	void PlayerPos(int plrId, const char* plrName, const char* preset, int plrTeam, Vec3& coords, f32 groundHeight, bool spectator, CTimeValue time);
	void Kill(int plr, Vec3& coords, string wname, int victimId);
	void Death(int plr, Vec3& coords, int shooterId);
	void StartPush(int plr, Vec3& coords);
	void EndPush(int plr, Vec3& coords);
	void Kick(int plr, Vec3& coords);
	void FallNPlay(int plr, Vec3& coords);
	void ClimbAlone(int plr, Vec3& coords);
	void ClimbAssist(int plr, Vec3& coords);
	void ClimbCoop(int plr, Vec3& coords);
	int64 GetTimePeriod(void);
	void SaveFile();

private:


	int m_roundNum;
	CryFixedStringT<128> m_time;
	
	XmlNodeRef m_root;

};


#endif