/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2006.
-------------------------------------------------------------------------
$Id$
$DateTime$
Description: Implements a damage behavior which send an AI signal

-------------------------------------------------------------------------
History:
- 23:11:2006: Created by Mathieu Pinard

*************************************************************************/
#include "StdAfx.h"
#include "IAgent.h"
#include "IVehicleSystem.h"
#include "VehicleDamageBehaviorAISignal.h"

//------------------------------------------------------------------------
bool CVehicleDamageBehaviorAISignal::Init(IVehicle* pVehicle, const CVehicleParams& table)
{
	m_pVehicle = pVehicle;

	CVehicleParams signalTable = table.findChild("AISignal");
	if (!signalTable)
		return false;

	if (!signalTable.getAttr("signalId", m_signalId))
		return false;
	
	m_signalText = signalTable.getAttr("signalText");

	return true;
}

//------------------------------------------------------------------------
void CVehicleDamageBehaviorAISignal::OnDamageEvent(EVehicleDamageBehaviorEvent event, 
																									 const SVehicleDamageBehaviorEventParams& behaviorParams)
{
	if (event != eVDBE_Hit)
		return;

	IEntity* pEntity = m_pVehicle->GetEntity();
	if (!pEntity || !pEntity->GetAI())
		return;

	IAISystem* pAISystem = gEnv->pAISystem;
	CRY_ASSERT(pAISystem);

	IAISignalExtraData* pExtraData = pAISystem->CreateSignalExtraData();
	CRY_ASSERT(pExtraData);

	if (pExtraData)
		pExtraData->iValue = behaviorParams.shooterId;

	pAISystem->SendSignal(SIGNALFILTER_SENDER, m_signalId, m_signalText.c_str(), pEntity->GetAI(), pExtraData);
}

void CVehicleDamageBehaviorAISignal::GetMemoryUsage(ICrySizer * s) const
{
	s->AddObject(this,sizeof(*this));
	s->AddObject(m_signalText);
}

DEFINE_VEHICLEOBJECT(CVehicleDamageBehaviorAISignal);
