/********************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2006-2007.
---------------------------------------------------------------------
File name:   PersonalWoundManager.h
$Id$
$DateTime$
Description: Manages wound data for a single puppet
---------------------------------------------------------------------
History:
- 14:03:2007 : Created by Ricardo Pillosu

*********************************************************************/
#ifndef _PERSONAL_WOUND_MANAGER_H_
#define _PERSONAL_WOUND_MANAGER_H_

#include "IWoundSystem.h"

struct SWoundManagerConfEntry;
struct SWoundResult;
struct SWeaponResult;
struct SWoundParams;
struct SWoundArea;

// -------------------------------------------------------------------
class CPersonalWoundManager
{
    // Methods -------------------------------------------------------

  public:
    // Base ----------------------------------------------------------
    CPersonalWoundManager();
    virtual                         ~CPersonalWoundManager();
    bool                            Init( EntityId Id, SWoundManagerConfEntry const* pConf );
    bool                            IsActive() const;
    bool                            Update( float fElapsedTime );

    // Utils ---------------------------------------------------------
    EntityId                        GetEntityId() const;
    SWoundManagerConfEntry const*   GetConf() const;
    SWoundResult										CreateWound( const SWeaponResult&  sWeaponDamage,
                                                 const SWoundParams&   sWoundParams );
		
		int															GetHealth( const SWoundArea& sWoundArea ) const;
		int															GetMinHealth( const SWoundArea& sWoundArea ) const;
		int															GetMaxHealth( const SWoundArea& sWoundArea ) const;
		int															GetOverallDamage() const { return m_iOverallDamage; }
		float														GetHealthPercentage( const SWoundArea& sWoundArea ) const;
		void														ModifyHealth( const SWoundArea& sWoundArea, int iDeltaAmount );
		void														SetHealth( const SWoundArea& sWoundArea, int iAmount );
		void														RestoreFullHealth();
		bool                            IsPlayer() const;
		bool														AllowRegeneration( bool bAllow );

	private:
		float						CalculateTimeToNextHealthLevelChange( const SWoundArea& sWoundArea ) const;

		void            Regenerate( float fElapsedTime );
		void						UpdateHealthLevel( const SWoundArea& sWoundArea );
		void            UpdateHealthLevels();
		void            ManageEffects( const SWoundParams& sWoundParams, 
																	 const SWoundArea *sWoundArea=NULL,
																	 bool bHealthDecreased=true );
    IActor*         GetActor();
    IActor const*   GetActor() const;

  private:
		struct SHealthTracking
		{
			float	fCurrentPercentageLeftCenter[EBWA_COUNT]; // tracking left or center parts
			float	fCurrentPercentageRight[EBWA_COUNT];			// tracking right parts (some will be unused)

			float	fLastPercentageLeftCenter[EBWA_COUNT]; // tracking left or center parts
			float	fLastPercentageRight[EBWA_COUNT];			// tracking right parts (some will be unused)

			CPersonalWoundManager* pManager;

			SHealthTracking();
			void					ModifyHealth( const SWoundArea& sWoundArea, int iDeltaAmount );
			void					SetHealth( const SWoundArea& sWoundArea, int iAmount );
			int						GetHealth( const SWoundArea& sWoundArea, bool bGetLast=false ) const;
			float					GetHealthPercentage( const SWoundArea& sWoundArea, bool bGetLast=false ) const;
			void					ClearLast( const SWoundArea& sWoundArea );
			float         CalculateHealthPercentage( const SWoundArea& sWoundArea, int iAmount ) const;
			int		        CalculateHealthFromPercentage( const SWoundArea& sWoundArea, float fPercentage ) const;
			float*				GetHealthPointer( const SWoundArea& sWoundArea, bool bGetLast=false );
			float const*	GetHealthPointer( const SWoundArea& sWoundArea, bool bGetLast=false ) const;
		};

    bool                            m_bInit;
		bool														m_bAllowRegeneration;
    float                           m_fTimeFromLastRegeneration;
    EntityId                        m_EntityId;
		SHealthTracking									m_sHealthTracking;
		int															m_iOverallDamage;
    SWoundManagerConfEntry const*   m_pConf;
};
#endif // _PERSONAL_WOUND_MANAGER_H_
