/********************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2006-2007.
---------------------------------------------------------------------
File name:   WeaponTypeData.h
$Id$
$DateTime$
Description: Stores a single Weapon Data
---------------------------------------------------------------------
History:
- 08:03:2007 : Created by Ricardo Pillosu

*********************************************************************/
#ifndef _WEAPON_TYPE_DATA_H_
  #define _WEAPON_TYPE_DATA_H_

class CWeaponTypeTable;
struct SWeaponResult;
enum EBodyHitLocations;

class CWeaponTypeData
{
    // Methods -------------------------------------------------------

  public:
    // Base ----------------------------------------------------------
    CWeaponTypeData( const char* sWeaponName );
    virtual       ~CWeaponTypeData();

    // Utils ---------------------------------------------------------
    bool          Reload( XmlNodeRef& xmlTable );
    SWeaponResult GetDamage( float fRange, const SHitLocation& sHitLocation ) const;
    float         GetMaxRange() const;

  private:
    void  Shutdown();

  public:
    string                          m_strName;
    std::vector<CWeaponTypeTable *> m_vecTables;
};
#endif // _WEAPON_TYPE_TABLE_H_
