/********************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2006-2007.
---------------------------------------------------------------------
File name:   WoundManagersConf.h
$Id$
$DateTime$
Description: Stores and configuration data for Wound Managers
---------------------------------------------------------------------
History:
- 14:03:2007 : Created by Ricardo Pillosu

*********************************************************************/
#ifndef _WOUND_MANAGER_CONF_H_
  #define _WOUND_MANAGER_CONF_H_

#include "IWoundSystem.h"

class CWoundTypeTable;

struct SWoundAreaEntry
{
	bool	bEnabled;
	int		iMinHealth;
	int		iMaxHealth;

	SWoundAreaEntry();
};

struct SWoundManagerConfEntry
{
  string                      sName;
  int                         iRegenerationAmount;
  float                       fRegenerationRate;
	SWoundAreaEntry							sWoundAreas[EBWA_COUNT];
  CWoundTypeTable const*      pWoundTypesTable;
	std::vector<SWoundArea>			vWoundAreas;

  SWoundManagerConfEntry();
	bool														ReloadWoundArea( int iSubCell, const char* sCellContent, EBodyWoundAreas eBodyWoundArea );
  bool														Reload( int iCell, const char* sCellContent );
	void														ReloadWoundAreaList();

	bool														IsBodyWoundAreaEnabled( EBodyWoundAreas eBodyWoundArea ) const;
	int															GetMinHealth( EBodyWoundAreas eBodyWoundArea ) const;
  int															GetMaxHealth( EBodyWoundAreas eBodyWoundArea ) const;
	const std::vector<SWoundArea>&	GetWoundAreaList() const;
};

// Main Class that gives all functionality ---------------------------
class CWoundManagersConf
{

  public:

    /*$1-Basics --------------------------------------------------------------*/
    CWoundManagersConf();
    virtual ~CWoundManagersConf();

    /*$1-Utils ---------------------------------------------------------------*/
    bool                            Init();
    bool                            Reload( XmlNodeRef& xmlTable );
    SWoundManagerConfEntry const*   GetConf( const char* sConfName ) const;

  private:
    void  Shutdown();

  /*$1- Members --------------------------------------------------------------*/
  public:

  private:
    bool                                  m_bInit;
    std::vector<SWoundManagerConfEntry *> m_vecConfs;
};
#endif // _WOUND_MANAGER_CONF_H_
