/********************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2006-2007.
---------------------------------------------------------------------
File name:   WoundManagers.h
$Id$
$DateTime$
Description: Manages all Personal Wound Managers and its configurations
---------------------------------------------------------------------
History:
- 14:03:2007 : Created by Ricardo Pillosu

*********************************************************************/
#ifndef _WOUND_MANAGERS_H_
  #define _WOUND_MANAGERS_H_

class CWoundManagersConf;
class CPersonalWoundManager;

// -------------------------------------------------------------------
class CWoundManagers 
{
    // Methods -------------------------------------------------------

  public:
    // Base ----------------------------------------------------------
    CWoundManagers();
    virtual                       ~CWoundManagers();
    bool                          Init();
    bool                          Reload();
    void                          Reset();
    bool                          Update(float fElapsedTime);

		
    // Utils ---------------------------------------------------------
		bool                          CreatePersonalWoundManager( EntityId idEntity, const char* sConfigurationToUse );
    CPersonalWoundManager*        GetPersonalWoundManager( EntityId idEntity );
    CPersonalWoundManager const*  GetPersonalWoundManager( EntityId idEntity ) const;
    const char*                   GetConfName( EntityId IdEntity ) const;
		bool													AllowRegeneration( EntityId IdEntity, bool bAllow );
		void													RestoreFullHealth(EntityId IdEntity);

		int														GetOverallDamage( EntityId IdEntity ) const;
		int														GetHealth( EntityId IdEntity, const SWoundArea& sWoundArea ) const;
		int														GetMinHealth( EntityId IdEntity, const SWoundArea& sWoundArea ) const;
		int														GetMaxHealth( EntityId IdEntity, const SWoundArea& sWoundArea ) const;
		// Returns value [-1.0, 1.0] as percentage of max health
		float													GetHealthPercentage( EntityId IdEntity, const SWoundArea& sWoundArea ) const;

  private:
    void  Shutdown();
		bool	DeletePersonalWoundManager( EntityId idEntity );

  private:
    bool                                  m_bInit;
		CWoundManagersConf*                   m_pConfigurations;

		typedef std::map<EntityId, CPersonalWoundManager *> TMapPersonals;
    std::map<EntityId, CPersonalWoundManager *>  m_mapPersonals;
};
#endif // _WOUND_MANAGERS_CONF_H_
