/********************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2006-2007.
---------------------------------------------------------------------
File name:   WoundSystem.h
$Id$
$DateTime$
Description: Core of the Wound System
---------------------------------------------------------------------
History:
- 01:03:2007 : Created by Ricardo Pillosu

*********************************************************************/
#ifndef _WOUND_SYSTEM_H_
#define _WOUND_SYSTEM_H_

#include "IWoundSystem.h"
#include "IFileChangeMonitor.h"

class CWeaponTypes;
class CWoundTypes;
class CWoundManagers;
class CWoundSystemTweaks;
struct SWoundResult;
struct SHitLocation;
enum EBodyHitLocations;

class CWoundSystem 
	: public IWoundSystem,
		public IFileChangeListener
{

  public:

    /*$1- Singleton Stuff ----------------------------------------------------*/
    static CWoundSystem&  ref();
    static bool           Create();
    void                  Shutdown();

    /*$1- Basics -------------------------------------------------------------*/
    void  Init();
    bool  Update( float fElapsedTime );
    bool  Reload();
    void  Reset();

		/*$1-IFileChangeListener -------------------------------------------------*/
		void	OnFileChange( const char* sFilename );

		/*$1-IEditorSetGameModeListener ------------------------------------------*/
		void	OnEditorSetGameMode( bool bGameMode );

    /*$1- Utils --------------------------------------------------------------*/
    SWoundResult    CreateWound( EntityId            idShooter,
                                 EntityId            idVictim,
                                 const char*         sWeaponName,
                                 const SHitLocation& sHitLocation,
                                 float               fRange, 
																 float               fDamageModifier /*=1.0f*/ );

    CWoundTypes const*				GetWoundTypes() const;
    CWoundSystemTweaks const*	GetTweaks() const;
    void											SetPersonalConf( EntityId IdEntity, const char* sConfName );
    const char*								GetPersonalConf( EntityId IdEntity ) const;
    bool											AllowRegeneration( EntityId IdEntity, bool bAllow );
		void											RestoreFullHealth(EntityId IdEntity);

		int												GetOverallDamage( EntityId IdEntity ) const;
		int												GetHealth( EntityId IdEntity, const SWoundArea& sWoundArea ) const;
		int												GetMinHealth( EntityId IdEntity, const SWoundArea& sWoundArea ) const;
		int												GetMaxHealth( EntityId IdEntity, const SWoundArea& sWoundArea ) const;
		// Returns value [-1.0, 1.0] as percentage of max health
		float											GetHealthPercentage( EntityId IdEntity, const SWoundArea& sWoundArea ) const;
		
		float											GetWeaponMaxRange( const char* sWeaponName ) const;
		int												GetWeaponDamage( const char* sWeaponName, float fRange, const SHitLocation& sHitLocation ) const;

  protected:

    /*$1- Creation and destruction via singleton -----------------------------*/
    CWoundSystem();
    virtual ~CWoundSystem();

    /*$1- Utils --------------------------------------------------------------*/
    void  ConfigureEffects();

  private:

    /*$1- Members ------------------------------------------------------------*/
    bool                  m_bInit;
		bool									m_bReloadOnGameModeExit;
		static CWoundSystem*  m_pInstance;
    bool                  m_bActive;
    unsigned int          m_uDebugLevel;
    float                 m_fDifficulty;
    CWeaponTypes*         m_pWeaponTypes;
    CWoundTypes*          m_pWoundTypes;
    CWoundManagers*       m_pWoundManagers;
    CWoundSystemTweaks*   m_pTweakValues;
};
#endif // _WOUND_SYSTEM_H_
