/********************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2006-2007.
---------------------------------------------------------------------
File name:   WoundSystemTweaks.cpp
$Id$
$DateTime$
Description: Tweaks the values of the WOund System to simplify balancing
---------------------------------------------------------------------
History:
- 11:04:2007 : Created by Ricardo Pillosu

*********************************************************************/
#include "StdAfx.h"

#include "WeaponTypes.h"
#include "WoundSystemTweaks.h"

// Description:
//   Constructor
// Arguments:
//
// Return:
//
CWoundSystemTweaks::CWoundSystemTweaks()
{
  m_bInit = false;
  m_pfGlobalDamageModifier = NULL;
  m_pfPlayerDamageOutputModifier = NULL;
  m_pfNPCDamageOutputModifier = NULL;
}

// Description:
//   Destructor
// Arguments:
//
// Return:
//
CWoundSystemTweaks::~CWoundSystemTweaks()
{
  Shutdown();
}

// Description:
//   Init
// Arguments:
//
// Return:
//
bool CWoundSystemTweaks::Init()
{
  bool  bRet = false;

  m_bInit = true;

  m_pfGlobalDamageModifier = gEnv->pConsole->RegisterFloat(
      "ws_GlobalDamageModifier",
      1.0f,
      VF_CHEAT | VF_DUMPTODISK,
      "Multiplier to all damage done" );

  m_pfPlayerDamageOutputModifier = gEnv->pConsole->RegisterFloat(
      "ws_PlayerDamageOutputModifier",
      1.0f,
      VF_CHEAT | VF_DUMPTODISK,
      "Multiplier to all damage done by player" );

  m_pfNPCDamageOutputModifier = gEnv->pConsole->RegisterFloat(
      "ws_NPCDamageOutputModifier",
      1.0f,
      VF_CHEAT | VF_DUMPTODISK,
      "Multiplier to all damage done by NPCs" );

	m_piForceFatalWoundInstantKill = gEnv->pConsole->RegisterInt(
		"cl_WSForceFatalWoundInstantKill",
		0,
		VF_CHEAT | VF_DUMPTODISK,
		"When true, makes fatal wounds kill instantly, ignoring any delay value" );

  return( bRet );
}

// Description:
//   Reload configuration
// Arguments:
//
// Return:
//
void CWoundSystemTweaks::Shutdown()
{
}

// Description:
//   Change the wound as the tweak values
// Arguments:
//
// Return:
//
void CWoundSystemTweaks::Filter( bool bShooterIsPlayer, bool bVictimIsPlayer, SWeaponResult& sWeaponResult ) const
{
  assert( m_bInit == true );

  if( bShooterIsPlayer == true )
  {
    sWeaponResult.uDamage = (unsigned int)((signed)sWeaponResult.uDamage * m_pfPlayerDamageOutputModifier->GetFVal());
  }

  if( bVictimIsPlayer == true )
  {
    sWeaponResult.uDamage = (unsigned int)((signed)sWeaponResult.uDamage * m_pfNPCDamageOutputModifier->GetFVal());
  }

  sWeaponResult.uDamage = (unsigned int)((signed)sWeaponResult.uDamage * m_pfGlobalDamageModifier->GetFVal());
}

// Description:
//   Change the wound as the tweak values
// Arguments:
//
// Return:
//
bool CWoundSystemTweaks::IsForceFatalWoundInstantKill() const
{
	return( 1 == m_piForceFatalWoundInstantKill->GetIVal() );
}