/********************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2006-2007.
---------------------------------------------------------------------
File name:   WoundSystemTweaks.h
$Id$
$DateTime$
Description: Tweaks the values of the WOund System to simplify balancing
---------------------------------------------------------------------
History:
- 11:04:2007 : Created by Ricardo Pillosu

*********************************************************************/
#ifndef _WOUND_SYSTEM_TWEAKS_H_
  #define _WOUND_SYSTEM_TWEAKS_H_

struct ICVar;
struct SWeaponResult;

class CWoundSystemTweaks
{

  public:

    /*$1-Basics --------------------------------------------------------------*/
    CWoundSystemTweaks();
    virtual ~CWoundSystemTweaks();

    /*$1-Utils ---------------------------------------------------------------*/
    bool  Init();
    void  Filter( bool bShooterIsPlayer, bool bVictimIsPlayer, SWeaponResult& sWeaponResult ) const;
		bool  IsForceFatalWoundInstantKill() const;

  private:
    void  Shutdown();

  /*$1- Members --------------------------------------------------------------*/
  public:

  private:
    bool    m_bInit;
    ICVar*  m_pfGlobalDamageModifier;
    ICVar*  m_pfPlayerDamageOutputModifier;
    ICVar*  m_pfNPCDamageOutputModifier;
		ICVar*  m_piForceFatalWoundInstantKill;
};
#endif // _WOUND_SYSTEM_TWEAKS_H_
