/********************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2006-2007.
---------------------------------------------------------------------
File name:   WoundTypes.h
$Id$
$DateTime$
Description: Stores and manages Wound Types
---------------------------------------------------------------------
History:
- 06:03:2007 : Created by Ricardo Pillosu

*********************************************************************/
#ifndef _WOUND_TYPES_H_
#define _WOUND_TYPES_H_

#include "IWoundSystem.h"
#include "../ActorEffectsManager/ActorEffects.h"

class CWoundTypeTable;
class CPersonalWoundManager;
struct SWoundTypeTableEntry;
enum EBodyHitLocations;

// -------------------------------------------------------------------
struct SWoundEffect
{
	SActorEffectValueHolder sValue;
	float		fDuration;

	SWoundEffect();
};

// -------------------------------------------------------------------
struct SWoundParams
{
	SWoundEffect	sEffects[EAET_COUNT];
	bool					bIsCrit;
	float					fDamageMultiplier;	
	
  SWoundParams();
  bool  ApplyEntry( SWoundTypeTableEntry* pEntry );
};

// Main Class that gives all functionality ---------------------------
class CWoundTypes 
{

  public:

    /*$1-Basics --------------------------------------------------------------*/
    CWoundTypes();
    virtual ~CWoundTypes();

    /*$1-Utils ---------------------------------------------------------------*/
    bool                    Init();
    bool                    Reload();
    EBodyWoundAreas         GetWoundAreaFromName( const char* cWoundAreaName ) const;
    const char*             GetWoundNameFromArea( EBodyWoundAreas eBodyWoundArea ) const;
    SWoundParams            GetWoundParams( CPersonalWoundManager const*  pVictim,
																						const SWoundArea&             sWoundArea ) const;
    const CWoundTypeTable*  GetWoundTypeTable( const char* sName ) const;

  private:
    void  Shutdown();
    void  AssignWoundAreaNames();

  /*$1- Members --------------------------------------------------------------*/
  public:

  private:
    bool                            m_bInit;
		std::vector<string>             m_vecWoundAreaNames;
    std::vector<CWoundTypeTable *>  m_vecWoundTypeTables;
};
#endif // _WOUND_TYPES_H_
