#include "stdafx.h"

#include "DaubechiWavelet.h"

// Coefficients taken from LIGO project

static TWavereal dbc1[2]={0.70710678118655f,0.70710678118655f};

static TWavereal dbc2[4]=
{0.48296291314469f,0.83651630373747f, 0.22414386804186f,-0.12940952255092f};

static TWavereal dbc3[6]=
{0.33267055295096f,0.80689150931334f,0.45987750211933f,-0.13501102001039f,
-0.08544127388224f,0.03522629188210f};

static TWavereal dbc4[8]=
{0.23037781330886f,0.71484657055254f,0.63088076792959f,-0.02798376941698f,
-0.18703481171888f,0.03084138183599f,0.03288301166698f,-0.01059740178500f};

static TWavereal dbc5[10]=
{0.16010239797413f,0.60382926979747f,0.72430852843857f,0.13842814590110f,
-0.24229488706619f,-0.03224486958503f,0.07757149384007f,-0.00624149021301f,
-0.01258075199902f,0.00333572528500f};

static TWavereal dbc6[12]=
{0.11154074335008f,0.49462389039839f,0.75113390802158f,0.31525035170924f,
-0.22626469396517f,-0.12976686756710f,0.09750160558708f,0.02752286553002f,
-0.03158203931803f,0.00055384220099f,0.00477725751101f,-0.00107730108500f};

static TWavereal dbc7[14]=
{0.07785205408506f,0.39653931948231f,0.72913209084656f,0.46978228740536f,
-0.14390600392911f,-0.22403618499417f,0.07130921926705f,0.08061260915107f,
-0.03802993693503f,-0.01657454163102f,0.01255099855601f,0.00042957797300f,
-0.00180164070400f,0.00035371380000f};

static TWavereal dbc8[16]=
{0.05441584224308f,0.31287159091447f,0.67563073629801f,0.58535468365487f,
-0.01582910525602f,-0.28401554296243f,0.00047248457400f,0.12874742662019f,
-0.01736930100202f,-0.04408825393106f,0.01398102791702f,0.00874609404702f,
-0.00487035299301f,-0.00039174037300f,0.00067544940600f,-0.00011747678400f};

static TWavereal dbc9[18]=
{0.03807794736317f,0.24383467463767f,0.60482312367678f,0.65728807803664f,
0.13319738582209f,-0.29327378327259f,-0.09684078322088f,0.14854074933476f,
0.03072568147832f,-0.06763282905952f,0.00025094711499f,0.02236166212352f,
-0.00472320475789f,-0.00428150368190f,0.00184764688296f,0.00023038576400f,
-0.00025196318900f,0.00003934732000f};

static TWavereal dbc10[20]=
{0.02667005790095f,0.18817680007762f,0.52720118893092f,0.68845903945259f,
0.28117234366043f,-0.24984642432649f,-0.19594627437660f,0.12736934033574f,
0.09305736460381f,-0.07139414716586f,-0.02945753682195f,0.03321267405893f,
0.00360655356699f,-0.01073317548298f,0.00139535174699f,0.00199240529499f,
-0.00068585669500f,-0.00011646685499f,0.00009358867000f,-0.00001326420300f};

static TWavereal dbc11[22]=
{0.01869429776147f,0.14406702115062f,0.44989976435603f,0.68568677491617f,
0.41196436894790f,-0.16227524502747f,-0.27423084681793f,0.06604358819669f,
0.14981201246638f,-0.04647995511667f,-0.06643878569502f,0.03133509021905f,
0.02084090436018f,-0.01536482090620f,-0.00334085887301f,0.00492841765606f,
-0.00030859285882f,-0.00089302325067f,0.00024915252355f,0.00005443907470f,
-0.00003463498419f,0.00000449427428f};

static TWavereal dbc12[24]=
{0.01311225795723f,0.10956627282118f,0.37735513521419f,0.65719872257928f,
0.51588647842779f,-0.04476388565377f,-0.31617845375276f,-0.02377925725606f,
0.18247860592758f,0.00535956967437f,-0.09643212009649f,0.01084913025583f,
0.04154627749509f,-0.01221864906975f,-0.01284082519830f,0.00671149900880f,
0.00224860724100f,-0.00217950361863f,0.00000654512821f,0.00038865306282f,
-0.00008850410921f,-0.00002424154576f,0.00001277695222f,-0.00000152907176f};

static TWavereal dbc13[26]=
{0.00920213353896f,0.08286124387290f,0.31199632216043f,0.61105585115878f,
0.58888957043121f,0.08698572617964f,-0.31497290771138f,-0.12457673075080f,
0.17947607942935f,0.07294893365679f,-0.10580761818792f,-0.02648840647534f,
0.05613947710028f,0.00237997225405f,-0.02383142071033f,0.00392394144879f,
0.00725558940162f,-0.00276191123466f,-0.00131567391189f,0.00093232613087f,
0.00004925152513f,-0.00016512898856f,0.00003067853758f,0.00001044193057f,
-0.00000470041648f,0.00000052200351f};

static TWavereal dbc14[28]=
{0.00646115346009f,0.06236475884939f,0.25485026779257f,0.55430561794077f,
0.63118784910472f,0.21867068775886f,-0.27168855227868f,-0.21803352999321f,
0.13839521386480f,0.13998901658447f,-0.08674841156811f,-0.07154895550399f,
0.05523712625925f,0.02698140830794f,-0.03018535154036f,-0.00561504953034f,
0.01278949326634f,-0.00074621898927f,-0.00384963886802f,0.00106169108561f,
0.00070802115424f,-0.00038683194731f,-0.00004177724577f,0.00006875504253f,
-0.00001033720918f,-0.00000438970490f,0.00000172499468f,-0.00000017871400f};

static TWavereal dbc15[30]=
{0.00453853736158f,0.04674339489277f,0.20602386398700f,0.49263177170816f,
0.64581314035744f,0.33900253545474f,-0.19320413960915f,-0.28888259656697f,
0.06528295284880f,0.19014671400716f,-0.03966617655576f,-0.11112093603722f,
0.03387714392350f,0.05478055058448f,-0.02576700732848f,-0.02081005016973f,
0.01508391802781f,0.00510100036039f,-0.00648773456032f,-0.00024175649076f,
0.00194332398038f,-0.00037348235414f,-0.00035956524436f,0.00015589648992f,
0.00002579269916f,-0.00002813329627f,0.00000336298718f,0.00000181127041f,
-0.00000063168823f,0.00000006133360f};

static TWavereal dbc16[32]=
{0.00318922092535f,0.03490771432367f,0.16506428348885f,0.43031272284599f,
0.63735633208377f,0.44029025688634f,-0.08975108940249f,-0.32706331052792f,
-0.02791820813305f,0.21119069394708f,0.02734026375270f,-0.13238830556381f,
-0.00623972275247f,0.07592423604429f,-0.00758897436884f,-0.03688839769171f,
0.01029765964098f,0.01399376885985f,-0.00699001456340f,-0.00364427962149f,
0.00312802338121f,0.00040789698085f,-0.00094102174936f,0.00011424152004f,
0.00017478724523f,-0.00006103596621f,-0.00001394566899f,0.00001133660866f,
-0.00000104357134f,-0.00000073636568f,0.00000023087841f,-0.00000002109340f};

static TWavereal dbc17[34]=
{0.00224180700104f,0.02598539370361f,0.13121490330784f,0.37035072415269f,
0.61099661568471f,0.51831576405701f,0.02731497040330f,-0.32832074836400f,
-0.12659975221589f,0.19731058956506f,0.10113548917751f,-0.12681569177829f,
-0.05709141963170f,0.08110598665412f,0.02231233617804f,-0.04692243838934f,
-0.00327095553587f,0.02273367658392f,-0.00304298998137f,-0.00860292152033f,
0.00296799669153f,0.00230120524216f,-0.00143684530480f,-0.00032813251941f,
0.00043946542777f,-0.00002561010957f,-0.00008204803202f,0.00002318681380f,
0.00000699060099f,-0.00000450594248f,0.00000030165496f,0.00000029577009f,
-0.00000008423948f,0.00000000726749f};

static TWavereal dbc18[36]=
{0.00157631021844f,0.01928853172418f,0.10358846582258f,0.31467894133751f,
0.57182680776747f,0.57180165488952f,0.14722311197014f,-0.29365404073704f,
-0.21648093400555f,0.14953397556546f,0.16708131276330f,-0.09233188415126f,
-0.10675224666029f,0.06488721621171f,0.05705124773838f,-0.04452614190323f,
-0.02373321039602f,0.02667070592642f,0.00626216795425f,-0.01305148094667f,
0.00011863003383f,0.00494334360546f,-0.00111873266700f,-0.00134059629834f,
0.00062846568297f,0.00021358156191f,-0.00019864855231f,-0.00000015359171f,
0.00003741237881f,-0.00000852060254f,-0.00000333263448f,0.00000176871298f,
-0.00000007691633f,-0.00000011760988f,0.00000003068836f,-0.00000000250793f};

static TWavereal dbc19[38]=
{0.00110866976318f,0.01428109845070f,0.08127811326510f,0.26438843173972f,
0.52443637746232f,0.60170454912487f,0.26089495264991f,-0.22809139421438f,
-0.28583863175437f,0.07465226970810f,0.21234974330584f,-0.03351854190149f,
-0.14278569503735f,0.02758435062625f,0.08690675555608f,-0.02650123624947f,
-0.04567422627659f,0.02162376740985f,0.01937554988940f,-0.01398838867821f,
-0.00586692228080f,0.00704074736719f,0.00076895435932f,-0.00268755180066f,
0.00034180865347f,0.00073580252051f,-0.00026067613568f,-0.00012460079173f,
0.00008711270467f,0.00000510595049f,-0.00001664017630f,0.00000301096432f,
0.00000153193148f,-0.00000068627557f,0.00000001447088f,0.00000004636938f,
-0.00000001116402f,0.00000000086668f};

static TWavereal dbc20[40]=
{0.00077995361366f,0.01054939462487f,0.06342378045858f,0.21994211354965f,
0.47269618530714f,0.61049323893374f,0.36150229873647f,-0.13921208801035f,
-0.32678680043141f,-0.01672708830897f,0.22829105081798f,0.03985024645728f,
-0.15545875070610f,-0.02471682733811f,0.10229171917456f,0.00563224685888f,
-0.06172289962210f,0.00587468181393f,0.03229429953237f,-0.00878932492251f,
-0.01381052613626f,0.00672162730258f,0.00442054238715f,-0.00358149425955f,
-0.00083156217282f,0.00139255961930f,-0.00005349759845f,-0.00038510474870f,
0.00010153288973f,0.00006774280828f,-0.00003710586183f,-0.00000437614386f,
0.00000724124829f,-0.00000101199401f,-0.00000068470796f,0.00000026339242f,
0.00000000020143f,-0.00000001814843f,0.00000000405613f,-0.00000000029988f};

static TWavereal dbc21[42]=
{0.00054882250986f,0.00777663905246f,0.04924777153883f,0.18135962544278f,
0.41968794494492f,0.60150609494296f,0.44459045193348f,-0.03572291961772f,
-0.33566408953492f,-0.11239707156980f,0.21156452768396f,0.11523329844160f,
-0.13994042493413f,-0.08177594298219f,0.09660039032382f,0.04572340574753f,
-0.06497750489781f,-0.01865385920593f,0.03972683542509f,0.00335775638782f,
-0.02089205367997f,0.00240347091984f,0.00898882438159f,-0.00289133434884f,
-0.00295837403905f,0.00171660704064f,0.00063941850053f,-0.00069067111708f,
-0.00003196406277f,0.00019366465042f,-0.00003635520250f,-0.00003499665985f,
0.00001535482509f,0.00000279033054f,-0.00000309001716f,0.00000031660954f,
0.00000029921366f,-0.00000010004009f,-0.00000000225401f,0.00000000705803f,
-0.00000000147195f,0.00000000010388f};

static TWavereal dbc22[44]=
{0.00038626323150f,0.00572185463145f,0.03806993723721f,0.14836754089323f,
0.36772868345377f,0.57843273102169f,0.50790109063283f,0.07372450118513f,
-0.31272658043501f,-0.20056840610944f,0.16409318810947f,0.17997318799515f,
-0.09711079841387f,-0.13176813769363f,0.06807631438861f,0.08455737636227f,
-0.05136425430463f,-0.04653081183330f,0.03697084661864f,0.02058670762720f,
-0.02348000134426f,-0.00621378284801f,0.01256472522016f,0.00030013739972f,
-0.00545569198552f,0.00104426073960f,0.00182701049587f,-0.00077069098807f,
-0.00042378739982f,0.00032860941423f,0.00004345899905f,-0.00009405223635f,
0.00001137434966f,0.00001737375696f,-0.00000616672932f,-0.00000156517913f,
0.00000129518206f,-0.00000008779880f,-0.00000012833362f,0.00000003761229f,
0.00000000168017f,-0.00000000272962f,0.00000000053359f,-0.00000000003602f};

static TWavereal dbc23[46]=
{0.00027190419416f,0.00420274889370f,0.02931000366146f,0.12051553179868f,
0.31845081389173f,0.54493114794003f,0.55101851730917f,0.18139262538597f,
-0.26139214806257f,-0.27140209864102f,0.09212540709353f,0.22357365826899f,
-0.03303744709916f,-0.16401132155390f,0.02028307457378f,0.11229704362359f,
-0.02112621237227f,-0.07020739160254f,0.02176585681370f,0.03849533250212f,
-0.01852351367601f,-0.01753710102460f,0.01275194391902f,0.00603184064178f,
-0.00707531927963f,-0.00113486547603f,0.00312287644907f,-0.00024650140100f,
-0.00106123122919f,0.00031942049269f,0.00025676245202f,-0.00015002185037f,
-0.00003378894835f,0.00004426071204f,-0.00000263520789f,-0.00000834787557f,
0.00000239756955f,0.00000081475748f,-0.00000053390054f,0.00000001853092f,
0.00000005417549f,-0.00000001399935f,-0.00000000094729f,0.00000000105045f,
-0.00000000019324f,0.00000000001250f};

static TWavereal dbc24[48]=
{0.00019143580095f,0.00308208171500f,0.02248233995038f,0.09726223583651f,
0.27290891607582f,0.50437104085489f,0.57493922111260f,0.28098555324203f,
-0.18727140689076f,-0.31794307900890f,0.00477661368430f,0.23923738878710f,
0.04252872964227f,-0.17117535137613f,-0.03877717358004f,0.12101630347157f,
0.02098011370824f,-0.08216165421234f,-0.00457843624443f,0.05130162003823f,
-0.00494470943241f,-0.02821310710056f,0.00766172187681f,0.01304997086673f,
-0.00629143537412f,-0.00474656878930f,0.00373604617663f,0.00115376493595f,
-0.00169645681942f,-0.00004416184869f,0.00058612705931f,-0.00011812332380f,
-0.00014600798177f,0.00006559388640f,0.00002183241461f,-0.00002022888293f,
0.00000001341158f,0.00000390110034f,-0.00000089802531f,-0.00000040325078f,
0.00000021663397f,-0.00000000050576f,-0.00000002255740f,0.00000000515778f,
0.00000000047484f,-0.00000000040247f,0.00000000006992f,-0.00000000000434f};

static TWavereal dbc25[50]=
{0.00013480297936f,0.00225695959203f,0.01718674125537f,0.07803586287819f,
0.23169350790401f,0.45968341518179f,0.58163689679121f,0.36788507483148f,
-0.09717464097229f,-0.33647307966812f,-0.08758761459496f,0.22453781976164f,
0.11815528672764f,-0.15056021376482f,-0.09850861530222f,0.10663380501832f,
0.06675216448493f,-0.07708411108361f,-0.03717396289023f,0.05361790937603f,
0.01554260590837f,-0.03404232047610f,-0.00307983679799f,0.01892280448261f,
-0.00198942577434f,-0.00886070261061f,0.00272693626530f,0.00332270777835f,
-0.00184248428806f,-0.00089997742272f,0.00087725819420f,0.00011532124422f,
-0.00030988009907f,0.00003543714525f,0.00007904640005f,-0.00002733048120f,
-0.00001277195293f,0.00000899066139f,0.00000052328277f,-0.00000177920133f,
0.00000032120375f,0.00000019228068f,-0.00000008656942f,-0.00000000261160f,
0.00000000927922f,-0.00000000188042f,-0.00000000022285f,0.00000000015359f,
-0.00000000002528f,0.00000000000151f};

static TWavereal dbc26[52]=
{0.00009493795747f,0.00165052023287f,0.01309755428729f,0.06227474400009f,
0.19503943863827f,0.41329296211202f,0.57366904280335f,0.43915831161244f,
0.00177407678034f,-0.32638459356024f,-0.17483996121861f,0.18129183223897f,
0.18275540951738f,-0.10432390024244f,-0.14797719321441f,0.06982318608594f,
0.10648240520785f,-0.05344856165621f,-0.06865475956471f,0.04223218580538f,
0.03853571600107f,-0.03137811028460f,-0.01776090348004f,0.02073492025806f,
0.00582958063302f,-0.01178549783685f,-0.00052873835369f,0.00560194726473f,
-0.00093905823572f,-0.00214553027435f,0.00083834880766f,0.00061613822092f,
-0.00043195570707f,-0.00010605747474f,0.00015747952381f,-0.00000527779549f,
-0.00004109673995f,0.00001074221541f,0.00000700007868f,-0.00000388740016f,
-0.00000046504632f,0.00000079392106f,-0.00000010790042f,-0.00000008904466f,
0.00000003407796f,0.00000000216933f,-0.00000000377601f,0.00000000067800f,
0.00000000010023f,-0.00000000005840f,0.00000000000913f,-0.00000000000053f};

static TWavereal dbc27[54]=
{0.00006687131379f,0.00120553123053f,0.00995258877145f,0.04945259993605f,
0.16292202734804f,0.36711021377760f,0.55384986046579f,0.49340612221061f,
0.10284085496457f,-0.28971680303965f,-0.24826458166690f,0.11482301941169f,
0.22727328820471f,-0.03878641858319f,-0.17803174076834f,0.01579939748221f,
0.13119797164867f,-0.01406275146647f,-0.09102290634917f,0.01731101835678f,
0.05796940579574f,-0.01851249342470f,-0.03273906647991f,0.01614696702403f,
0.01566559574354f,-0.01157718635089f,-0.00586209625930f,0.00685663566511f,
0.00134262691970f,-0.00333285443828f,0.00014575297882f,0.00130117745760f,
-0.00034183511836f,-0.00038790185541f,0.00020197198834f,0.00007660058395f,
-0.00007711145508f,-0.00000351748362f,0.00002063442645f,-0.00000390116407f,
-0.00000365750091f,0.00000163436962f,0.00000030508807f,-0.00000034724681f,
0.00000003286559f,0.00000004026255f,-0.00000001321332f,-0.00000000130947f,
0.00000000152161f,-0.00000000024155f,-0.00000000004375f,0.00000000002214f,
-0.00000000000330f,0.00000000000018f};

static TWavereal dbc28[56]=
{0.00004710807766f,0.00087949851431f,0.00754265036328f,0.03909260804095f,
0.13513791399624f,0.32256336067113f,0.52499823063037f,0.53051629243100f,
0.20017614366470f,-0.23049895360849f,-0.30132780895814f,0.03285787910353f,
0.24580815091531f,0.03690688527328f,-0.18287733031840f,-0.04683823352168f,
0.13462756788564f,0.03447863155804f,-0.09768535516323f,-0.01734192227806f,
0.06774789588669f,0.00344801938223f,-0.04333336823364f,0.00443173305187f,
0.02468805998294f,-0.00681554982076f,-0.01206359205683f,0.00583881650115f,
0.00478486300787f,-0.00372546130632f,-0.00136037388200f,0.00187599864580f,
0.00014156723219f,-0.00074867495568f,0.00011546560683f,0.00022957909867f,
-0.00008903901415f,-0.00004907713377f,0.00003641401216f,0.00000463866501f,
-0.00001004326038f,0.00000124790032f,0.00000184036373f,-0.00000066702155f,
-0.00000017574612f,0.00000014906600f,-0.00000000826239f,-0.00000001784139f,
0.00000000504405f,0.00000000069445f,-0.00000000060770f,0.00000000008492f,
0.00000000001867f,-0.00000000000837f,0.00000000000119f,-0.00000000000006f};

static TWavereal dbc29[58]=
{0.00003318966297f,0.00064095168358f,0.00570212654694f,0.03077358037883f,
0.11137011752144f,0.28065345740663f,0.48975880726750f,0.55137443557886f,
0.28910523981468f,-0.15402873524802f,-0.33004095060681f,-0.05570680036129f,
0.23610523735052f,0.11241917542149f,-0.16087798947795f,-0.10784595061226f,
0.11447229626215f,0.08322074724110f,-0.08512549355142f,-0.05502749046173f,
0.06347916412676f,0.03053154257401f,-0.04518798236422f,-0.01291714340149f,
0.02947043137455f,0.00264832683582f,-0.01704122498871f,0.00173788013922f,
0.00846972541737f,-0.00255080721472f,-0.00347379905891f,0.00187712089643f,
0.00108705391903f,-0.00100077835149f,-0.00020007114870f,0.00041112834174f,
-0.00002292018316f,-0.00012930448572f,0.00003645026049f,0.00002913344752f,
-0.00001657328408f,-0.00000359364483f,0.00000475060927f,-0.00000030290546f,
-0.00000089757018f,0.00000026338984f,0.00000009387197f,-0.00000006286157f,
0.00000000107659f,0.00000000776898f,-0.00000000189400f,-0.00000000034268f,
0.00000000024071f,-0.00000000002941f,-0.00000000000783f,0.00000000000315f,
-0.00000000000043f,0.00000000000002f};

static TWavereal dbc30[60]=
{0.00002338616182f,0.00046663795235f,0.00430079718272f,0.02413083277074f,
0.09123830444189f,0.24202067193463f,0.45048782370427f,0.55757223520372f,
0.36624268487617f,-0.06618367104886f,-0.33296697639194f,-0.14196851392136f,
0.19946212238116f,0.17782987393397f,-0.11455821998655f,-0.15723681875947f,
0.07277865900869f,0.12274774614278f,-0.05380646625820f,-0.08765869114446f,
0.04380166398048f,0.05671236507154f,-0.03567339847522f,-0.03226375971045f,
0.02707861927863f,0.01528796063552f,-0.01839974396002f,-0.00529685959906f,
0.01091563182436f,0.00061967186322f,-0.00553073010417f,0.00084338462127f,
0.00232452011131f,-0.00086092770350f,-0.00076787825930f,0.00050509482141f,
0.00017248258226f,-0.00021617183228f,-0.00000854830600f,0.00006982008384f,
-0.00001339716873f,-0.00001636152487f,0.00000725214556f,0.00000232754911f,
-0.00000218726769f,0.00000001099474f,0.00000042616623f,-0.00000010004147f,
-0.00000004764380f,0.00000002605443f,0.00000000055534f,-0.00000000333111f,
0.00000000069849f,0.00000000016136f,-0.00000000009461f,0.00000000001000f,
0.00000000000324f,-0.00000000000119f,0.00000000000015f,-0.00000000000001f};

static TWavereal symc2[4]=
{0.48296291314469f,0.83651630373747f,0.22414386804186f,-0.12940952255092f};

static TWavereal symc3[6]=
{0.33267055295096f,0.80689150931334f,0.45987750211933f,-0.13501102001039f,
-0.08544127388224f,0.03522629188210f};

static TWavereal symc4[8]=
{0.03222310060404f,-0.01260396726204f,-0.09921954357685f,0.29785779560528f,
0.80373875180592f,0.49761866763202f,-0.02963552764600f,-0.07576571478927f};

static TWavereal symc5[10]=
{0.01953888273529f,-0.02110183402476f,-0.17532808990845f,0.01660210576452f,
0.63397896345821f,0.72340769040242f,0.19939753397739f,-0.03913424930238f,
0.02951949092577f,0.02733306834508f};

static TWavereal symc6[12]=
{-0.00780070832503f,0.00176771186424f,0.04472490177067f,-0.02106029251230f,
-0.07263752278646f,0.33792942172762f,0.78764114103019f,0.49105594192675f,
-0.04831174258563f,-0.11799011114819f,0.00349071208422f,0.01540410932703f};

static TWavereal symc7[14]=
{0.01026817670851f,0.00401024487153f,-0.10780823770382f,-0.14004724044296f,
0.28862963175151f,0.76776431700316f,0.53610191709176f,0.01744125508686f,
-0.04955283493713f,0.06789269350137f,0.03051551316596f,-0.01263630340325f,
-0.00104738488868f,0.00268181456826f};

static TWavereal symc8[16]=
{0.00188995033276f,-0.00030292051472f,-0.01495225833705f,0.00380875201389f,
0.04913717967361f,-0.02721902991706f,-0.05194583810771f,0.36444189483533f,
0.77718575170052f,0.48135965125837f,-0.06127335906766f,-0.14329423835081f,
0.00760748732492f,0.03169508781149f,-0.00054213233179f,-0.00338241595101f};

static TWavereal symc9[18]=
{0.00106949003291f,-0.00047315449868f,-0.01026406402763f,0.00885926749340f,
0.06207778930289f,-0.01823377077940f,-0.19155083129729f,0.03527248803528f,
0.61733844914095f,0.71789708276441f,0.23876091460730f,-0.05456895843084f,
0.00058346274613f,0.03022487885828f,-0.01152821020768f,-0.01327196778182f,
0.00061978088899f,0.00140091552591f};

static TWavereal symc10[20]=
{-0.00045932942100f,0.00005703608362f,0.00459317358531f,-0.00080435893202f,
-0.02035493981231f,0.00576491203358f,0.04999497207738f,-0.03199005688243f,
-0.03553674047382f,0.38382676106708f,0.76951003702110f,0.47169066693844f,
-0.07088053578324f,-0.15949427888492f,0.01160989390371f,0.04592723923109f,
-0.00146538258130f,-0.00864129927702f,0.00009563267072f,0.00077015980911f};

static TWavereal symc11[22]=
{0.00048926361026f,0.00011053509764f,-0.00638960366645f,-0.00200347190011f,
0.04300019068155f,0.03526675956446f,-0.14460234370532f,-0.20465479449578f,
0.23768990904928f,0.73034354908840f,0.57202297801007f,0.09719839445889f,
-0.02283265102257f,0.06997679961073f,0.03703741597886f,-0.02408084159587f,
-0.00985793482879f,0.00651249567477f,0.00058835273540f,-0.00173436626730f,
-0.00003879565574f,0.00017172195070f};

static TWavereal symc12[24]=
{-0.00017906658698f,-0.00001815807886f,0.00235029761418f,0.00030764779631f,
-0.01458983644923f,-0.00260439103133f,0.05780417944551f,0.01530174062248f,
-0.17037069723887f,-0.07833262231632f,0.46274103121933f,0.76347909778368f,
0.39888597239018f,-0.02216230617039f,-0.03584883073697f,0.04917931829966f,
0.00755378061168f,-0.02422072267502f,-0.00140890924433f,0.00741496551766f,
0.00018021409009f,-0.00134975575557f,-0.00001135392804f,0.00011196719425f};

static TWavereal symc13[26]=
{0.00007042986691f,0.00003690537342f,-0.00072136438514f,0.00041326119884f,
0.00567485376012f,-0.00149244727426f,-0.02074968632552f,0.01761829688065f,
0.09292603089915f,0.00881975767043f,-0.14049009311369f,0.11023022302128f,
0.64456438390117f,0.69573915056158f,0.19770481877127f,-0.12436246075151f,
-0.05975062771796f,0.01386249743584f,-0.01721164272631f,-0.02021676813340f,
0.00529635973872f,0.00752622538997f,-0.00017094285853f,-0.00113606343893f,
-0.00003573862365f,0.00006820325263f};

static TWavereal symc14[28]=
{0.00004461897799f,0.00001932901697f,-0.00060576018247f,-0.00007321421357f,
0.00453267747195f,0.00101314198718f,-0.01943931426363f,-0.00236504883674f,
0.06982761636183f,0.02589858753105f,-0.15999741114654f,-0.05811182331763f,
0.47533576263445f,0.75997624196128f,0.39320152196202f,-0.03531811211520f,
-0.05763449835147f,0.03743308836280f,0.00428052049898f,-0.02919621776406f,
-0.00275377479123f,0.01003769371768f,0.00036647657366f,-0.00257944172593f,
-0.00006286542481f,0.00039843567298f,0.00001121086581f,-0.00002587909027f};

static TWavereal symc15[30]=
{0.00002866070853f,0.00002171789015f,-0.00040216853760f,-0.00010815440169f,
0.00348102873707f,0.00152613827819f,-0.01717125278165f,-0.00874478888650f,
0.06796982904489f,0.06839331006054f,-0.13405629845629f,-0.19662635876643f,
0.24396270543204f,0.72184302963632f,0.57864041521527f,0.11153369514269f,
-0.04108266663544f,0.04073547969677f,0.02193764271975f,-0.03887671687685f,
-0.01940501143095f,0.01007997708790f,0.00342345073635f,-0.00359016544737f,
-0.00026731644647f,0.00107056721946f,0.00005512254786f,-0.00016066186637f,
-0.00000735966680f,0.00000971241974f};

static TWavereal symc16[32]=
{-0.00001079798210f,-0.00000539648318f,0.00016545679579f,0.00003656592483f,
-0.00133872060669f,-0.00022211647621f,0.00693776113081f,0.00135984474247f,
-0.02495275804631f,-0.00351027506830f,0.07803785290360f,0.03072113906330f,
-0.15959219218533f,-0.05404060138707f,0.47534280601285f,0.75652498787649f,
0.39712293361998f,-0.03457422841817f,-0.06698304907080f,0.03233309161055f,
0.00486927440478f,-0.03105120284367f,-0.00312651717226f,0.01266673165989f,
0.00071821197882f,-0.00388091225262f,-0.00010844562231f,0.00085235471081f,
0.00002807858213f,-0.00010943147930f,-0.00000311355641f,0.00000623000670f};

static TWavereal symc17[34]=
{0.00000379125319f,-0.00000245271634f,-0.00007607124406f,0.00002520793314f,
0.00071982706421f,0.00005840042870f,-0.00393232527979f,-0.00190540768987f,
0.01239698836660f,0.00995298252353f,-0.01803889724182f,-0.00726163475091f,
0.01615880872602f,-0.08607087472032f,-0.15507600534989f,0.18053958457921f,
0.68148899534246f,0.65071662920429f,0.14239835041670f,-0.11856693260976f,
0.01727117821070f,0.10475461484209f,0.01790395221460f,-0.03329138349213f,
-0.00481921280320f,0.01048236693298f,0.00085677007020f,-0.00274167597567f,
-0.00013864230268f,0.00047599638026f,-0.00001350638340f,-0.00006293702598f,
0.00000278012669f,0.00000429734333f};

static TWavereal symc18[36]=
{-0.00000151315307f,0.00000078472981f,0.00002955743762f,-0.00000985881603f,
-0.00026583011024f,0.00004741614518f,0.00142808632708f,-0.00018877623940f,
-0.00523978968302f,0.00108778478960f,0.01501235634429f,-0.00326074419997f,
-0.03171268473169f,0.00627794455441f,0.02852959703912f,-0.07379920729075f,
-0.03248057329092f,0.40148386056943f,0.75362914010133f,0.47396905989475f,
-0.05202915898285f,-0.15993814866901f,0.03399566710369f,0.08421992997028f,
-0.00507708516062f,-0.03032509108928f,0.00164298639727f,0.00950216439096f,
-0.00041152110922f,-0.00231387181450f,0.00007021273459f,0.00039616840638f,
-0.00001402099258f,-0.00004524675787f,0.00000135491576f,0.00000261261256f};

static TWavereal symc19[38]=
{0.00000175093680f,0.00000206231706f,-0.00002815113866f,-0.00001682138703f,
0.00027621877686f,0.00012930767651f,-0.00170496026116f,-0.00061792232780f,
0.00826223695551f,0.00431935187495f,-0.02770989693110f,-0.01690823486119f,
0.08407267627915f,0.09363084341623f,-0.11624173010592f,-0.17659686625066f,
0.25826616923642f,0.71955552571378f,0.57814494533691f,0.10902582508132f,
-0.06752505803991f,0.00895459117312f,0.00701557385747f,-0.04663598353443f,
-0.02265199337798f,0.01579743929571f,0.00796843832065f,-0.00512220500254f,
-0.00116070325720f,0.00212142502817f,0.00015915804768f,-0.00063576451500f,
-0.00004612039600f,0.00011553923334f,0.00000887331217f,-0.00001188051827f,
-0.00000064636513f,0.00000054877328f};

static TWavereal symc20[40]=
{-0.00000063291290f,-0.00000032567026f,0.00001228725278f,0.00000452542221f,
-0.00011739133516f,-0.00002661555034f,0.00074761085974f,0.00012544091727f,
-0.00347164780267f,-0.00061112638609f,0.01215704094790f,0.00193859706772f,
-0.03537333675507f,-0.00684370196894f,0.08891966801896f,0.03625095165273f,
-0.16057829841234f,-0.05108834294808f,0.47199147504138f,0.75116272838989f,
0.40583144438308f,-0.02981936882107f,-0.07899434489912f,0.02557934951284f,
0.00812322835892f,-0.03162943714139f,-0.00331385738520f,0.01700404902119f,
0.00142308736006f,-0.00660658579824f,-0.00030526283204f,0.00208899470791f,
0.00007215991195f,-0.00049473109149f,-0.00001928412302f,0.00007992967834f,
0.00000302566606f,-0.00000791936141f,-0.00000019015676f,0.00000036955375f};

static TWavereal symc21[42]=
{0.00000023116904f,-0.00000007401089f,-0.00000516158836f,0.00000183899845f,
0.00005820786308f,-0.00001055398996f,-0.00041349561806f,-0.00002060745324f,
0.00203118441578f,0.00069591568201f,-0.00674898277369f,-0.00409543219752f,
0.01450786941750f,0.01118865626885f,-0.01508147033057f,0.00625464069426f,
0.02791728151204f,-0.08709884432141f,-0.15131078012891f,0.19202706524796f,
0.68158332059527f,0.64618599743615f,0.14412386119274f,-0.12356548353363f,
0.00736738941236f,0.10148310770052f,0.01067013591536f,-0.04716326398300f,
-0.00899202924623f,0.01540083464058f,0.00176596179226f,-0.00535395747976f,
-0.00043315590952f,0.00142132044885f,0.00006208657527f,-0.00028647517579f,
0.00000607913038f,0.00004694778085f,-0.00000183116834f,-0.00000509819139f,
0.00000007895915f,0.00000024662467f};

static TWavereal symc22[44]=
{0.00000015701037f,0.00000009966118f,-0.00000328417896f,-0.00000146277694f,
0.00003442102521f,0.00001076285381f,-0.00023615708448f,-0.00004790058918f,
0.00120819750454f,0.00021700733081f,-0.00470892831539f,-0.00077852943445f,
0.01485841354863f,0.00255497233268f,-0.03922962637142f,-0.00752552739132f,
0.09413257032833f,0.04132666895742f,-0.15420831552203f,-0.04123051452708f,
0.47683319799820f,0.74899293929327f,0.40287666044285f,-0.03659053895049f,
-0.09061187088512f,0.01915428943071f,0.00842098867472f,-0.03179026919182f,
-0.00355937471201f,0.01864608663048f,0.00168314925131f,-0.00800078674386f,
-0.00046737262697f,0.00282051712122f,0.00011079462032f,-0.00079412754687f,
-0.00003361349829f,0.00016465262503f,0.00000770422674f,-0.00002357636865f,
-0.00000098649840f,0.00000210708665f,0.00000005624840f,-0.00000008861606f};

static TWavereal symc23[46]=
{0.00000010235430f,0.00000011947301f,-0.00000207996803f,-0.00000168882731f,
0.00002269111797f,0.00001337545480f,-0.00016515274988f,-0.00006891398065f,
0.00092065028998f,0.00035751068028f,-0.00393795248714f,-0.00159865021268f,
0.01387834485221f,0.00751868829733f,-0.03854919903172f,-0.02759831960490f,
0.09194189389449f,0.10791667041303f,-0.11151590218887f,-0.17895622157283f,
0.24859349726852f,0.70931934236184f,0.58652666181596f,0.12546897118256f,
-0.07028820351936f,-0.00454376049568f,0.00255211302562f,-0.04643623117797f,
-0.02186836373024f,0.02077476122165f,0.01143485977922f,-0.00717111121596f,
-0.00281604932182f,0.00304595670399f,0.00045268316044f,-0.00123284622195f,
-0.00009789651829f,0.00036373350955f,0.00002965227285f,-0.00007386036564f,
-0.00000627559386f,0.00001006623708f,0.00000074523049f,-0.00000084388462f,
-0.00000003876629f,0.00000003321165f};

static TWavereal symc24[48]=
{-0.00000003763894f,-0.00000001379902f,0.00000092122723f,0.00000035313033f,
-0.00001083968061f,-0.00000471080885f,0.00007954430272f,0.00003554828409f,
-0.00041089637963f,-0.00015315078955f,0.00165852411624f,0.00036533725724f,
-0.00578932461719f,-0.00070874601122f,0.01791452935815f,0.00422746501837f,
-0.04281324592714f,-0.01507710368464f,0.08102456049784f,0.02392107501492f,
-0.16088779689114f,-0.02988259975726f,0.48880974855408f,0.74688385743468f,
0.39288115166264f,-0.04379342297629f,-0.08777599016841f,0.03444149388902f,
0.02574605129641f,-0.02426279125326f,-0.00322429774344f,0.01824651181612f,
0.00027829218166f,-0.01009299895819f,-0.00061288026541f,0.00390135636880f,
0.00032248385033f,-0.00117205334361f,-0.00010277190304f,0.00027429214178f,
0.00002161714042f,-0.00004875059458f,-0.00000276094813f,0.00000635141112f,
0.00000020725965f,-0.00000054069132f,-0.00000000809775f,0.00000002208787f};

static TWavereal symc25[50]=
{0.00000001417393f,-0.00000000128584f,-0.00000035883307f,0.00000008450483f,
0.00000460200134f,-0.00000106655594f,-0.00003862052166f,0.00000525387369f,
0.00023387577301f,0.00000581099069f,-0.00106357085882f,-0.00024665256419f,
0.00363827754098f,0.00168360713385f,-0.00899375078539f,-0.00591958921067f,
0.01498023419939f,0.00993789458552f,-0.01340322915072f,0.01798969208769f,
0.03862447178667f,-0.08574203560471f,-0.14658183869341f,0.20129994479568f,
0.68175692878985f,0.64245780610168f,0.14440656141754f,-0.12888353966089f,
-0.00288020261395f,0.09620356820102f,0.00454479703964f,-0.05697322565402f,
-0.01086875280482f,0.02115133223651f,0.00336812528826f,-0.00801783983806f,
-0.00080537486804f,0.00276454631473f,0.00021102111165f,-0.00074974673235f,
-0.00002424720226f,0.00016847624768f,-0.00000317175456f,-0.00003152810174f,
0.00000107502980f,0.00000434483509f,-0.00000008618136f,-0.00000036987182f,
0.00000000130255f,0.00000001435812f};

static TWavereal symc26[52]=
{-0.00000000543571f,0.00000000199024f,0.00000014430002f,-0.00000005275976f,
-0.00000183707240f,0.00000073688296f,0.00001516517917f,-0.00000654194941f,
-0.00009206773058f,0.00003757555029f,0.00043268934169f,-0.00014414125172f,
-0.00160482533375f,0.00038470529620f,0.00477959384708f,-0.00058695506598f,
-0.01115011462549f,0.00028029270803f,0.01851220018216f,-0.00454082260968f,
-0.02417683712649f,0.02788593725265f,0.03357868590107f,-0.08973261009127f,
-0.04066610256625f,0.39654996642049f,0.74534691300998f,0.48659675911554f,
-0.03054816636870f,-0.16263026270583f,0.02381623987822f,0.08335972926050f,
-0.01571336409339f,-0.04542223587036f,0.00529771387456f,0.02060700942608f,
-0.00097581041791f,-0.00728998611856f,0.00040607789503f,0.00226218548420f,
-0.00019898334754f,-0.00062562025657f,0.00005915042437f,0.00014332547319f,
-0.00001083563455f,-0.00002507873243f,0.00000124228948f,0.00000309673285f,
-0.00000008854202f,-0.00000024216780f,0.00000000335850f,0.00000000917271f};

static TWavereal symc27[54]=
{0.00000000200486f,-0.00000000225655f,-0.00000005780336f,0.00000005816294f,
0.00000081043393f,-0.00000067142671f,-0.00000724188402f,0.00000454696437f,
0.00004551014829f,-0.00001987214817f,-0.00020932941145f,0.00006267580812f,
0.00071471422728f,-0.00020855313323f,-0.00183995581592f,0.00103837743414f,
0.00396141302209f,-0.00484585447809f,-0.00946085230775f,0.01431280731090f,
0.02593596176648f,-0.01789276436445f,-0.04191593809368f,0.00091947692675f,
-0.01754596460237f,-0.07886544762866f,0.13063831337891f,0.58946164295955f,
0.70449404469039f,0.24869269195981f,-0.17335255579376f,-0.10550196328364f,
0.11576172687488f,0.09374636823657f,-0.03849177869134f,-0.04783974419199f,
0.01091220407678f,0.01925636749894f,-0.00314457482910f,-0.00679065270580f,
0.00076187111254f,0.00197699552151f,-0.00018852424968f,-0.00048322234864f,
0.00004468020830f,0.00009726406937f,-0.00000899977529f,-0.00001546107195f,
0.00000144610528f,0.00000186359765f,-0.00000015046913f,-0.00000015232407f,
0.00000000686339f,0.00000000609786f};

static TWavereal symc28[56]=
{-0.00000000223841f,-0.00000000080814f,0.00000006348994f,0.00000002240654f,
-0.00000087514214f,-0.00000032744949f,0.00000772104424f,0.00000313803239f,
-0.00004848031767f,-0.00002021976593f,0.00023114897537f,0.00008673264856f,
-0.00088921450226f,-0.00024089432929f,0.00295035213651f,0.00045574888521f,
-0.00885635272453f,-0.00132060610611f,0.02310526980043f,0.00629724042357f,
-0.04771096755582f,-0.01621457161075f,0.08536229609472f,0.02357730093902f,
-0.16437040480472f,-0.03154320812556f,0.48424408416030f,0.74397532266483f,
0.40014593426660f,-0.03744630472127f,-0.09120194632275f,0.03285695485769f,
0.02986054897631f,-0.02404713054345f,-0.00585973849229f,0.01865510958775f,
0.00038509113319f,-0.01202490038160f,-0.00054004768399f,0.00563725023110f,
0.00043338521493f,-0.00208037206914f,-0.00018786535509f,0.00062860489607f,
0.00005764318298f,-0.00015428555363f,-0.00001257590187f,0.00003035437524f,
0.00000189746857f,-0.00000466642977f,-0.00000019675201f,0.00000052609490f,
0.00000001351981f,-0.00000003830230f,-0.00000000048383f,0.00000000134012f};

static TWavereal symc29[58]=
{0.00000000086914f,0.00000000007683f,-0.00000002476128f,0.00000000304434f,
0.00000035944572f,-0.00000006997480f,-0.00000343511732f,0.00000067174032f,
0.00002415810963f,-0.00000310632315f,-0.00013140817964f,0.00000160162253f,
0.00056818760343f,0.00008532968392f,-0.00195185738910f,-0.00065489520898f,
0.00527183982333f,0.00284145407341f,-0.01048311108995f,-0.00699646454543f,
0.01478801128217f,0.00757358653480f,-0.01212866901975f,0.02896370174289f,
0.04899578905306f,-0.08385363336444f,-0.14426113167429f,0.20571029834063f,
0.68048314526649f,0.64077273046963f,0.14693981020727f,-0.13193541112313f,
-0.01228374764213f,0.08980937772282f,-0.00093576808478f,-0.06412063880974f,
-0.01161867252201f,0.02656533167184f,0.00487002331131f,-0.01083258821344f,
-0.00136198949647f,0.00428940824406f,0.00040722859294f,-0.00143251730877f,
-0.00009078820672f,0.00040339823174f,0.00000745768225f,-0.00009793537610f,
0.00000196559708f,0.00002001819326f,-0.00000066704682f,-0.00000321133820f,
0.00000007745993f,0.00000036644309f,-0.00000000281205f,-0.00000002591084f,
-0.00000000007491f,0.00000000084744f};

static TWavereal symc30[60]=
{0.00000000055439f,0.00000000025363f,-0.00000001650488f,-0.00000000612778f,
0.00000024412962f,0.00000008995017f,-0.00000232354978f,-0.00000089828469f,
0.00001589700483f,0.00000647382806f,-0.00008272690614f,-0.00003293176436f,
0.00034385221446f,0.00011735869759f,-0.00119692134911f,-0.00027628415438f,
0.00371380699054f,0.00054379852399f,-0.01038876691564f,-0.00162932203336f,
0.02556854601492f,0.00760939671239f,-0.04889669601845f,-0.01523693636380f,
0.08910160894494f,0.02619852893355f,-0.16204680547674f,-0.02843781124261f,
0.48469802756342f,0.74269377583417f,0.40072254149852f,-0.03849152799019f,
-0.09630227409198f,0.02927099877092f,0.02965858799887f,-0.02521794463036f,
-0.00795200551976f,0.01829724962657f,0.00037212410631f,-0.01284118848030f,
-0.00051919347319f,0.00645416697646f,0.00046642596970f,-0.00258964861453f,
-0.00023156691354f,0.00086145323605f,0.00008209441595f,-0.00023724380919f,
-0.00002120204181f,0.00005384704875f,0.00000402586750f,-0.00000989667625f,
-0.00000055432800f,0.00000142300528f,0.00000005465707f,-0.00000014986092f,
-0.00000000380480f,0.00000001014810f,0.00000000014934f,-0.00000000032641f};


void CDaubechiDWT::Decompose(int level,int layer)
{
	// Does one step of the Daubechies decomposition transform.
	//

	int jc= (int)m_WS.GetCount() >> (level+1);
	int coeff2= m_nCoeffs >> 1;
	int jc2= jc << 1;
	int i,j,j1,l1,i2,i21;
	int sign;
	TWavereal a,d;

	TWavereal *pData;

	TWavereal *pData1, *pData2; 	
	TWavereal *pHcoeff;		// pointer to filter coefficient
	int lst= 1 << level;

	int offset = GetWaveletLayerNumber(level,layer);
	pData = m_WS.GetData(offset);

	std::vector<TWavereal> approx(jc);
	std::vector<TWavereal> detail(jc);

	// left edge of data array

	for(i = 0; i < coeff2; i++) 
	{
		i2 = (i << 1) + coeff2;
		i21 = (i << 1) - coeff2 + 1;
		a = 0.0f;
		d = 0.0f;

		for(j = 0; j < (int)m_nCoeffs; j++) 
		{
			j1=i21+j;
			l1=i2-j;

			if(j1<0) j1+=jc2;
			if(l1<0) l1+=jc2;
			if(j1>=jc2) j1-=jc2;
			if(l1>=jc2) l1-=jc2;


			sign=(j&1)==0?-1:1;
//			assert((j1<<level) < m_WS.GetCount());
			a+=m_Filter[j]*pData[j1<<level];
//			assert((l1<<level) < m_WS.GetCount());
			d+=sign*m_Filter[j]*pData[l1<<level];
		}
		approx[i]=a;
		detail[i]=d;
	}

	// processing data in the middle of array
	for(i=coeff2;i<jc-coeff2;i++)
	{
		i2=(i<<1)+coeff2;
		i21=(i<<1)-coeff2+1;
		a=0.;
		d=0.;
//		assert((i21<<level) < m_WS.GetCount());
		pData1=pData + (i21<<level);
//		assert((i2<<level) < m_WS.GetCount());
		pData2=pData + (i2<<level);
		pHcoeff = m_Filter;

		for(j = 0; j < coeff2; j++) 
		{
			a += *pHcoeff*(*pData1);
			pData1 += lst;
			d -= *pHcoeff*(*pData2);
			pData2 -= lst;
			pHcoeff++;
			a += *pHcoeff*(*pData1);
			pData1 += lst;
			d += *pHcoeff*(*pData2);
			pData2 -= lst;
			pHcoeff++;
		}
		approx[i] = a;
		detail[i] = d;
	}

	// right edge of data array
	for(i=jc-coeff2;i<jc;i++) 
	{
		i2=(i<<1)+coeff2;
		i21=(i<<1)-coeff2+1;
		a=0.;
		d=0.;

		for(j = 0; j < (int)m_nCoeffs ; j++) 
		{
			j1=i21+j;
			l1=i2-j;

			if(j1>=jc2) j1-=jc2;
			if(l1>=jc2) l1-=jc2;
			if(j1<0) j1+=jc2;
			if(l1<0) l1+=jc2;

			sign=(j&1)==0?-1:1;
//			assert((j1<<level) < m_WS.GetCount());
			a+=m_Filter[j]*pData[j1<<level];
//			assert((l1<<level) < m_WS.GetCount());
			d+=sign*m_Filter[j]*pData[l1<<level];
		}
		approx[i]=a;
		detail[i]=d;
	}
	lst = 1 << (level+1);
	TWavereal *pd;

	pData = m_WS.GetData(GetWaveletLayerNumber(level+1,layer<<1));
	pd = &approx[0];
	for(i=0;i<jc;i++,pData+=lst,pd++) 
	{
		*pData=*pd;
	}

	pData = m_WS.GetData(GetWaveletLayerNumber(level+1,(layer<<1) + 1));
	pd = &detail[0];

	for(i=0;i<jc;i++,pData+=lst,pd++) 
	{
		*pData=*pd;
	}

}

void CDaubechiDWT::Reconstruct(int level,int layer)
{
	// Does one step of the Daubechies reconstruction transform.

	int jc = (int)m_WS.GetCount() >> (level+1);
	int coeff2= m_nCoeffs >> 1;
	int jc2= jc << 1;
	int level1=level+1;
	int ja;
	int i,j,j1,j2,i1,i2,sign;

	int idaa = GetWaveletLayerNumber(level1,layer << 1);
	int idad = GetWaveletLayerNumber(level1,(layer << 1) + 1);

	TWavereal *pDataa = m_WS.GetData(idaa);
	TWavereal *pDatad = m_WS.GetData(idad);
	TWavereal *pData1, *pData2;
	TWavereal *h1, *h2;
	int lst;

	std::vector<TWavereal> s(jc2);
	TWavereal s1=0., s2=0.;

	lst=1<<level1;

	ja= (coeff2 & 1);
	sign=(coeff2 & 1)== 0 ? -1 : 1;

	// left border
	for(i = 0; i < coeff2; i++)
	{
		s1=0.;
		s2=0.;
		i1=(i + coeff2 - 1) >> 1;
		i2=(i - coeff2 + 1) >> 1;

		for(j=0; j < coeff2; j++)
		{
			j1 = i1-j;
			j2 = i2+j;

			if(j1<0)
			{
				j1+=jc;
			}
			if(j2<0) 
			{
				j2+=jc;
			}

			s1+=m_Filter[(j<<1)+!ja]*pDataa[j1 << level1];
			s2+=m_Filter[(j<<1)+ja]*pDatad[j2 << level1];
		}
		s[i]=s1+sign*s2;
		ja=!ja;
		sign=-(sign);
	}

	// middle of data array
	for(i = coeff2; i < jc2-coeff2 ;i++)
	{
		s1=0.;
		s2=0.;
		pData1=pDataa;
		pData1 += (( i + coeff2 -1) >> 1 ) << level1;
		pData2 = pDatad;
		pData2 += ((i - coeff2 + 1) >> 1) << level1;
		h1 = m_Filter+!ja;
		h2 = m_Filter+ja;

		for(j=0; j < coeff2; j++, h1 += 2, h2 += 2, pData1 -= lst, pData2 += lst)
		{
			s1 += *(h1)*(*pData1);
			s2 += *(h2)*(*pData2);
		}

		s[i] = s1 + sign*s2;
		sign =- (sign);
		ja = !ja;
	}

	// right border of data array
	for(i = jc2-coeff2; i < jc2; i++)
	{
		s1 = 0.;
		s2 = 0.;
		i1 = (i + coeff2 - 1) >> 1;
		i2 = (i - coeff2 + 1) >> 1;

		for(j = 0; j < coeff2; j++)
		{
			j1 = i1 - j;
			j2 = i2 + j;
			
			if(j1 >= jc)
			{
				j1 -= jc;
			}
			if(j2 >= jc)
			{
				j2 -= jc;
			}

			s1 += m_Filter[(j << 1)+!ja]*pDataa[j1 << level1];
			s2 += m_Filter[(j << 1)+ja]*pDatad[j2 << level1];
		}
		s[i] = s1 + sign*s2;
		ja = !ja;
		sign = -(sign);
	}

	int ida = GetWaveletLayerNumber(level, layer);
	pDataa = m_WS.GetData(ida);
	lst = 1 << level;

	for(i = 0; i < jc2; i++, pDataa+=lst)
	{
		*pDataa=s[i];
	}
	
}

// num - number of samples, ndw - type of wavelet, tree - tree partitioning, border - border type
CDaubechiDWT::CDaubechiDWT(int ndw, bool tree) : CDWT(1, tree)
{
	Init(ndw);
}

// num - number of samples, ndw - type of wavelet, tree - tree partitioning, border - border type
CDaubechiDWT::CDaubechiDWT(int num, int ndw, bool tree) : CDWT(num, tree)
{
	Init(ndw);
}

// num - number of samples, ndw - type of wavelet, tree - tree partitioning, border - border type
CDaubechiDWT::CDaubechiDWT(int num ,int ndw,bool tree,EBorderBehavior border): CDWT(num,tree,border)
{
	Init(ndw);
}

void CDaubechiDWT::Init(int ndw)
{
	switch(ndw)
	{
	case 1: m_Filter=dbc1; m_nCoeffs=2; break;
	case 2: m_Filter=dbc2; m_nCoeffs=4; break;
	case 3: m_Filter=dbc3; m_nCoeffs=6; break;
	case 4: m_Filter=dbc4; m_nCoeffs=8; break;
	case 5: m_Filter=dbc5; m_nCoeffs=10; break;
	case 6: m_Filter=dbc6; m_nCoeffs=12; break;
	case 7: m_Filter=dbc7; m_nCoeffs=14; break;
	case 8: m_Filter=dbc8; m_nCoeffs=16; break;
	case 9: m_Filter=dbc9; m_nCoeffs=18; break;
	case 10: m_Filter=dbc10; m_nCoeffs=20; break;
	case 11: m_Filter=dbc11; m_nCoeffs=22; break;
	case 12: m_Filter=dbc12; m_nCoeffs=24; break;
	case 13: m_Filter=dbc13; m_nCoeffs=26; break;
	case 14: m_Filter=dbc14; m_nCoeffs=28; break;
	case 15: m_Filter=dbc15; m_nCoeffs=30; break;
	case 16: m_Filter=dbc16; m_nCoeffs=32; break;
	case 17: m_Filter=dbc17; m_nCoeffs=34; break;
	case 18: m_Filter=dbc18; m_nCoeffs=36; break;
	case 19: m_Filter=dbc19; m_nCoeffs=38; break;
	case 20: m_Filter=dbc20; m_nCoeffs=40; break;
	case 21: m_Filter=dbc21; m_nCoeffs=42; break;
	case 22: m_Filter=dbc22; m_nCoeffs=44; break;
	case 23: m_Filter=dbc23; m_nCoeffs=46; break;
	case 24: m_Filter=dbc24; m_nCoeffs=48; break;
	case 25: m_Filter=dbc25; m_nCoeffs=50; break;
	case 26: m_Filter=dbc26; m_nCoeffs=52; break;
	case 27: m_Filter=dbc27; m_nCoeffs=54; break;
	case 28: m_Filter=dbc28; m_nCoeffs=56; break;
	case 29: m_Filter=dbc29; m_nCoeffs=58; break;
	case 30: m_Filter=dbc30; m_nCoeffs=60; break;
	case -2: m_Filter=symc2; m_nCoeffs=4; break;
	case -3: m_Filter=symc3; m_nCoeffs=6; break;
	case -4: m_Filter=symc4; m_nCoeffs=8; break;
	case -5: m_Filter=symc5; m_nCoeffs=10; break;
	case -6: m_Filter=symc6; m_nCoeffs=12; break;
	case -7: m_Filter=symc7; m_nCoeffs=14; break;
	case -8: m_Filter=symc8; m_nCoeffs=16; break;
	case -9: m_Filter=symc9; m_nCoeffs=18; break;
	case -10: m_Filter=symc10; m_nCoeffs=20; break;
	case -11: m_Filter=symc11; m_nCoeffs=22; break;
	case -12: m_Filter=symc12; m_nCoeffs=24; break;
	case -13: m_Filter=symc13; m_nCoeffs=26; break;
	case -14: m_Filter=symc14; m_nCoeffs=28; break;
	case -15: m_Filter=symc15; m_nCoeffs=30; break;
	case -16: m_Filter=symc16; m_nCoeffs=32; break;
	case -17: m_Filter=symc17; m_nCoeffs=34; break;
	case -18: m_Filter=symc18; m_nCoeffs=36; break;
	case -19: m_Filter=symc19; m_nCoeffs=38; break;
	case -20: m_Filter=symc20; m_nCoeffs=40; break;
	case -21: m_Filter=symc21; m_nCoeffs=42; break;
	case -22: m_Filter=symc22; m_nCoeffs=44; break;
	case -23: m_Filter=symc23; m_nCoeffs=46; break;
	case -24: m_Filter=symc24; m_nCoeffs=48; break;
	case -25: m_Filter=symc25; m_nCoeffs=50; break;
	case -26: m_Filter=symc26; m_nCoeffs=52; break;
	case -27: m_Filter=symc27; m_nCoeffs=54; break;
	case -28: m_Filter=symc28; m_nCoeffs=56; break;
	case -29: m_Filter=symc29; m_nCoeffs=58; break;
	case -30: m_Filter=symc30; m_nCoeffs=60; break;
	default:m_nCoeffs=4;m_Filter=dbc2;break;
	}
}

  
