#ifndef _CREWATEROCEAN_
#define _CREWATEROCEAN_

class CWater;

class CREWaterOcean : public CRendElementBase
{
public:
  CREWaterOcean();
  virtual ~CREWaterOcean();

  virtual void mfPrepare();  
  virtual bool mfDraw( CShader* ef, SShaderPass* sfm );
  virtual void mfGetPlane(Plane& pl);

  virtual void Create( uint32 nVerticesCount, SVF_P3F_C4B_T2F *pVertices, uint32 nIndicesCount, uint16 *pIndices );
  void ReleaseOcean();

  virtual Vec3 GetPositionAt( float x, float y ) const;
  virtual Vec4 *GetDisplaceGrid( ) const;

	virtual void GetMemoryUsage(ICrySizer *pSizer) const 
	{
		pSizer->AddObject(this, sizeof(*this));
	}
private:

  uint32 m_nVerticesCount;
  uint32 m_nIndicesCount;

  void *m_pVertDecl;
  void *m_pVertices;
  void *m_pIndices;

  CWater *m_pWaterSim;

private:

  void UpdateFFT();
  void FrameUpdate();

};


#endif