//////////////////////////////////////////////////////////////////////////
//
//  Crytek Engine Source File.
//  Copyright (C), Crytek Studios, 2001-2009.
// -------------------------------------------------------------------------
//  File name:   CryCreateClassInstance.h
//  Version:     v1.00
//  Created:     02/25/2009 by CarstenW
//  Description: Part of CryEngine's extension framework.
// -------------------------------------------------------------------------
//
////////////////////////////////////////////////////////////////////////////

#ifndef _CRYCREATECLASSINSTANCE_H_
#define _CRYCREATECLASSINSTANCE_H_

#pragma once


#include "ICryUnknown.h"
#include "ICryFactory.h"
#include "ICryFactoryRegistry.h"
#include "../ISystem.h"


template <class T>
bool CryCreateClassInstance(const CryClassID& cid, cryshared_ptr<T>& p)
{
	p = cryshared_ptr<T>();
	ICryFactoryRegistry* pFactoryReg = gEnv->pSystem->GetCryFactoryRegistry();
	if (pFactoryReg)
	{
		ICryFactory* pFactory = pFactoryReg->GetFactory(cid);
		if (pFactory && pFactory->ClassSupports(cryiidof<T>()))
		{
			ICryUnknownPtr pUnk = pFactory->CreateClassInstance();
			cryshared_ptr<T> pT = ::cryinterface_cast<T>(pUnk);
			assert(pT.get());
			if (pT)
				p = pT;
		}
	}
	return p;
}


template <class T>
bool CryCreateClassInstance(const char* cname, cryshared_ptr<T>& p)
{
	p = cryshared_ptr<T>();
	ICryFactoryRegistry* pFactoryReg = gEnv->pSystem->GetCryFactoryRegistry();
	if (pFactoryReg)
	{
		ICryFactory* pFactory = pFactoryReg->GetFactory(cname);
		if (pFactory && pFactory->ClassSupports(cryiidof<T>()))
		{
			ICryUnknownPtr pUnk = pFactory->CreateClassInstance();
			cryshared_ptr<T> pT = ::cryinterface_cast<T>(pUnk);
			assert(pT.get());
			if (pT)
				p = pT;
		}
	}
	return p;
}


template <class T>
bool CryCreateClassInstanceForInterface(const CryInterfaceID& iid, cryshared_ptr<T>& p)
{
	p = cryshared_ptr<T>();
	ICryFactoryRegistry* pFactoryReg = gEnv->pSystem->GetCryFactoryRegistry();
	if (pFactoryReg)
	{
		size_t numFactories = 1;
		ICryFactory* pFactory = 0;
		pFactoryReg->IterateFactories(iid, &pFactory, numFactories);
		if (numFactories == 1 && pFactory)
		{
			ICryUnknownPtr pUnk = pFactory->CreateClassInstance();
			cryshared_ptr<T> pT = ::cryinterface_cast<T>(pUnk);
			assert(pT.get());
			if (pT)
				p = pT;
		}
	}
	return p;
}


#endif // #ifndef _CRYCREATECLASSINSTANCE_H_
