////////////////////////////////////////////////////////////////////////////
//
//  Crytek Engine Source File.
//  Copyright (C), Crytek Studios, 2001-2004.
// -------------------------------------------------------------------------
//  File name:   CryMemoryManager_impl.h
//  Version:     v1.00
//  Created:     27/7/2004 by Timur.
//  Compilers:   Visual Studio.NET 2003
//  Description: Provides implementation for CryMemoryManager globally defined functions.
//               This file included only by platform_impl.h, do not include it directly in code!
// -------------------------------------------------------------------------
//  History:
//
////////////////////////////////////////////////////////////////////////////
 
#ifndef __CryMemoryManager_impl_h__
#define __CryMemoryManager_impl_h__
#pragma once

#ifdef _LIB
	#include "ISystem.h"
#endif

#include "CryLibrary.h"

#define TRACE_ALLOCATION_LIMIT 100000

#if defined(PS3) && defined(NOT_USE_CRY_MEMORY_MANAGER)
# define _ALIGNMENT 8
#endif


#ifdef XENON
const int CM_MaxMemSize[eCryM_Num] = 
{
  0
};
/*const int CM_MaxMemSize[eCryM_Num] = 
{
  30,           // 3DEngine
  10,           // Action
  40,           // AISystem
  50,           // Animation
  10,           // EntitySystem
  5,            // Font
  1,            // Input
  1,            // Movie
  5,            // Network
  50,           // Physics
  10,           // ScriptSystem
  15,           // SoundSystem
  30,           // System
  30,           // Game
  150,          // Render
  10,           // Launcher
};*/
#else
const int CM_MaxMemSize[eCryM_Num] = 
{
  0
};
#endif

// In debug builds, pass the standard allocator routine in to override alloc behavior.
#if defined(_DEBUG) && !defined(PS3)
	// Standard lib alloc routine (used in debug builds).
	#undef malloc
	#undef calloc
	#undef realloc
	#undef free
#endif

#define DEBUG_ALLOC_FLAG	0x80000000

#ifndef XENON
#define DLL_ENTRY_CRYMALLOC "CryMalloc"
#define DLL_ENTRY_CRYFREE "CryFree"
#define DLL_ENTRY_CRYREALLOC "CryRealloc"
#define DLL_ENTRY_CRYGETMEMSIZE "CryGetMemSize"
#define DLL_ENTRY_CRYCRTMALLOC "CrySystemCrtMalloc"
#define DLL_ENTRY_CRYCRTFREE "CrySystemCrtFree"
#define DLL_ENTRY_CRYCRTSIZE "CrySystemCrtSize"
#define DLL_ENTRY_GETMEMMANAGER "CryGetIMemoryManagerInterface"
#else
#define DLL_ENTRY_CRYMALLOC      (LPCSTR)2
#define DLL_ENTRY_CRYFREE        (LPCSTR)3
#define DLL_ENTRY_CRYREALLOC     (LPCSTR)4
#define DLL_ENTRY_CRYGETMEMSIZE  (LPCSTR)5
#define DLL_ENTRY_CRYCRTMALLOC 	 (LPCSTR)13
#define DLL_ENTRY_CRYCRTFREE		 (LPCSTR)14
#define DLL_ENTRY_CRYCRTSIZE		 (LPCSTR)16
#define DLL_ENTRY_GETMEMMANAGER	 (LPCSTR)17
#endif

#ifdef _LIB
  const char *CM_Name[eCryM_Num] = 
  {
    "Cry3DEngine",
    "CryAction",
    "CryAISystem",
    "CryAnimation",
    "CryEntitySystem",
    "CryFont",
    "CryInput",
    "CryMovie",
    "CryNetwork",
    "CryPhysics",
    "CryScriptSystem",
    "CrySoundSystem",
    "CrySystem",
    "CryGame",
    "CryRender",
    "Launcher",
  };
#endif

#if defined(PS3)
extern long g_TotalAllocatedMemory;
// On PS3, CryMalloc and friends may be exported from a PRX (unless PS3_NOPRX
// is defined, indicating that the entire solution is linked statically).  PRX
// exported functions may _not_ be called through a function pointer, so we
// need a wrapper to call them.
#if !defined(PS3_NOPRX)
void *WrappedCryMalloc(size_t size, size_t &allocated)
{
	return CryMalloc(size, allocated);
}
void *WrappedCryRealloc(void *memblock, size_t size, size_t &allocated)
{
	return CryRealloc(memblock, size, allocated);
}
size_t WrappedCryFree(void *memblock)
{
	return CryFree(memblock);
}
size_t WrappedCryGetMemSize(void *memblock, size_t sourceSize)
{
	return CryGetMemSize(memblock, sourceSize);
}
void *WrappedCrySystemCrtMalloc(size_t size)
{
	return CrySystemCrtMalloc(size);
}

void *WrappedCrySystemCrtRealloc(void * p, size_t size, size_t alignment)
{
	return CrySystemCrtRealloc(p, size, alignment);
}

size_t WrappedCrySystemCrtFree(void *memblock)
{
	return CrySystemCrtFree(memblock);
}

size_t WrappedCrySystemCrtSize(void *memblock)
{
	return CrySystemCrtSize(memblock);
}
#else
#define WrappedCryMalloc CryMalloc
#define WrappedCryRealloc CryRealloc
#define WrappedCryFree CryFree
#define WrappedCryGetMemSize CryGetMemSize
#define WrappedCrySystemCrtMalloc CrySystemCrtMalloc
#define WrappedCrySystemCrtRealloc CrySystemCrtRealloc
#define WrappedCrySystemCrtFree CrySystemCrtFree
#define WrappedCrySystemCrtSize CrySystemCrtSize
#endif
#endif

//////////////////////////////////////////////////////////////////////////
// _PoolHelper definition.
//////////////////////////////////////////////////////////////////////////
struct _CryMemoryManagerPoolHelper
{
#ifdef PS3
  typedef void *(*FNC_CryMalloc)(size_t size, size_t& allocated, size_t alignment);
#else
  typedef void *(*FNC_CryMalloc)(size_t size, size_t& allocated);
#endif
	typedef void *(*FNC_CryCrtMalloc)(size_t size);
#ifdef PS3
  typedef void *(*FNC_CryRealloc)(void *memblock, size_t size, size_t& allocated, size_t alignment);
#else
  typedef void *(*FNC_CryRealloc)(void *memblock, size_t size, size_t& allocated);
#endif
  typedef size_t (*FNC_CryFree)(void *p);
	typedef void (*FNC_CryGetIMemoryManagerInterface)( void **p );
	typedef void *(*FNC_CryCrtRealloc)(void *p, size_t size);

#ifndef _LIB
  static volatile long allocatedMemory;
  static volatile long freedMemory;
  static volatile long requestedMemory;
  static volatile int numAllocations;
#else
  static uint64 allocatedMemory[eCryM_Num];
  static uint64 freedMemory[eCryM_Num];
  static uint64 requestedMemory[eCryM_Num];
  static int numAllocations[eCryM_Num];
#endif

//	typedef size_t (*FNC_CryFree)(void);
	typedef size_t (*FNC_CryGetMemSize)(void *p, size_t);
	typedef int (*FNC_CryStats)(char *buf);
	
	static FNC_CryMalloc _CryMalloc;
	static FNC_CryRealloc _CryRealloc;
	static FNC_CryFree _CryFree;
	static FNC_CryGetMemSize _CryGetMemSize;
	static FNC_CryCrtMalloc _CryCrtMalloc;
	static FNC_CryFree _CryCrtFree;
	static FNC_CryCrtRealloc _CryCrtRealloc;
	static FNC_CryFree _CryCrtSize;
	static FNC_CryGetIMemoryManagerInterface _CryGetIMemoryManagerInterface;


	static int m_bInitialized;

#if defined PS3_PRX
	// For a PRX build, the Init() method must be visible for the *_PRX.o, so it
	// may not be inlined.  With 'noinline', GCC will place the Init() method
	// into a linkonce section, which is OK.
	__attribute__ ((noinline))
#endif
	static void Init()
	{
#ifdef LINUX
		if (m_bInitialized)
			return;
#endif

		m_bInitialized = 1;
		
#ifndef _LIB
    allocatedMemory = 0;
    freedMemory = 0;
    requestedMemory = 0;
    numAllocations = 0;

#if defined(PS3)
		_CryMalloc=WrappedCryMalloc;
		_CryRealloc=WrappedCryRealloc;
		_CryFree=WrappedCryFree;
		_CryGetMemSize=WrappedCryGetMemSize;
		_CryCrtMalloc=WrappedCrySystemCrtMalloc;
		_CryCrtRealloc=WrappedCrySystemCrtRealloc;
		_CryCrtFree=(FNC_CryFree)WrappedCrySystemCrtFree;
		_CryCrtSize=(FNC_CryFree)WrappedCrySystemCrtSize;
#else
		HMODULE hMod;
		int iter;
#ifdef LINUX
		for(iter=0,hMod=::dlopen(NULL, RTLD_LAZY); hMod; iter++)
#else
		for(iter=0,hMod=GetModuleHandle(0); hMod; iter++)
#endif
		{
			_CryMalloc=(FNC_CryMalloc)CryGetProcAddress(hMod,DLL_ENTRY_CRYMALLOC);
			_CryRealloc=(FNC_CryRealloc)CryGetProcAddress(hMod,DLL_ENTRY_CRYREALLOC);
			_CryFree=(FNC_CryFree)CryGetProcAddress(hMod,DLL_ENTRY_CRYFREE);
			_CryGetMemSize=(FNC_CryGetMemSize)CryGetProcAddress(hMod,DLL_ENTRY_CRYGETMEMSIZE);
			_CryCrtMalloc=(FNC_CryCrtMalloc)CryGetProcAddress(hMod,DLL_ENTRY_CRYCRTMALLOC);
			_CryCrtSize=(FNC_CryFree)CryGetProcAddress(hMod,DLL_ENTRY_CRYCRTSIZE);
			_CryCrtFree=(FNC_CryFree)CryGetProcAddress(hMod,DLL_ENTRY_CRYCRTFREE);
			_CryGetIMemoryManagerInterface=(FNC_CryGetIMemoryManagerInterface)CryGetProcAddress(hMod,DLL_ENTRY_GETMEMMANAGER);

			if ((_CryMalloc && _CryRealloc && _CryFree && _CryGetMemSize && _CryCrtMalloc && _CryCrtFree && _CryCrtSize && _CryGetIMemoryManagerInterface) || iter==1)
				break;
#ifdef LINUX
			hMod = CryLoadLibrary("CrySystem.so");
#else
      hMod = CryLoadLibrary("CrySystem.dll"); 
#endif
		}
		if (!hMod || !_CryMalloc || !_CryRealloc || !_CryFree || !_CryGetMemSize ||! _CryCrtMalloc || !_CryCrtFree || !_CryCrtSize || !_CryGetIMemoryManagerInterface)
		{
#ifndef AVOID_MEMORY_ERROR
			#ifdef WIN32
				MessageBox(NULL, "Could not access CrySystem.dll (check working directory)", "Memory Manager", MB_OK);
      #else
      if (!hMod)
        OutputDebugString("Could not access CrySystem.dll (check working directory)");
      else
        OutputDebugString("Could not get Memory Functions in CrySystem.dll");
			#endif
			exit(1);
#endif
		};
#endif // LINUX || PS3
#else
    for (int i=0; i<eCryM_Num; i++)
    {
      allocatedMemory[i] = 0;
      freedMemory[i] = 0;
      requestedMemory[i] = 0;
      numAllocations[i] = 0;
    }
#if defined(PS3)
		_CryMalloc=WrappedCryMalloc;
		_CryRealloc=WrappedCryRealloc;
		_CryFree=WrappedCryFree;
		_CryGetMemSize=WrappedCryGetMemSize;
		_CryCrtMalloc=WrappedCrySystemCrtMalloc;
		_CryCrtFree=(FNC_CryFree)WrappedCrySystemCrtFree;
		_CryCrtSize=(FNC_CryFree)WrappedCrySystemCrtSize;
#else
		_CryMalloc=CryMalloc;
		_CryRealloc=CryRealloc;
		_CryFree=CryFree;
		_CryGetMemSize=CryGetMemSize;
		_CryCrtMalloc=CrySystemCrtMalloc;
		_CryCrtRealloc=CrySystemCrtRealloc;
		_CryCrtFree=(FNC_CryFree)CrySystemCrtFree;
		_CryCrtSize=(FNC_CryFree)CrySystemCrtSize;
		_CryGetIMemoryManagerInterface=(FNC_CryGetIMemoryManagerInterface)CryGetIMemoryManagerInterface;

#endif
#endif
	}

#ifndef _LIB
	static void FakeAllocation( long size )
	{
		if (!m_bInitialized)
			Init();
		CryInterlockedExchangeAdd(&allocatedMemory, size);
		CryInterlockedExchangeAdd(&requestedMemory, size);
		GetISystem()->GetIMemoryManager()->FakeAllocation( size );
	}
#else //_LIB
	static void FakeAllocation( long size,ECryModule eCM )
	{
		if (!m_bInitialized)
			Init();
		allocatedMemory[eCM] += size;
		requestedMemory[eCM] += size;
		GetISystem()->GetIMemoryManager()->FakeAllocation( size );
	}
#endif //_LIB

	//////////////////////////////////////////////////////////////////////////
	static IMemoryManager* GetIMemoryManager()
	{
		if (!m_bInitialized)
			Init();
		IMemoryManager *ptr = 0;
		#ifdef _LIB
			CryGetIMemoryManagerInterface((void**)&ptr);
		#else
			_CryGetIMemoryManagerInterface((void**)&ptr);
		#endif
		return ptr;
	}
 
#ifndef _LIB
	static void GetMemoryInfo( CryModuleMemoryInfo *pMmemInfo )
	{
		pMmemInfo->allocated = allocatedMemory;
		pMmemInfo->freed = freedMemory;
		pMmemInfo->requested = requestedMemory;
		pMmemInfo->num_allocations = numAllocations;
#ifdef CRY_STRING
		pMmemInfo->CryString_allocated = string::_usedMemory(0) + wstring::_usedMemory(0);
#endif
		pMmemInfo->STL_allocated = 0;
		pMmemInfo->STL_wasted = 0;
#if defined(CRY_STL_ALLOC) && defined(STLPORT)
		std::vector<int> dummy;
		//@TODO: Timur, Fix it back
		//pMmemInfo->STL_allocated = dummy.get_allocator().get_heap_size();
		pMmemInfo->STL_wasted = 0;//dummy.get_allocator().get_wasted_in_allocation() + dummy.get_allocator().get_wasted_in_blocks();
#endif
	}
#else
  static void GetMemoryInfo( CryModuleMemoryInfo *pMmemInfo, ECryModule eCM )
  {
    pMmemInfo->allocated = allocatedMemory[eCM];
    pMmemInfo->freed = freedMemory[eCM];
    pMmemInfo->requested = requestedMemory[eCM];
    pMmemInfo->num_allocations = numAllocations[eCM];
#ifdef CRY_STRING
		pMmemInfo->CryString_allocated = string::_usedMemory(0) + wstring::_usedMemory(0);
#endif
  }
#endif

	//////////////////////////////////////////////////////////////////////////
	// Local version of allocations, does memory counting per module.
	//////////////////////////////////////////////////////////////////////////
#ifndef _LIB
	static ILINE void*	Malloc(size_t size)
#else
  static ILINE void*	Malloc(size_t size, ECryModule eCM)
#endif
	{
		if (!m_bInitialized)
			Init();

#ifdef TRACE_ALL_ALLOCATIONS
		if (size > TRACE_ALLOCATION_LIMIT) {
			FILE * f = fopen("d:\\allocations.txt", "a");
			fprintf(f, "Alloc:%s:%i\n", DEFINE_MODULE_NAME, size);
			fclose(f);
		}
#endif

		size_t allocated;
#ifndef __MEMORY_VALIDATOR_HACK
#ifdef PS3
		void * p = _CryMalloc( size, allocated, _ALIGNMENT );
#else
		void * p = _CryMalloc( size, allocated );
#endif
# ifndef _LIB
    CryInterlockedExchangeAdd(&allocatedMemory, allocated);
		//allocatedMemory += allocated;
# else
	allocatedMemory[eCM] += allocated;
# endif
#else
		void * p = _CryMalloc( size);
    allocated = _CryGetMemSize(p)
    CryInterlockedExchangeAdd(&allocatedMemory, allocated);
		//allocatedMemory += ;
#endif

#ifndef _LIB
    //requestedMemory += size;
    CryInterlockedExchangeAdd(&requestedMemory, size);
		//numAllocations++;
    CryInterlockedIncrement(&numAllocations);
#else
    requestedMemory[eCM] += size;
    numAllocations[eCM]++;
    if (CM_MaxMemSize[eCM]>0 && requestedMemory[eCM]/(1024*1024) > CM_MaxMemSize[eCM])
    {
      CryFatalError("Memory usage for module '%s' exceed limit (%d Mb)", CM_Name[eCM], CM_MaxMemSize[eCM]);
    }
#endif

		return p;
	}

	//special alignment version of malloc
#if defined(PS3)
	#ifndef _LIB
		static ILINE void*	Malloc(size_t size, size_t alignment)
	#else
		static ILINE void*	Malloc(size_t size, size_t alignment, ECryModule eCM)
	#endif
	{
		if (!m_bInitialized)
			Init();
		if(alignment <= _ALIGNMENT)
	#ifndef _LIB
			return Malloc(size);
	#else
			return Malloc(size, eCM);
	#endif
		size_t allocated = size;
		void * p = memalign(alignment, size);
		CryInterlockedExchangeAdd(&g_TotalAllocatedMemory, size);
# ifndef _LIB
		allocatedMemory += allocated;
# else
		allocatedMemory[eCM] += allocated;
# endif

#ifndef _LIB
		requestedMemory += size;
		numAllocations++;
#else
		requestedMemory[eCM] += size;
		numAllocations[eCM]++;
		if (CM_MaxMemSize[eCM]>0 && requestedMemory[eCM]/(1024*1024) > CM_MaxMemSize[eCM])
		{
			CryFatalError("Memory usage for module '%s' exceed limit (%d Mb)", CM_Name[eCM], CM_MaxMemSize[eCM]);
		}
#endif
		return p;
	}
#endif

	//////////////////////////////////////////////////////////////////////////
	// Local version of allocations, does memory counting per module.
	//////////////////////////////////////////////////////////////////////////
#ifndef _LIB
	static ILINE void*	Calloc(size_t num,size_t size)
	{
		void *p = (char*)Malloc(num*size);
		memset(p, 0, num*size );
		return p;
	}
#else
  static ILINE void*	Calloc(size_t num,size_t size, ECryModule eCM)
  {
    void *p = (char*)Malloc(num*size, eCM);
    memset(p, 0, num*size );
    return p;
  }
#endif

	//////////////////////////////////////////////////////////////////////////
#ifndef _LIB
	static ILINE void*	Realloc(void *memblock,size_t size)
#else
	#if defined(PS3)
		static ILINE void*	Realloc(void *memblock,size_t size, size_t alignment, ECryModule eCM)	
	#else
		static ILINE void*	Realloc(void *memblock,size_t size, ECryModule eCM)
	#endif
#endif
	{
		if (!m_bInitialized)
			Init();

#ifdef TRACE_ALL_ALLOCATIONS
		if (size >	TRACE_ALLOCATION_LIMIT) {
			FILE * f = fopen("d:\\allocations.txt", "a");
			fprintf(f, "realloc:%s:%i\n", DEFINE_MODULE_NAME, size);
			fclose(f);
		}

#endif

		if (memblock == NULL)
		{
			//numAllocations++;
			//allocatedMemory += size;
#ifndef _LIB
			void *p = Malloc(size);
			return p;
#else
	#if defined(PS3)
			void *p = Malloc(size, alignment, eCM);
			return p;
	#else
      return Malloc(size, eCM);
	#endif
#endif
		}

//		int* t = (int*)memblock;
		size_t oldsize = _CryGetMemSize(memblock, size);//*--t;	
		size_t allocated;
#ifndef ___MEMORY_VALIDATOR_HACK
#ifdef PS3
		void * p=  _CryRealloc( memblock, size, allocated, alignment);
#else
		void * p=  _CryRealloc( memblock, size, allocated );
#endif
# ifndef _LIB
    CryInterlockedExchangeAdd(&allocatedMemory, allocated);
		/*allocatedMemory += allocated;*/
# else
    allocatedMemory[eCM] += allocated;
# endif
#else
		void * p=  _CryRealloc( memblock, size);
		size_t allocated = _CryGetMemSize(p);
    CryInterlockedExchangeAdd(&allocatedMemory, allocated);
#endif

#ifndef _LIB
    CryInterlockedIncrement(&numAllocations);
    //numAllocations++;

    CryInterlockedExchangeAdd(&requestedMemory, size);
    //requestedMemory += size;
    long tt = oldsize &= ~DEBUG_ALLOC_FLAG;
    CryInterlockedExchangeAdd(&freedMemory, tt);
    //freedMemory += tt;
#else
    numAllocations[eCM]++;
    requestedMemory[eCM] += size;
    freedMemory[eCM] += oldsize &= ~DEBUG_ALLOC_FLAG;
    if (CM_MaxMemSize[eCM]>0 && requestedMemory[eCM]/(1024*1024) > CM_MaxMemSize[eCM])
    {
      CryFatalError("Memory usage for module '%s' exceed limit (%d Mb)", CM_Name[eCM], CM_MaxMemSize[eCM]);
    }
#endif
/*
		if (p)
			return p;
		else
		*/
		return p;
			
	}
	//////////////////////////////////////////////////////////////////////////
#ifndef _LIB
	static ILINE size_t Free( void *memblock )
#else
  static ILINE size_t Free( void *memblock, ECryModule eCM )
#endif
	{
		size_t freed = 0;


		if (!m_bInitialized)
			Init();
		if (memblock != 0)
		{
			/*
			if (size & DEBUG_ALLOC_FLAG)
			{
				// Free using custom allocator.
				size &= ~DEBUG_ALLOC_FLAG;
				TPFAlloc pa = (TPFAlloc)*--t;
				pa(t, 0);
			}
			else
			*/
			freed = _CryFree( memblock );
#ifndef _LIB				
      CryInterlockedExchangeAdd(&freedMemory, freed);
			//freedMemory += freed;
#else
      freedMemory[eCM] += freed;
#endif
		}

#ifdef TRACE_ALL_ALLOCATIONS
		if (freed > TRACE_ALLOCATION_LIMIT) {
			FILE * f = fopen("d:\\allocations.txt", "a");
			fprintf(f, "Free:%s:%i\n", DEFINE_MODULE_NAME, freed);
			fclose(f);
		}

#endif
		return freed;
	}
};

//////////////////////////////////////////////////////////////////////////
// Static variables.
//////////////////////////////////////////////////////////////////////////
#ifndef _LIB
volatile long _CryMemoryManagerPoolHelper::allocatedMemory = 0;
volatile long _CryMemoryManagerPoolHelper::freedMemory = 0;
volatile long _CryMemoryManagerPoolHelper::requestedMemory = 0;
volatile int _CryMemoryManagerPoolHelper::numAllocations = 0;
#else
uint64 _CryMemoryManagerPoolHelper::allocatedMemory[eCryM_Num];
uint64 _CryMemoryManagerPoolHelper::freedMemory[eCryM_Num];
uint64 _CryMemoryManagerPoolHelper::requestedMemory[eCryM_Num];
int _CryMemoryManagerPoolHelper::numAllocations[eCryM_Num];
#endif
_CryMemoryManagerPoolHelper::FNC_CryMalloc _CryMemoryManagerPoolHelper::_CryMalloc = NULL;
_CryMemoryManagerPoolHelper::FNC_CryGetMemSize _CryMemoryManagerPoolHelper::_CryGetMemSize = NULL;
_CryMemoryManagerPoolHelper::FNC_CryRealloc _CryMemoryManagerPoolHelper::_CryRealloc = NULL;
_CryMemoryManagerPoolHelper::FNC_CryFree _CryMemoryManagerPoolHelper::_CryFree = NULL;
_CryMemoryManagerPoolHelper::FNC_CryCrtMalloc _CryMemoryManagerPoolHelper::_CryCrtMalloc = NULL;
_CryMemoryManagerPoolHelper::FNC_CryCrtRealloc _CryMemoryManagerPoolHelper::_CryCrtRealloc = NULL;
_CryMemoryManagerPoolHelper::FNC_CryFree _CryMemoryManagerPoolHelper::_CryCrtFree = NULL;
_CryMemoryManagerPoolHelper::FNC_CryFree _CryMemoryManagerPoolHelper::_CryCrtSize = NULL;
_CryMemoryManagerPoolHelper::FNC_CryGetIMemoryManagerInterface _CryMemoryManagerPoolHelper::_CryGetIMemoryManagerInterface = NULL;
int _CryMemoryManagerPoolHelper::m_bInitialized = 0;
//////////////////////////////////////////////////////////////////////////

#ifndef _LIB

#  if !defined(NOT_USE_CRY_MEMORY_MANAGER)
//////////////////////////////////////////////////////////////////////////
void* CryModuleMalloc( size_t size ) throw()
{
	return _CryMemoryManagerPoolHelper::Malloc(size);
};
//////////////////////////////////////////////////////////////////////////
void* CryModuleCalloc( size_t num,size_t size ) throw()
{
	return _CryMemoryManagerPoolHelper::Calloc(num,size);
};
//////////////////////////////////////////////////////////////////////////
void* CryModuleRealloc( void *ptr,size_t size )  throw()
{
	return _CryMemoryManagerPoolHelper::Realloc(ptr,size);
};
//////////////////////////////////////////////////////////////////////////
size_t  CryModuleFree( void *ptr ) throw()
{
	return _CryMemoryManagerPoolHelper::Free(ptr);
};

#  endif

//////////////////////////////////////////////////////////////////////////
CRY_MEM_USAGE_API void CryModuleGetMemoryInfo( CryModuleMemoryInfo *pMemInfo )
{
#if !defined(NOT_USE_CRY_MEMORY_MANAGER)
	_CryMemoryManagerPoolHelper::GetMemoryInfo(pMemInfo);
#endif
};

void CryGetMemoryInfoForModule(CryModuleMemoryInfo * pInfo)
{
#if !defined(NOT_USE_CRY_MEMORY_MANAGER)
	_CryMemoryManagerPoolHelper::GetMemoryInfo(pInfo);
#endif
}

//FIX: just emulate of allocation of aligned memory for PC
void* CryModuleMemalign( size_t size, size_t alignment ) throw()
{
#  if !defined(NOT_USE_CRY_MEMORY_MANAGER)
	uint8 * p = (uint8 *)_CryMemoryManagerPoolHelper::Malloc(size + alignment);
#else
	uint8 * p = (uint8 *)malloc(size + alignment);
#endif
	if (p)
	{
		uint8 offset = (BYTE)(alignment - ((UINT_PTR)p & (alignment - 1)));
		p += offset;
		p[-1] = offset;
	}
	return p;
};

void CryModuleMemalignFree(void* p) throw()
{
	if(p)
	{
		uint8* pb = static_cast<uint8*>(p);
		pb -= pb[-1];
#  if !defined(NOT_USE_CRY_MEMORY_MANAGER)
		_CryMemoryManagerPoolHelper::Free(pb);
#else
		free(pb);
#endif
	}
};


#else

#if defined(PS3)
# if !defined(NOT_USE_CRY_MEMORY_MANAGER)
	//////////////////////////////////////////////////////////////////////////
	void* CryModuleMemalign( size_t size, size_t alignment, ECryModule eCM ) throw()
	{
		return _CryMemoryManagerPoolHelper::Malloc(size, alignment, eCM);
	};

  void  CryModuleMemalignFree( void *ptr, ECryModule eCM ) throw()
  {
    _CryMemoryManagerPoolHelper::Free(ptr, eCM);
  };
# endif // NOT_USE_CRY_MEMORY_MANAGER
#else
//FIX: just emulate of allocation of aligned memory for PC
	void* CryModuleMemalign( size_t size, size_t alignment, ECryModule eCM ) throw()
	{
		uint8 * p = (uint8 *)_CryMemoryManagerPoolHelper::Malloc(size + alignment, eCM);
		if (p)
		{
			uint8 offset = (BYTE)(alignment - ((UINT_PTR)p & (alignment - 1)));
			p += offset;
			p[-1] = offset;
		}
		return p;
	};

	void CryModuleMemalignFree(void* p, ECryModule eCM) throw()
	{
		if(p)
		{
			uint8* pb = static_cast<uint8*>(p);
			pb -= pb[-1];
			_CryMemoryManagerPoolHelper::Free(pb, eCM);
		}
	};

#endif
//////////////////////////////////////////////////////////////////////////
void* CryModuleMalloc( size_t size, ECryModule eCM ) throw()
{
  return _CryMemoryManagerPoolHelper::Malloc(size, eCM);
};
//////////////////////////////////////////////////////////////////////////
void* CryModuleCalloc( size_t num, size_t size, ECryModule eCM ) throw()
{
  return _CryMemoryManagerPoolHelper::Calloc(num,size,eCM);
};
//////////////////////////////////////////////////////////////////////////
void* CryModuleRealloc( void *ptr, size_t size, ECryModule eCM )  throw()
{
#if defined(PS3)
  return _CryMemoryManagerPoolHelper::Realloc(ptr,size, _ALIGNMENT, eCM);
#else
  return _CryMemoryManagerPoolHelper::Realloc(ptr,size, eCM);
#endif
};
#if defined(PS3) && !defined(NOT_USE_CRY_MEMORY_MANAGER)
void* CryModuleReallocAlign( void *ptr, size_t size, size_t alignment, ECryModule eCM )  throw()
{
	return _CryMemoryManagerPoolHelper::Realloc(ptr,size, alignment, eCM);
};
#endif
//////////////////////////////////////////////////////////////////////////
size_t  CryModuleFree( void *ptr, ECryModule eCM ) throw()
{
  return _CryMemoryManagerPoolHelper::Free(ptr, eCM);
};
//////////////////////////////////////////////////////////////////////////
CRY_MEM_USAGE_API void CryModuleGetMemoryInfo( CryModuleMemoryInfo *pMemInfo, ECryModule eCM )
{
  _CryMemoryManagerPoolHelper::GetMemoryInfo(pMemInfo, eCM);
};
//////////////////////////////////////////////////////////////////////////
void CryGetMemoryInfoForModule(CryModuleMemoryInfo * pInfo)
{
	_CryMemoryManagerPoolHelper::GetMemoryInfo(pInfo, eCryModule);
};
#endif

void *CryCrtMalloc(size_t size)
{
#if defined(NOT_USE_CRY_MEMORY_MANAGER) || (defined(_DEBUG) && !defined(PS3))
	return malloc(size);
#else
#ifdef LINUX
	_CryMemoryManagerPoolHelper::Init();
#endif
	return _CryMemoryManagerPoolHelper::_CryCrtMalloc(size);
#endif
}

size_t CryCrtFree(void *p)
{
#if defined(NOT_USE_CRY_MEMORY_MANAGER) || (defined(_DEBUG) && !defined(PS3))
	free(p);
	return 0;
#else
	return _CryMemoryManagerPoolHelper::_CryCrtFree(p);
#endif
};

size_t CryCrtSize(void *p)
{
#if defined(NOT_USE_CRY_MEMORY_MANAGER) || (defined(_DEBUG) && !defined(PS3))
#ifdef LINUX
	return malloc_usable_size(p);
#else
	return _msize(p);
#endif
#else
	return _CryMemoryManagerPoolHelper::_CryCrtSize(p);
#endif
};


// If using CryMemoryManager, redefine new & delete for entire module.
#if (!defined(_DEBUG) || defined(PS3)) && !defined(NOT_USE_CRY_MEMORY_MANAGER) && !defined(__SPU__)
	#if !defined(_LIB) && !defined(NEW_OVERRIDEN)
		void * __cdecl operator new   (size_t size) { return CryModuleMalloc(size); } 
		void * __cdecl operator new[] (size_t size) { return CryModuleMalloc(size); }; 
		void __cdecl operator delete  (void *p) { CryModuleFree(p); };
		void __cdecl operator delete[](void *p) { CryModuleFree(p); };
	#endif//_LIB
#endif //!defined(_DEBUG) && !defined(NOT_USE_CRY_MEMORY_MANAGER) && !defined(__SPU__)

//////////////////////////////////////////////////////////////////////////

void* SafeAlloc( TPFAlloc allocator, void *ptr, size_t size )
{
	if (ptr)
		// Use original allocator.
		allocator = *--((TPFAlloc*&)ptr);
	if (size)
		size += sizeof(TPFAlloc);
	ptr = (*allocator)(ptr, size);
	if (ptr)
		// Store allocator.
	 	*((TPFAlloc*&)ptr)++ = allocator;
	return ptr;
}

//////////////////////////////////////////////////////////////////////////
IMemoryManager *CryGetIMemoryManager()
{
	return _CryMemoryManagerPoolHelper::GetIMemoryManager();
}

// memReplay stuff, only needed outside of CrySystem (moved from xmem.cpp by AlexMcC)
#ifndef CRYSYSTEM_EXPORTS

#ifdef XENON
static bool bProcessed=false;
LPVOID WINAPI XMemAlloc(SIZE_T size,DWORD dwAllocAttributes)
{
	LPVOID p=XMemAllocDefault(size, dwAllocAttributes);
	if (!bProcessed)
	{
		{
			uint32 alignment=1;
			XALLOC_ATTRIBUTES* attributes=(XALLOC_ATTRIBUTES*)&dwAllocAttributes;

			if (attributes->dwMemoryType == XALLOC_MEMTYPE_HEAP)
			{
				switch (attributes->dwAlignment)
				{
				case XALLOC_ALIGNMENT_4: alignment = 4; break;
				case XALLOC_ALIGNMENT_8: alignment = 8; break;
				case XALLOC_ALIGNMENT_DEFAULT:
				case XALLOC_ALIGNMENT_16: alignment = 16; break;
				default:
					CryLog("Invalid alignment\n");
					break;
				}
			}
			else if (attributes->dwMemoryType == XALLOC_MEMTYPE_PHYSICAL)
			{
				switch (attributes->dwAlignment)
				{ 
				case XALLOC_PHYSICAL_ALIGNMENT_4:
					alignment=4; break;
				case XALLOC_PHYSICAL_ALIGNMENT_8:
					alignment=8; break;
				case XALLOC_PHYSICAL_ALIGNMENT_16:
					alignment=16; break;
				case XALLOC_PHYSICAL_ALIGNMENT_32:
					alignment=32; break;
				case XALLOC_PHYSICAL_ALIGNMENT_64:
					alignment=64; break;
				case XALLOC_PHYSICAL_ALIGNMENT_128:
					alignment=128; break;
				case XALLOC_PHYSICAL_ALIGNMENT_256:
					alignment=256; break;
				case XALLOC_PHYSICAL_ALIGNMENT_512:
					alignment=512; break;
				case XALLOC_PHYSICAL_ALIGNMENT_1K:
					alignment=1024; break;
				case XALLOC_PHYSICAL_ALIGNMENT_2K:
					alignment=2*1024; break;
				case XALLOC_PHYSICAL_ALIGNMENT_DEFAULT:
				case XALLOC_PHYSICAL_ALIGNMENT_4K:
					alignment=4*1024; break;
				case XALLOC_PHYSICAL_ALIGNMENT_8K:
					alignment=8*1024; break;
				case XALLOC_PHYSICAL_ALIGNMENT_16K:
					alignment=16*1024; break;
				case XALLOC_PHYSICAL_ALIGNMENT_32K:
					alignment=32*1024; break;
				default:
					CryLog("Invalid alignment\n");
					break;
				}
			}
			else
			{
				CryLog("Invalid memory type\n");
			}
			if (attributes->dwMemoryType==XALLOC_MEMTYPE_PHYSICAL && attributes->dwMemoryProtect==XALLOC_MEMPROTECT_WRITECOMBINE_LARGE_PAGES)
				alignment=64*1024;
			size=Align(size, alignment);
			CryGetIMemReplay()->MemStatAlloc(p, size);
		}
	}
	return p;
}

void WINAPI XMemFree(PVOID p,DWORD dwAllocAttributes)
{
	XMemFreeDefault(p, dwAllocAttributes);
	if (!bProcessed)
	{
		CryGetIMemReplay()->MemStatFree(p);
	}
}

void XMemTrackFree(LPVOID p)
{
	if (!bProcessed)
	{
		CryGetIMemReplay()->MemStatFree(p);
	}
}

void XMemTrack(LPVOID p, SIZE_T size)
{
	if (!bProcessed)
	{
		CryGetIMemReplay()->MemStatAlloc(p, size);
	}
}

#pragma push_macro("XPhysicalAlloc")
#undef XPhysicalAlloc
#pragma push_macro("XPhysicalAllocEx")
#undef XPhysicalAllocEx
#pragma push_macro("XPhysicalFree")
#undef XPhysicalFree
#pragma push_macro("XEncryptedAlloc")
#undef XEncryptedAlloc
#pragma push_macro("XEncryptedFree")
#undef XEncryptedFree

LPVOID XTrackedPhysicalAlloc(SIZE_T dwSize, ULONG_PTR ulPhysicalAddress, ULONG_PTR ulAlignment, DWORD flProtect)
{
	LPVOID ptr = XPhysicalAlloc(dwSize, ulPhysicalAddress, ulAlignment, flProtect);
	DWORD pageSize = (flProtect & MEM_LARGE_PAGES) ? 65536 : ((flProtect & MEM_16MB_PAGES) ? (16 * 1024 * 1024) : 4096);

	XMemTrack(ptr, Align(dwSize, pageSize));
	return ptr;
}

LPVOID XTrackedPhysicalAllocEx(SIZE_T dwSize, ULONG_PTR ulLowestAcceptableAddress, ULONG_PTR ulHighestAcceptableAddress, ULONG_PTR ulAlignment, DWORD flProtect)
{
	LPVOID ptr = XPhysicalAllocEx(dwSize, ulLowestAcceptableAddress, ulHighestAcceptableAddress, ulAlignment, flProtect);
	DWORD pageSize = (flProtect & MEM_LARGE_PAGES) ? 65536 : ((flProtect & MEM_16MB_PAGES) ? (16 * 1024 * 1024) : 4096);

	XMemTrack(ptr, Align(dwSize, pageSize));
	return ptr;
}

VOID XTrackedPhysicalFree(LPVOID lpAddress)
{
	XMemTrackFree(lpAddress);
	XPhysicalFree(lpAddress);
}

LPVOID XTrackedEncryptedAlloc(SIZE_T dwSize)
{
	LPVOID ptr = XEncryptedAlloc(dwSize);
	XMemTrack(ptr, dwSize);
	return ptr;
}

VOID XTrackedEncryptedFree(LPVOID lpAddress)
{
	XMemTrackFree(lpAddress);
	XEncryptedFree(lpAddress);
}

#pragma pop_macro("XPhysicalAlloc")
#pragma pop_macro("XPhysicalAllocEx")
#pragma pop_macro("XPhysicalFree")
#pragma pop_macro("XEncryptedAlloc")
#pragma pop_macro("XEncryptedFree")

#endif

#endif // CRYSYSTEM_EXPORTS
// ~memReplay

#endif // __CryMemoryManager_impl_h__
