//---------------------------------------------------------------------------
// Copyright 2010 Crytek GmbH
// Created by: Michael Kopietz
// Modified: -
//	
//---------------------------------------------------------------------------

#ifndef __CCRYPOOLSTLWRAPPER__
#define __CCRYPOOLSTLWRAPPER__

namespace NCryPoolAlloc
{

//namespace CSTLPoolAllocWrapperHelper
//{
//	inline void destruct(char *) {}
//	inline void destruct(wchar_t*) {}
//	template <typename T> 
//		inline void destruct(T *t) {t->~T();}
//}

//template <size_t S, class L, size_t A, typename T> 
//struct CSTLPoolAllocWrapperStatic
//{
//	static PoolAllocator<S, L, A> * allocator;
//};

//template <class T, class L, size_t A> 
//struct CSTLPoolAllocWrapperKungFu : public CSTLPoolAllocWrapperStatic<sizeof(T),L,A,T>
//{
//};

template <class T,class TCont> 
class CSTLPoolAllocWrapper
{
private:
	static TCont*			m_pContainer;
public:
	typedef size_t    size_type;
	typedef ptrdiff_t difference_type;
	typedef T*        pointer;
	typedef const T*  const_pointer;
	typedef T&        reference;
	typedef const T&  const_reference;
	typedef T         value_type;

	static TCont*			Container(){return m_pContainer;}
	static void				Container(TCont* pContainer){m_pContainer=pContainer;}


	template <class U> struct rebind
	{
		typedef CSTLPoolAllocWrapper<T,TCont> other;
	};

	CSTLPoolAllocWrapper() throw()
	{
	}

	CSTLPoolAllocWrapper(const CSTLPoolAllocWrapper&) throw()
	{
	}

	template <class TTemp, class TTempCont>
	CSTLPoolAllocWrapper(const CSTLPoolAllocWrapper<TTemp,TTempCont>&) throw()
	{
	}

	~CSTLPoolAllocWrapper() throw()
	{
	}

	pointer address(reference x) const
	{
		return &x;
	}

	const_pointer address(const_reference x) const
	{
		return &x;
	}

	pointer allocate(size_type n = 1,const_pointer hint = 0)
	{
		TCont* pContainer	=	Container();
		uint8* pData			=	pContainer->TCont::template Allocate<uint8*>(n*sizeof(T),sizeof(T));
		return pContainer->TCont::template Resolve<pointer>(pData);
//	return Container()?Container()->Allocate<void*>(n*sizeof(T),sizeof(T)):0
	}

	void deallocate(pointer p, size_type n = 1)
	{
		if(Container())
			Container()->Free(p);
	}

	size_type max_size() const throw()
	{
		return Container()?Container()->MemSize():0;
	}

	void construct(pointer p, const T& val)
	{
		new(static_cast<void*>(p)) T(val);
	}

	void construct(pointer p)
	{
		new(static_cast<void*>(p)) T();
	}

	void destroy(pointer p)
	{
		p->~T();
	}

	pointer new_pointer()
	{
		return new(allocate()) T();
	}

	pointer new_pointer(const T& val)
	{
		return new(allocate()) T(val);
	}

	void delete_pointer(pointer p)
	{
		p->~T();
		deallocate(p);
	}

	bool operator==(const CSTLPoolAllocWrapper&) {return true;}
	bool operator!=(const CSTLPoolAllocWrapper&) {return false;}


};

//
//template <> class CSTLPoolAllocWrapper<void>
//{
//public:
//	typedef void* pointer;
//	typedef const void* const_pointer;
//	typedef void value_type;
//	template <class U, class L> 
//	struct rebind { typedef CSTLPoolAllocWrapper<U> other; };
//};    
#ifdef PS3	//virtual memory handling only for PS3
template <class T> 
class CSTLVirtualAlloc
{
public:
	typedef size_t				size_type;
	typedef unsigned int	handle_type;
	typedef ptrdiff_t			difference_type;
	typedef T*						pointer;
	typedef const T*			const_pointer;
	typedef T&						reference;
	typedef const T&			const_reference;
	typedef T							value_type;

	template <class U> struct rebind{	typedef CSTLVirtualAlloc<U> other;};
	CSTLVirtualAlloc() throw()
	{
		alloc_handle[0] = alloc_handle[1] = 0;
		alloc_ptr[0]		= alloc_ptr[1]		= NULL;
	}
	CSTLVirtualAlloc(const CSTLVirtualAlloc& o) throw()
	{
		alloc_handle[0] = o.alloc_handle[0];	alloc_handle[1] = o.alloc_handle[1];
		alloc_ptr[0]		= o.alloc_ptr[0];			alloc_ptr[1]		= o.alloc_ptr[1];
	}
	template <class TTemp>
	CSTLVirtualAlloc(const CSTLVirtualAlloc<TTemp>& o) throw()
	{
		alloc_handle[0] = o.alloc_handle[0];	alloc_handle[1] = o.alloc_handle[1];
		alloc_ptr[0]		= o.alloc_ptr[0];			alloc_ptr[1]		= o.alloc_ptr[1];
	}
	~CSTLVirtualAlloc() throw()
	{
		alloc_handle[0] = alloc_handle[1] = 0;
		alloc_ptr[0]		= alloc_ptr[1]		= NULL;
	}
	pointer address(reference x) const{return &x;}
	const_pointer address(const_reference x) const{return &x;}
	pointer allocate(size_type n = 1,const_pointer = 0)
	{
		handle_type h;
		T *p = (pointer)NVirtualMem::AllocVirtualMem(n*sizeof(T),h);
		if(alloc_handle[0] == 0)
		{
			alloc_handle[0] = h;	alloc_ptr[0] = p;
		}
		else
		{
			alloc_handle[1] = h;	alloc_ptr[1] = p;
		}
		return p;
	}
	void deallocate(pointer p, size_type)
	{
		if( p == alloc_ptr[0])
		{
			NVirtualMem::FreeVirtualMem(p,alloc_handle[0]);
			alloc_handle[0] = 0;	alloc_ptr[0] = 0;
		}
		else
		if( p == alloc_ptr[1])
		{
			NVirtualMem::FreeVirtualMem(p,alloc_handle[1]);
			alloc_handle[1] = 0;	alloc_ptr[1] = 0;
		}
		else
		{
			alloc_handle[0] = alloc_handle[1] = 0;
			alloc_ptr[0]		= alloc_ptr[1]		= NULL;
			NVirtualMem::FreeVirtualMem(p);
		}
	}
	size_type max_size() const throw(){return 256*1024*1024/*system memory*/;}
	void construct(pointer p, const T& val){new(static_cast<void*>(p)) T(val);}
	void construct(pointer p){new(static_cast<void*>(p)) T();}
	void destroy(pointer p){p->~T();}
	pointer new_pointer(){return new(allocate()) T();}
	pointer new_pointer(const T& val){return new(allocate()) T(val);}
	void delete_pointer(pointer p){	p->~T();deallocate(p);}
	bool operator==(const CSTLVirtualAlloc& o) 
	{
		return o.alloc_handle[0] == alloc_handle[0] && 
			o.alloc_handle[1] == alloc_handle[1] && 
			o.alloc_ptr[0] == alloc_ptr[0] && 
			o.alloc_ptr[0] == alloc_ptr[0];
	}
	bool operator!=(const CSTLVirtualAlloc& o) 
	{
		return !(operator ==(o));
	}

	handle_type	alloc_handle[2];
	void *alloc_ptr[2];
};
#endif//PS3
}

#endif

