
////////////////////////////////////////////////////////////////////////////
//
//  Crytek Engine Source File.
//  Copyright (C), Crytek Studios, 2007-2010.
// -------------------------------------------------------------------------
//  File name:   IAVI_Reader.h
//  Version:     v1.00
//  Description: AVI files reader Interface.
// -------------------------------------------------------------------------
//  History:
//  Created:     28/02/2007 by MarcoC.
//
////////////////////////////////////////////////////////////////////////////
#include DEVIRTUALIZE_HEADER_FIX(IAVI_Reader.h)

#ifndef __IAVI_Reader_h__
#define __IAVI_Reader_h__
#pragma once

//////////////////////////////////////////////////////////////////////////
UNIQUE_IFACE struct IAVI_Reader
{
	virtual bool	OpenFile( const char *szFilename)=0;
	virtual void	CloseFile() =0;

	virtual int		GetWidth() =0;
	virtual int		GetHeight() =0;
	virtual int		GetFPS() =0;

	// if no frame is passed, it will retrieve the current one and advance one frame.
	// If a frame is specified, it will get that one.
	// Notice the "const", don't override this memory!
	virtual const unsigned char *QueryFrame(int nFrame=-1) =0;

	virtual int		GetFrameCount() =0;
	virtual int		GetAVIPos() =0;
	virtual void	SetAVIPos(int nFrame) =0;
};

#endif // __IAVI_Reader_h__



