#pragma once 

#include "ProjectDefines.h"
#ifdef USING_LICENSE_PROTECTION


// All errors which may occur on license validation (To be handled in owning thread).
enum EPMErrorCode
{
	PMEC_NO_ERROR = 0,

	PMEC_CANT_WRITE_TO_SOCKET,
	PMEC_CANT_READ_FROM_SOCKET,
	PMEC_OLD_APP_VERSION,
	PMEC_NETWORK_DEVICE,
	PMEC_CONNECT_FAILED,

	PMEC_KEY_EXPIRED,
	PMEC_KEY_INVALID,
	PMEC_INVALID_TIMEFRAME,
	PMEC_KEY_NOT_FOUND,
	PMEC_PROXY_CONNECT_FAILED,
	PMEC_OVER_CONNECTION,
	PMEC_NO_DONGLE,
	PMEC_INVALID_ADDRESS,
	PMEC_REGISTRY_NOT_FOUND,
	PMEC_REQUEST_ACCOUNTLOGIN,
	PMEC_DOUBLE_LOGIN,
	PMEC_INVALID_CONNECT_TYPE,
};


// Data which is filled partially on client side and completed from license server side.
struct SClientData
{
	string sKey;
	unsigned int iRemainingDays;
	string sVersion;
	string sEncryptKey;
	string sAppName;
#ifdef USING_UNIKEY_SECURITY
	string sDongleHid;
	string sDongleExpireDate;
#endif // USING_UNIKEY_SECURITY
};


typedef void (*TProtectionCallback)();

enum ELoginAccountResult
{
	eLA_Success,
	eLA_Undefined,
	eLA_InvalidLicense,
	eLA_InvalidAccount,
	eLA_InactiveAccount
};

enum ECreateAccountResult
{
	eCA_Success,
	eCA_Undefined,
	eCA_BanCharacter,
	eCA_DuplicateUsername,
	eCA_DuplicateEmail,
	eCA_InvalidDomain
};

struct SCreateAccountParam 
{
	string username;
	string password;
	string firstname;
	string lastname;
	string email;
	string address;
	string city;
	string country;
	string state;
	string zipcode;
};


/************************************************************************/
/* Handles Client-Server license protection				                      */
/************************************************************************/
struct IProtectionManager
{
public:
	// Determines the right of a client to use this software, depending on a license server connection.
	virtual EPMErrorCode	RetrieveClientDataNew(SClientData &data) = 0;
	virtual	unsigned int	GetDisconnectedPeriod() = 0;
	virtual	void					GetSpecificErrorMessage(EPMErrorCode code, char* titleMsg, char* captionMsg) = 0;
	// Runs a thread, which constantly starts a callback for cleint validation.
	virtual void		StartLicenseVerificationThread(TProtectionCallback cb) = 0;

	virtual	ECreateAccountResult RequestCreateAccount(const SCreateAccountParam& param, EPMErrorCode& subErrorCode) = 0;
	virtual	ELoginAccountResult RequestLoginAccount(const string& username, const string& password, bool& agreeLicenseFlag, EPMErrorCode& subErrorCode) = 0;
	virtual bool RequestPasswordRemind(const string& username, const string& email) = 0;
	virtual	void SendLicenseAgree(const string& username) = 0;
	virtual void GetPrivateIdentityBuffer(char* bufferForOutput) = 0;
};


#endif // USING_LICENSE_PROTECTION
