////////////////////////////////////////////////////////////////////////////
//
//  Crytek Engine Source File.
//  Copyright (C), Crytek Studios, 2001-2005.
// -------------------------------------------------------------------------
//  File name:   MultiThread.h
//  Version:     v1.00
//  Compilers:   Visual Studio.NET 2003
//  Description: 
// -------------------------------------------------------------------------
//  History:
//
////////////////////////////////////////////////////////////////////////////

#ifndef __MultiThread_h__
#define __MultiThread_h__
#pragma once

#define WRITE_LOCK_VAL (1<<16)

#if defined(PS3) && defined(PS3_PROFILE_LOCKS)
extern int g_nLockOpCount;
extern int g_nLockContentionCount;
extern int g_nLockContentionCost;
#endif

//as PowerPC operates via cache line reservation, lock variables should reside ion their own cache line
template <class T>
struct SAtomicVar
{
	T val;
#if defined(PS3) || defined(XENON)
	char pad[128-sizeof(T)];
#endif
	inline operator T()const{return val;}
	inline operator T()volatile const{return val;}
	inline void operator =(const T& rV){val = rV;return *this;}
	inline void Assign(const T& rV){val = rV;}
	inline void Assign(const T& rV)volatile{val = rV;}
	inline T* Addr() {return &val;}
	inline volatile T* Addr() volatile {return &val;}

	inline bool operator<(const T& v)const{return val < v;}
	inline bool operator<(const SAtomicVar<T>& v)const{return val < v.val;}
	inline bool operator>(const T& v)const{return val > v;}
	inline bool operator>(const SAtomicVar<T>& v)const{return val > v.val;}
	inline bool operator<=(const T& v)const{return val <= v;}
	inline bool operator<=(const SAtomicVar<T>& v)const{return val <= v.val;}
	inline bool operator>=(const T& v)const{return val >= v;}
	inline bool operator>=(const SAtomicVar<T>& v)const{return val >= v.val;}
	inline bool operator==(const T& v)const{return val == v;}
	inline bool operator==(const SAtomicVar<T>& v)const{return val == v.val;}
	inline bool operator!=(const T& v)const{return val != v;}
	inline bool operator!=(const SAtomicVar<T>& v)const{return val != v.val;}
	inline T operator*(const T& v)const{return val * v;}
	inline T operator/(const T& v)const{return val / v;}
	inline T operator+(const T& v)const{return val + v;}
	inline T operator-(const T& v)const{return val - v;}

	inline bool operator<(const T& v)volatile const{return val < v;}
	inline bool operator<(const SAtomicVar<T>& v)volatile const{return val < v.val;}
	inline bool operator>(const T& v)volatile const{return val > v;}
	inline bool operator>(const SAtomicVar<T>& v)volatile const{return val > v.val;}
	inline bool operator<=(const T& v)volatile const{return val <= v;}
	inline bool operator<=(const SAtomicVar<T>& v)volatile const{return val <= v.val;}
	inline bool operator>=(const T& v)volatile const{return val >= v;}
	inline bool operator>=(const SAtomicVar<T>& v)volatile const{return val >= v.val;}
	inline bool operator==(const T& v)volatile const{return val == v;}
	inline bool operator==(const SAtomicVar<T>& v)volatile const{return val == v.val;}
	inline bool operator!=(const T& v)volatile const{return val != v;}
	inline bool operator!=(const SAtomicVar<T>& v)volatile const{return val != v.val;}
	inline T operator*(const T& v)volatile const{return val * v;}
	inline T operator/(const T& v)volatile const{return val / v;}
	inline T operator+(const T& v)volatile const{return val + v;}
	inline T operator-(const T& v)volatile const{return val - v;}
}
#if defined(PS3)
	_ALIGN(128)
#elif defined(XENON)
//	__declspec(align(128))
#endif
;

typedef SAtomicVar<int> TIntAtomic;
typedef SAtomicVar<unsigned int> TUIntAtomic;
typedef SAtomicVar<float> TFloatAtomic;

#ifdef __SNC__
	#ifndef __add_db16cycl__
		#define __add_db16cycl__ __db16cyc();
	#endif
#else
	#define USE_INLINE_ASM
	//#define ADD_DB16_CYCLES
	#undef __add_db16cycl__
	#ifdef ADD_DB16_CYCLES
		#define __add_db16cycl__ __asm__ volatile("db16cyc");
	#else	
		#define __add_db16cycl__ 
	#endif
#endif

#if !defined(__SPU__)
	void CrySpinLock(volatile int *pLock,int checkVal,int setVal);
  void CryReleaseSpinLock(volatile int*, int);
	#if !defined(PS3)
		long   CryInterlockedIncrement( int volatile *lpAddend );
		long   CryInterlockedDecrement( int volatile *lpAddend );
		long   CryInterlockedExchangeAdd(long volatile * lpAddend, long Value);
		long	 CryInterlockedCompareExchange(long volatile * dst, long exchange, long comperand);
		void*	 CryInterlockedCompareExchangePointer(void* volatile * dst, void* exchange, void* comperand);
	#endif
	void*  CryCreateCriticalSection();
  void   CryCreateCriticalSectionInplace(void*);
	void   CryDeleteCriticalSection( void *cs );
  void   CryDeleteCriticalSectionInplace( void *cs );
	void   CryEnterCriticalSection( void *cs );
	bool   CryTryCriticalSection( void *cs );
	void   CryLeaveCriticalSection( void *cs );

#if defined(PS3)
	#include <sys/ppu_thread.h>
	#include <pthread.h>
	#include <ppu_intrinsics.h>

	extern DWORD Sleep( DWORD dwMilliseconds );

	ILINE long CryInterlockedIncrement( int volatile *lpAddend )
	{
/*		register int r;

		__asm__ __volatile__ (
			"0:      lwarx      %0, 0, %1     # load and reserve\n"
			"        addi       %0, %0, 1    \n"
			"        stwcx.     %0, 0, %1     # store if still reserved\n"
			"        bne-       0b            # loop if lost reservation\n"
			: "=r" (r)
			: "r" (lpAddend), "m" (*lpAddend), "0" (r)
			: "r0", "cc", "memory"
			);

		// Notes:
		// - %0 and %1 must be different registers. We're specifying %0 (r) as input
		//   _and_ output to enforce this.
		// - The 'addi' instruction will become 'li' if the second register operand
		//   is r0, so we're listing r0 is clobbered to make sure r0 is not allocated
		//   for %0.
		return r;
*/
#ifdef USE_INLINE_ASM
		uint32_t old, tmp;
		__asm__ volatile(
			".loop%=:\n"
			"	lwarx   %[old], 0, %[lpAddend]\n"
			"	addi    %[tmp], %[old], 1\n"
			"	stwcx.  %[tmp], 0, %[lpAddend]\n"
			"	beq-    .exsuc%=										# check if write successful\n"	
#ifdef ADD_DB16_CYCLES
			" db16cyc											        # give other hardware thread chance to run\n"
			" db16cyc											        # give other hardware thread chance to run\n"
			" db16cyc											        # give other hardware thread chance to run\n"
			" db16cyc											        # give other hardware thread chance to run\n"
#endif
			"	b    .loop%=											  # loop if lost reservation\n"	
			".exsuc%=:														# exchange written\n"
			: [old]"=&b"(old), [tmp]"=&r"(tmp)
			: [lpAddend]"b"(lpAddend)
			: "cc", "memory");
#else
		long tmp = __lwarx((volatile void*)lpAddend);
		while(0 == __stwcx((volatile void*)lpAddend, tmp + 1))
		{
			//give other hw thread time
			__add_db16cycl__
			__add_db16cycl__
			__add_db16cycl__
			__add_db16cycl__
			tmp = __lwarx((volatile void*)lpAddend);
		}
#endif
		return tmp;
	}

	//////////////////////////////////////////////////////////////////////////
	ILINE long CryInterlockedDecrement( int volatile *lpAddend )
	{
/*		register int r;

		__asm__ __volatile__ (
			"0:      lwarx      %0, 0, %1     # load and reserve\n"
			"        addi       %0, %0, -1    \n"
			"        stwcx.     %0, 0, %1     # store if still reserved\n"
			"        bne-       0b            # loop if lost reservation\n"
			: "=r" (r)
			: "r" (lpAddend), "m" (*lpAddend), "0" (r)
			: "r0", "cc", "memory"
			);

		return r;
*/
#ifdef USE_INLINE_ASM
		uint32_t old, tmp;
		__asm__ volatile(
			".loop%=:\n"
			"	lwarx   %[old], 0, %[lpAddend]\n"
			"	subi    %[tmp], %[old], 1\n"
			"	stwcx.  %[tmp], 0, %[lpAddend]\n"
			"	beq-    .exsuc%=										# check if write successful\n"	
#ifdef ADD_DB16_CYCLES
			" db16cyc											        # give other hardware thread chance to run\n"
			" db16cyc											        # give other hardware thread chance to run\n"
			" db16cyc											        # give other hardware thread chance to run\n"
			" db16cyc											        # give other hardware thread chance to run\n"
#endif
			"	b    .loop%=											  # loop if lost reservation\n"	
			".exsuc%=:														# exchange written\n"
			: [old]"=&b"(old), [tmp]"=&r"(tmp)
			: [lpAddend]"b"(lpAddend)
			: "cc", "memory");
#else
		long tmp = __lwarx((volatile void*)lpAddend);
		while(0 == __stwcx((volatile void*)lpAddend, tmp - 1))
		{
			//give other hw thread time
			__add_db16cycl__
			__add_db16cycl__
			__add_db16cycl__
			__add_db16cycl__
			tmp = __lwarx((volatile void*)lpAddend);
		}
#endif
		return tmp;
	}
	//////////////////////////////////////////////////////////////////////////

	ILINE long CryInterlockedExchangeAdd(long volatile * lpAddend, long Value)
	{
		//implements atomically: 	long res = *dst; *dst += Value;	return res;
#ifdef USE_INLINE_ASM
		uint32_t old, tmp;
		__asm__ __volatile__ (
			".loop%=:															# loop start\n"
			" lwarx   %[old], 0, %[lpAddend]\n"
			" add     %[tmp], %[Value], %[old]\n"
			" stwcx.  %[tmp], 0, %[lpAddend]\n"
			"	beq-    .exsuc%=										# check if write successful\n"	
#ifdef ADD_DB16_CYCLES
			" db16cyc											        # give other hardware thread chance to run\n"
			" db16cyc											        # give other hardware thread chance to run\n"
			" db16cyc											        # give other hardware thread chance to run\n"
			" db16cyc											        # give other hardware thread chance to run\n"
#endif
			"	b    .loop%=											  # loop if lost reservation\n"	
			".exsuc%=:														# exchange written\n"
			: [old] "=&r" (old), [tmp] "=&r" (tmp)
			: [lpAddend] "b" (lpAddend), [Value] "r" (Value)
			: "cc", "memory"
			);
#else
		long old = __lwarx((volatile void*)lpAddend);
		while(0 == __stwcx((volatile void*)lpAddend, old + Value))
		{
			//give other hw thread time
			__add_db16cycl__
			__add_db16cycl__
			__add_db16cycl__
			__add_db16cycl__
			old = __lwarx((volatile void*)lpAddend);
		}
#endif
		return old;
	}

  ILINE long CryInterlockedExchange(long volatile *addr, long exchange)
  {
#ifdef USE_INLINE_ASM
		uint32_t old;
		__asm__ __volatile__ (
			".loop%=:															# loop start\n"
				" lwarx   %[old], 0, %[addr]\n"
				" stwcx.  %[exchange], 0, %[addr]\n"
				"	beq-    .exsuc%=										# check if write successful\n"	
#ifdef ADD_DB16_CYCLES
				" db16cyc											        # give other hardware thread chance to run\n"
				" db16cyc											        # give other hardware thread chance to run\n"
				" db16cyc											        # give other hardware thread chance to run\n"
				" db16cyc											        # give other hardware thread chance to run\n"
#endif
				"	b    .loop%=											  # loop if lost reservation\n"	
				".exsuc%=:														# exchange written\n"
				: [old] "=&r" (old)
				: [addr] "b" (addr), [exchange] "r" (exchange)
				: "cc", "memory");
#else
		long old = __lwarx((volatile void*)addr);
		while(0 == __stwcx((volatile void*)addr, exchange))
		{
			//give other hw thread time
			__add_db16cycl__
			__add_db16cycl__
			__add_db16cycl__
			__add_db16cycl__
			old = __lwarx((volatile void*)addr);
		}
#endif
		return old;
	}

	#define InterlockedExchange CryInterlockedExchange

	ILINE long CryInterlockedCompareExchange(long volatile * dst, long exchange, long comperand)
	{
		//implements atomically: 	long res = *dst; if (comperand == res)*dst = exchange;	return res;
		uint32_t old;
#ifdef USE_INLINE_ASM
		__asm__ __volatile__ (
			".loop%=:															# loop start\n"
			" lwarx   %[old], 0, %[dst]\n"
			" cmpw    %[old], %[comperand]\n"
			" bne-    1f\n"
			" stwcx.  %[exchange], 0, %[dst]\n"
			"	beq-    1f										      # check if write successful\n"	
#ifdef ADD_DB16_CYCLES
			" db16cyc											        # give other hardware thread chance to run\n"
			" db16cyc											        # give other hardware thread chance to run\n"
			" db16cyc											        # give other hardware thread chance to run\n"
			" db16cyc											        # give other hardware thread chance to run\n"
#endif
			"	b    .loop%=											  # loop if lost reservation\n"	
			"1:\n"
			: [old] "=&r" (old)
			: [dst] "b" (dst), [comperand] "r" (comperand), [exchange] "r" (exchange)
			: "cc", "memory"
			);
#else
		old = __lwarx((volatile void*)dst);
		if (old != comperand) 
			return old;
		while (0 == __stwcx((volatile void*)dst, exchange))
		{
			__add_db16cycl__
			__add_db16cycl__
			__add_db16cycl__
			__add_db16cycl__
			old = __lwarx((volatile void*)dst);
			if (old != comperand) 
				return old;
		}
#endif
		return old;
	}

  ILINE int64_t CryInterlockedCompareExchange64(
			volatile int64_t *addr,
			int64_t exchange,
			int64_t compare
			)
	{
#ifdef USE_INLINE_ASM
		int64_t old;
		__asm__ __volatile__ (
				"0:      ldarx   %[old], 0, %[addr]\n"
				"        cmpd    %[old], %[compare]\n"
				"        bne-    1f\n"
				"        stdcx.  %[exchange], 0, %[addr]\n"
				"        bne-    0b\n"
				"1:\n"
				: [old] "=&r" (old)
				: [addr] "b" (addr), [compare] "r" (compare), [exchange] "r" (exchange)
				: "cc", "memory"
				);
#else
		int64_t old = __ldarx((volatile void*)addr);
		if (old != compare) 
			return old;
		while (0 == __stdcx((volatile void*)addr, exchange))
		{
			__add_db16cycl__
			__add_db16cycl__
			__add_db16cycl__
			__add_db16cycl__
			old = __ldarx((volatile void*)addr);
			if (old != compare) 
				return old;
		}
#endif
		return old;
	}

	ILINE void*	 CryInterlockedCompareExchangePointer(void* volatile * dst, void* exchange, void* comperand)
	{
#if !defined(PS3)
		assert(sizeof(void*) == sizeof(long));
#endif
		return (void*)CryInterlockedCompareExchange((long volatile*)dst, (long)exchange, (long)comperand);
	}
#endif

ILINE void CrySpinLock(volatile int *pLock,int checkVal,int setVal)
{ 
#ifdef XENON    
  while(InterlockedCompareExchangeAcquire((volatile long*)pLock,setVal,checkVal)!=checkVal)
		Sleep(0);
#else

#ifdef _CPU_X86
# ifdef __GNUC__
	register int val;
	__asm__ __volatile__ (
		"0:     mov %[checkVal], %%eax\n"
		"       lock cmpxchg %[setVal], (%[pLock])\n"
		"       jnz 0b"
		: "=m" (*pLock)
		: [pLock] "r" (pLock), "m" (*pLock),
		  [checkVal] "m" (checkVal),
		  [setVal] "r" (setVal)
		: "eax", "cc", "memory"
		);
# else
	__asm
	{
		mov edx, setVal
		mov ecx, pLock
Spin:
		// Trick from Intel Optimizations guide
#ifdef _CPU_SSE
		pause
#endif 
		mov eax, checkVal
		lock cmpxchg [ecx], edx
		jnz Spin
	}
# endif
#else
# if defined(PS3)
#  if defined(PS3_PROFILE_LOCKS)
	register int val, loop;
	__asm__ __volatile__ (
		"        li      %[loop], 0\n"
		"0:      lwarx   %[val], 0, %[pLock]\n"
		"        addi    %[loop], %[loop], 1\n"
		"        cmpw    %[checkVal], %[val]\n"
		"        bne-    0b\n"
		"        stwcx.  %[setVal], 0, %[pLock]\n"
		"        bne-    0b\n"
		: [val] "=&r" (val), "=m" (*pLock), [loop] "=&r" (loop)
		: [pLock] "r" (pLock), "m" (*pLock), "r" (loop),
			[checkVal] "r" (checkVal),
			[setVal] "r" (setVal)
		: "r0", "cc", "memory"
		);
	// Note: We're listing "r0" as clobbered to make sure r0 is not allocated
	// for %[loop] (otherwise the "addi" becomes "li").
	if (loop > 1)
	{
		g_nLockContentionCount += 1;
		g_nLockContentionCost += loop - 1;
	}
	g_nLockOpCount += 1;
#  else // PS3_PROFILE_LOCKS
/*#ifdef USE_INLINE_ASM
	register int val;
	__asm__ __volatile__ (
		".loop%=:															# loop start\n"
		" lwarx   %[val], 0, %[pLock]\n"
		" cmpw    %[checkVal], %[val]\n"
		"	beq-    .lockobtained%=						  # \n"	
		" db16cyc											        # give other hardware thread chance to run\n"
		" db16cyc											        # give other hardware thread chance to run\n"
		" db16cyc											        # give other hardware thread chance to run\n"
		" db16cyc											        # give other hardware thread chance to run\n"
		"	b    .loop%=											  # loop if lost reservation\n"	
		".lockobtained%=:											# lock obtained\n"
		" stwcx.  %[setVal], 0, %[pLock]\n"
		"	beq-    .exsuc%=										# check if write successful\n"	
		" db16cyc											        # give other hardware thread chance to run\n"
		" db16cyc											        # give other hardware thread chance to run\n"
		" db16cyc											        # give other hardware thread chance to run\n"
		" db16cyc											        # give other hardware thread chance to run\n"
		"	b    .loop%=											  # loop if lost reservation\n"	
		".exsuc%=:														# exchange written\n"
		: [val] "=&r" (val), "=m" (*pLock)
		: [pLock] "r" (pLock), "m" (*pLock),
		  [checkVal] "r" (checkVal),
		  [setVal] "r" (setVal)
		: "cc", "memory"
		);
#else
	while(CryInterlockedCompareExchange((volatile long*)pLock,setVal,checkVal)!=checkVal)
	{
		__add_db16cycl__
		__add_db16cycl__
		__add_db16cycl__
		__add_db16cycl__
		__add_db16cycl__
		__add_db16cycl__
		__add_db16cycl__
		__add_db16cycl__
	}
#endif
	*/
	while(CryInterlockedCompareExchange((volatile long*)pLock,setVal,checkVal)!=checkVal)
		Sleep(0);
#  endif // PS3_PROFILE_LOCKS
# else
	// NOTE: The code below will fail on 64bit architectures!
	while(_InterlockedCompareExchange((volatile long*)pLock,setVal,checkVal)!=checkVal) ;
# endif
#endif
#endif
}

ILINE void CryReleaseSpinLock(volatile int *pLock,int setVal)
{ 
  *pLock = setVal; 
}

//////////////////////////////////////////////////////////////////////////
ILINE void CryInterlockedAdd(volatile int *pVal, int iAdd)
{
#ifdef _CPU_X86
# ifdef __GNUC__
	__asm__ __volatile__ (
		"        lock add %[iAdd], (%[pVal])\n"
		: "=m" (*pVal)
		: [pVal] "r" (pVal), "m" (*pVal), [iAdd] "r" (iAdd)
		);
# else
	__asm
	{
		mov edx, pVal
		mov eax, iAdd
		lock add [edx], eax
	}
# endif
#else
# if defined(PS3)
#ifdef USE_INLINE_ASM
	register int val;
	__asm__ __volatile__ (
		".loop%=:															# loop start\n"
		" lwarx   %[val], 0, %[pVal]\n"
		" add     %[val], %[val], %[iAdd]\n"
		" stwcx.  %[val], 0, %[pVal]\n"
		"	beq-    .exsuc%=										# check if write successful\n"	
#ifdef ADD_DB16_CYCLES
		" db16cyc											        # give other hardware thread chance to run\n"
		" db16cyc											        # give other hardware thread chance to run\n"
		" db16cyc											        # give other hardware thread chance to run\n"
		" db16cyc											        # give other hardware thread chance to run\n"
#endif
		"	b    .loop%=											  # loop if lost reservation\n"	
		".exsuc%=:														# exchange written\n"
		: [val] "=&r" (val), "=m" (*pVal)
		: [pVal] "r" (pVal), "m" (*pVal),
			[iAdd] "r" (iAdd) 
		);
#else
	long tmp = __lwarx((volatile void*)pVal);
	while(0 == __stwcx((volatile void*)pVal, tmp + iAdd))
	{
		//give other hw thread time
		__add_db16cycl__
		__add_db16cycl__
		__add_db16cycl__
		__add_db16cycl__
		tmp = __lwarx((volatile void*)pVal);
	}
#endif
# else
	// NOTE: The code below will fail on 64bit architectures!
#ifdef XENON
	MemoryBarrier();
  InterlockedExchangeAdd((volatile long*)pVal,iAdd);
  MemoryBarrier();
#elif defined(_WIN64)
  _InterlockedExchangeAdd((volatile long*)pVal,iAdd);
#else
  InterlockedExchangeAdd((volatile long*)pVal,iAdd);
#endif
# endif
#endif
}

#endif //__SPU__

//special define to guard SPU driver compilation
#if !defined(JOB_LIB_COMP) && !defined(_SPU_JOB)

//////////////////////////////////////////////////////////////////////////
struct ReadLock
{
	ILINE ReadLock(volatile int &rw)
	{
		CryInterlockedAdd(prw=&rw,1);
#ifdef NEED_ENDIAN_SWAP
# ifdef PS3_PROFILE_LOCKS
		int loop = 0;
		volatile char *pw=(volatile char*)&rw+1; for(;*pw;) ++loop;
		if (loop > 0)
		{
			g_nLockContentionCount += 1;
			g_nLockContentionCost += loop;
		}
# else
		volatile char *pw=(volatile char*)&rw+1; for(;*pw;);
# endif
#else
		volatile char *pw=(volatile char*)&rw+2; for(;*pw;);
#endif
	}
	~ReadLock()
	{
		CryInterlockedAdd(prw,-1);
	}
private:
	volatile int *prw;
};

struct ReadLockCond
{
	ILINE ReadLockCond(volatile int &rw,int bActive)
	{
		if (bActive)
		{
			CryInterlockedAdd(&rw,1);
			bActivated = 1;
#ifdef NEED_ENDIAN_SWAP
# ifdef PS3_PROFILE_LOCKS
			int loop = 0;
			volatile char *pw=(volatile char*)&rw+1; for(;*pw;) ++loop;
			if (loop > 0)
			{
				g_nLockContentionCount += 1;
				g_nLockContentionCost += loop;
			}
# else
			volatile char *pw=(volatile char*)&rw+1; for(;*pw;);
# endif
#else
			volatile char *pw=(volatile char*)&rw+2; for(;*pw;);
#endif
		}
		else
		{
			bActivated = 0;
		}
		prw = &rw; 
	}
	void SetActive(int bActive=1) { bActivated = bActive; }
	void Release() { CryInterlockedAdd(prw,-bActivated); }
	~ReadLockCond()
	{
		CryInterlockedAdd(prw,-bActivated);
	}

private:
	volatile int *prw;
	int bActivated;
};

//////////////////////////////////////////////////////////////////////////
struct WriteLock
{
	ILINE WriteLock(volatile int &rw) { CrySpinLock(&rw,0,WRITE_LOCK_VAL); prw=&rw; }
	~WriteLock() { CryInterlockedAdd(prw,-WRITE_LOCK_VAL); }
private:
	volatile int *prw;
};

//////////////////////////////////////////////////////////////////////////
struct WriteAfterReadLock
{
	ILINE WriteAfterReadLock(volatile int &rw) { CrySpinLock(&rw,1,WRITE_LOCK_VAL+1); prw=&rw; }
	~WriteAfterReadLock() { CryInterlockedAdd(prw,-WRITE_LOCK_VAL); }
private:
	volatile int *prw;
};

//////////////////////////////////////////////////////////////////////////
struct WriteLockCond
{
	ILINE WriteLockCond(volatile int &rw,int bActive=1)
	{
		if (bActive)
			CrySpinLock(&rw,0,iActive=WRITE_LOCK_VAL);
		else 
			iActive = 0;
		prw = &rw; 
	}
	~WriteLockCond() { CryInterlockedAdd(prw,-iActive); }
	void SetActive(int bActive=1) { iActive = -bActive & WRITE_LOCK_VAL; }
	void Release() { CryInterlockedAdd(prw,-iActive); }
private:
	volatile int *prw;
	int iActive;
};

#endif//JOB_LIB_COMP
#endif // __MultiThread_h__
