////////////////////////////////////////////////////////////////////////////
//
//  Crytek Engine Source File.
//  Copyright (C), Crytek Studios, 2002.
// -------------------------------------------------------------------------
//  File name:   PS3CryCache.h
//  Version:     v1.00
//  Created:     02/02/2007 by Michael Glueck.
//  Compilers:   Visual Studio.NET
//  Description: Software Cache spiecific definitions
// -------------------------------------------------------------------------
//  History:
//
////////////////////////////////////////////////////////////////////////////

#ifndef _CRY_CACHE_H_
#define _CRY_CACHE_H_
#pragma once

#if defined(__SPU__)

	#define CELL_GCM_MEMCPY memcpy
	struct CellGcmContextData;
	struct CellGcmSPUData;
	struct _CGprogram;
	struct _CGpaparameter;

#if defined __CRYCG__
	#define __CRYCG_NOINLINE__ __attribute__ ((crycg_attr ("noinline")))
	#if defined __cplusplus
		#if !defined SPU_MAIN_PTR
			template <typename T>
			__CRYCG_NOINLINE__ T *__spu_main_ptr(T *ptr) { return ptr; } 
			#define SPU_MAIN_PTR(PTR) __spu_main_ptr((PTR)) 
		#endif 
		#if !defined SPU_MAIN_REF 
			template <typename T> 
			__CRYCG_NOINLINE__ T &__spu_main_ref(T &ref) { return ref; } 
			#define SPU_MAIN_REF(REF) __spu_main_ref((REF)) 
		#endif 
		#if !defined SPU_LOCAL_PTR 
			template <typename T> 
			__CRYCG_NOINLINE__ T *__spu_local_ptr(T *ptr) { return ptr; } 
			#define SPU_LOCAL_PTR(PTR) __spu_local_ptr((PTR)) 
		#endif 
		#if !defined SPU_LOCAL_REF 
			template <typename T> 
			__CRYCG_NOINLINE__ T &__spu_local_ref(T &ref) { return ref; } 
			#define SPU_LOCAL_REF(REF) __spu_local_ref((REF)) 
		#endif 
		#if !defined SPU_LINK_PTR 
			template <typename T, typename L> 
			__CRYCG_NOINLINE__ T *__spu_link_ptr(T *ptr, L *) { return ptr; } 
			template <typename T, typename L> 
			__CRYCG_NOINLINE__ T *__spu_link_ptr(T *ptr, L &) { return ptr; } 
			#define SPU_LINK_PTR(PTR, LINK) __spu_link_ptr((PTR), (LINK)) 
		#endif 
		#if !defined SPU_LINK_REF 
			template <typename T, typename L> 
			__CRYCG_NOINLINE__ T &__spu_link_ref(T &ref, L *) { return ref; } 
			template <typename T, typename L> 
			__CRYCG_NOINLINE__ T &__spu_link_ref(T &ref, L &) { return ref; } 
			#define SPU_LINK_REF(REF, LINK) __spu_link_ref((PTR), (LINK)) 
		#endif 
	#endif /* __cplusplus */
	#if !defined SPU_DOMAIN_MAIN
		#define SPU_DOMAIN_MAIN __attribute__ ((crycg_domain ("MAIN"))) 
	#endif 
	#if !defined SPU_DOMAIN_LOCAL 
		#define SPU_DOMAIN_LOCAL __attribute__ ((crycg_domain ("LOCAL"))) 
	#endif 
	#if !defined SPU_DOMAIN_LINK 
		#define SPU_DOMAIN_LINK(ID) __attribute__ ((crycg_domain (ID))) 
	#endif
	#ifndef SPU_DRIVER
		#define SPU_DRIVER(...) __attribute__ ((crycg_attr (driver, #__VA_ARGS__)))
  #endif
  #if !defined SPU_VERBATIM_BLOCK
    extern void __spu_verbatim_code(const char* code);
    #define SPU_VERBATIM_BLOCK(X) __spu_verbatim_code(X)
  #endif 
  #if !defined SPU_FRAME_PROFILER
    extern void __spu_profile_section_begin(const char*) __CRYCG_PRESERVE__; 
    extern void __spu_profile_section_end(const char*) __CRYCG_PRESERVE__; 
    #define SPU_PROFILER_CONCATID(ID1,ID2)  ID1 ## ID2
    #define SPU_PROFILER_MAKEID(ID,COUNTER)  SPU_PROFILER_CONCATID(ID,COUNTER)
    #define SPU_FRAME_PROFILER(X)						\
    struct SPU_PROFILER_MAKEID(__spu_profile_section_block,__LINE__) {	\
      ILINE SPU_PROFILER_MAKEID(__spu_profile_section_block,__LINE__) () { \
	__spu_profile_section_begin(X); }				\
      ILINE ~ SPU_PROFILER_MAKEID(__spu_profile_section_block,__LINE__) () {	\
	__spu_profile_section_end(X); }					\
    } SPU_PROFILER_MAKEID(__profile_block,__LINE__); 
  #endif
#else
  #ifndef SPU_DRIVER
		#define SPU_DRIVER(...)
	#endif
#endif /* __CRYCG__ */
	#if !defined(_SPU_JOB) && !defined(JOB_LIB_COMP)
		#define CELL_GCM_BUILD_SYS
		typedef uint32_t uint32;
		SPU_DRIVER() void SPUAddCacheWriteRangeAsync(uint32_t, uint32_t);
    #define __cache_range_write_async(cpFrom, cpTo) SPUAddCacheWriteRangeAsync((uint32_t)(cpFrom), (uint32_t)(cpTo))
		#define __spu_cache_range_write_async(cpFrom, cpTo) SPUAddCacheWriteRangeAsync((uint32_t)(cpFrom), (uint32_t)(cpTo))
		SPU_DRIVER() int CryInterlockedAdd(int volatile*, const int, const bool = false);
		SPU_DRIVER() int CryInterlockedIncrement(int volatile*);
		SPU_DRIVER() int CryInterlockedDecrement(int volatile*);
		SPU_DRIVER() void CrySpinLock(volatile int*, int, int, const bool = false, const bool = true);
		SPU_DRIVER() void CryReleaseSpinLock(volatile int*, int);
		SPU_DRIVER() void __spu_dma_pref(const uint32);
		SPU_DRIVER() void __spu_dma_pref_inl(const uint32);
		SPU_DRIVER(invalidate) void __spu_flush_cache_range(const uint32, const uint32);
		SPU_DRIVER(invalidate) void __spu_flush_cache_line(const uint32);
		SPU_DRIVER(invalidate) void __spu_invalidate_cache_line(const uint32);
		SPU_DRIVER(invalidate) void __spu_invalidate_cache_range(const uint32, const uint32);
		SPU_DRIVER() void __spu_zero_mem16_no_cache_no_sync(void *const __restrict);
		SPU_DRIVER() void __spu_zero_mem_no_cache_no_sync(void *const __restrict, unsigned int, bool, unsigned int);
		SPU_DRIVER() void __spu_invalidate_cache_prefetches();
		SPU_DRIVER(invalidate) void __spu_flush_cache();
		SPU_DRIVER(return(L)) CellGcmSPUData* GetGcmSPUData();
		extern "C" {
    #if !defined CRYCG_CM
			SPU_DRIVER() void abort();
    #endif
			SPU_DRIVER() void __spu_microsleep(const uint32);
		}
		SPU_DRIVER() void __spu_exec_ppu_call(const uint32, const uint32);
    inline void __spu_exec_ppu_call(const void* a, const uint32_t b) { 	__spu_exec_ppu_call((uint32_t)a, (uint32_t)b);}
		SPU_DRIVER() uint32_t GetCurrentThreadId();
		SPU_DRIVER(return(L)) void* __spu_get_atomic_buffer();
		SPU_DRIVER() void __spu_load_atomic_cacheline(const void *, void*, const bool = true);
		SPU_DRIVER() int __spu_try_put_atomic_cacheline();
		SPU_DRIVER(return(L)) uint8_t* cellGcmGetPSBuf();
		SPU_DRIVER(return(L)) uint8_t* cellGcmGetVSBuf();
		SPU_DRIVER() uint32 CryInterlockedCompareExchange(volatile uint32*, uint32, uint32, const bool = false);
		SPU_DRIVER(return[MXX](M), return[LXX](L)) void* CryInterlockedCompareExchangePointer(void* volatile *, void*, void*, const bool = false);
		SPU_DRIVER() int CryInterlockedExchange(volatile uint32*, uint32, const bool = false, const bool = true);
		SPU_DRIVER() unsigned int __spu_recursive_lock(unsigned int *, unsigned int, unsigned int, unsigned int, unsigned int, const bool = true);
		SPU_DRIVER() int __spu_recursive_unlock(int *, int, int, int, const bool = true);
		SPU_DRIVER() unsigned int __spu_recursive_spinlock(unsigned int *, unsigned int, unsigned int, unsigned int, unsigned int, const bool = true);
		SPU_DRIVER(return(L)) void *__spu_load_atomic_buffer(void*);
		SPU_DRIVER(missing[L]) int __spu_wait_unequal(int *, int, const bool = false, const bool = true);
		SPU_DRIVER(missing[L]) void __spu_wait_equal(int *, int, const bool = false);
		SPU_DRIVER(missing[L]) uint32 __spu_timed_wait_unequal(const unsigned int, int*, int, const bool = false, const bool = true);
		extern const int IsDebugEnabled();
		SPU_DRIVER(invalidate) void cellGcmFlush();
		SPU_DRIVER(invalidate) uint64 cellGcmSyncToRSX(const uint64, uint32&, bool, bool, const int);
		SPU_DRIVER(missing[LX], missing[ML]) int32_t cellGcmAddressToOffset(const void*, uint32_t *__restrict);
		SPU_DRIVER() void cellGcmUpdateGlobalPPUContext();
		struct CellGcmLocalContextData;
		SPU_DRIVER() void cellGcmInitLocalGcmContext(CellGcmLocalContextData *__restrict*, CellGcmSPUData *__restrict, uint8_t *__restrict, const uint32_t, uint8_t *__restrict, const uint32_t, uint8_t *__restrict, const uint32_t);
		SPU_DRIVER(missing[LM], missing[ML], missing[MM]) void cellGcmMemCpy(void* const __restrict, const void* const __restrict,const unsigned int );
		SPU_DRIVER(return(L)) uint8_t* cellGcmCpyUCodeLS(void* const __restrict, const unsigned int, const unsigned int);
		SPU_DRIVER() void cellGcmCpySyncVertexCode();
		SPU_DRIVER() void cellGcmSyncTransferToMain();
		SPU_DRIVER(return(L)) uint8* cellGcmCpyVertexCodeLS(void* const __restrict, const unsigned int, const unsigned int);
		SPU_DRIVER() void cellGcmCpyUCodeMain(void* const __restrict, const void* const __restrict, const unsigned int);
		SPU_DRIVER() void cellGcmCpyUCodeMainFromLS(void* const __restrict, const void* const __restrict, const unsigned int);
		SPU_DRIVER() int cellGcmSetFlip(const uint8_t);
		SPU_DRIVER() unsigned int RSXLocalAddress();
		SPU_DRIVER() void cellGcmSetVertexProgram(const uint32_t*, const void * __restrict);
		struct CellGcmSurface;
		SPU_DRIVER() void cellGcmSetSurfaceWindow(const CellGcmSurface*, const uint32_t, const uint32_t);
		SPU_DRIVER() void cellGcmSetVertexDataArray(uint8_t index, uint16_t frequency, uint8_t stride, uint8_t size, uint8_t type, uint8_t location, uint32_t offset);
		SPU_DRIVER() unsigned long long cellGcmGetTimeStampLocation(const unsigned int);
		SPU_DRIVER() void __spu_unregister_job();
		SPU_DRIVER() void __spu_cleanup_memory();
		SPU_DRIVER() unsigned int rdtsc();
		SPU_DRIVER() void __spu_reset_timer();
		SPU_DRIVER() void __spu_toggle_ppu_callback(void*, void*);
		SPU_DRIVER() void __spu_transfer_func_prof_stats();
		SPU_DRIVER() void __spu_dump_prof_stats();
		SPU_DRIVER() void __spu_reset_prof_stats();
		SPU_DRIVER() void cellGcmAddRSXWaitTicks(const unsigned int, const unsigned int);
		SPU_DRIVER() void cellGcmAddPerfTicks0(const unsigned int);
		SPU_DRIVER() void cellGcmAddPerfTicks1(const unsigned int);
		SPU_DRIVER() void cellGcmAddPerfTicks2(const unsigned int);
		SPU_DRIVER() void cellGcmAddPerfTicks3(const unsigned int);
		SPU_DRIVER() void cellGcmAddRSXStallTicks(const unsigned int, const unsigned int);
		SPU_DRIVER() uint32 cellGcmGetAndResetPerfTicks0();
		SPU_DRIVER() uint32 cellGcmGetAndResetPerfTicks1();
		SPU_DRIVER() uint32 cellGcmGetAndResetPerfTicks2();
		SPU_DRIVER() uint32 cellGcmGetAndResetPerfTicks3();
		SPU_DRIVER() uint32 cellGcmGetAndResetRSXWaitTicks();
		SPU_DRIVER() void __spu_dma_to_main_no_cache_no_sync(void *const __restrict, const void* __restrict, const unsigned int);
		SPU_DRIVER() void __spu_sync_dma_no_cache_no_sync();
		SPU_DRIVER() void __spu_dma_to_ls_no_cache_no_sync(void* const __restrict, const void *const __restrict, const unsigned int);
		SPU_DRIVER() void cellGcmSyncUCodeLS();
		SPU_DRIVER() void __spu_transfer_frame_stats(const unsigned int);
		SPU_DRIVER() uint32 __spu_get_current_id();
		SPU_DRIVER() void cellGcmSetWaitFlip();
		SPU_DRIVER() void __spu_set_dabr(const uint32_t);
		SPU_DRIVER() void __spu_check_dabr();
		SPU_DRIVER(invalidate) void __spu_cache_barrier();
		SPU_DRIVER() void __spu_set_dabr_ppu(const unsigned int);
		SPU_DRIVER() void memtransfer_from_main(void*, const void*, const unsigned int, const unsigned int);
		SPU_DRIVER() void memtransfer_to_main(void*, const void*, const unsigned int, const unsigned int);
		SPU_DRIVER() void memtransfer_from_main_fenced(void*, const void*, const unsigned int, const unsigned int);
		SPU_DRIVER() void memtransfer_to_main_fenced(void*, const void*, const unsigned int, const unsigned int);
		SPU_DRIVER() bool memtransfer_pending(const unsigned int);
		SPU_DRIVER() void memtransfer_sync(const unsigned int);
		SPU_DRIVER(return(L)) void* alloca(const unsigned int);
		SPU_DRIVER(missing[L]) void memset_large_nocache_128(void*, unsigned int, unsigned int);

		namespace std
		{
			SPU_DRIVER(invalidate[MM], return[MX](M), return[LX](L)) void *memcpy(void *, const void *, size_t);
			SPU_DRIVER(invalidate[MM], return[MX](M), return[LX](L)) void *memmove(void *, const void *, size_t);
			SPU_DRIVER(invalidate[M], return[M](M), return[L](L)) void *memset(void *, int, size_t);
			SPU_DRIVER(return(M)) void *malloc(size_t);
			SPU_DRIVER(return(M)) void *calloc(size_t,size_t);
			SPU_DRIVER(return(M)) void *realloc(void *, size_t);
			SPU_DRIVER(missing[L]) void free(void *);
			SPU_DRIVER(return(M), missing[L]) void* memalign(size_t, size_t);
			SPU_DRIVER(return(M), missing[L]) void* reallocalign(void*, size_t, size_t);

			SPU_DRIVER(invalidate, return(M)) void *CryModuleMalloc(size_t);
			SPU_DRIVER(invalidate, return(M)) void *CryModuleMalloc(size_t, ECryModule);
			SPU_DRIVER(invalidate, return(M)) void *CryModuleCalloc(size_t,size_t);
			SPU_DRIVER(invalidate, return(M)) void *CryModuleCalloc(size_t, size_t,ECryModule);
			SPU_DRIVER(invalidate, return(M), missing[L]) void *CryModuleRealloc(void *, size_t);
			SPU_DRIVER(invalidate, return(M), missing[L]) void *CryModuleRealloc(void *, size_t, ECryModule);
			SPU_DRIVER(invalidate, missing[L]) void CryModuleFree(void *);
			SPU_DRIVER(invalidate, missing[L]) void CryModuleFree(void *, ECryModule);

			SPU_DRIVER(invalidate, return(M)) void *CryMemAlign(size_t, size_t);
			SPU_DRIVER(invalidate, return(M)) void *CryModuleMemalign(size_t, size_t);
			SPU_DRIVER(invalidate, return(M)) void *CryModuleMemalign(size_t, size_t, ECryModule);
			SPU_DRIVER(invalidate, missing[L]) void CryModuleMemalignFree(void *);
			SPU_DRIVER(invalidate, missing[L]) void CryModuleMemalignFree(void *, ECryModule);
		}


		using std::CryModuleMalloc;
		using std::CryModuleRealloc;
		using std::CryModuleFree;
		using std::CryModuleCalloc;
		using std::CryMemAlign;
		using std::CryModuleMemalign;
		using std::CryModuleMemalignFree;

    using std::malloc;
    using std::free; 
    using std::calloc; 
    using std::realloc;

		#define gCellGcmCurrentContext thisContext
	#endif//_SPU_JOB
#endif //__SPU__

#if !defined __CRYCG__
	#define __CRYCG_NOINLINE__
	#if defined __cplusplus
		#if !defined SPU_MAIN_PTR
			#define SPU_MAIN_PTR(PTR) (PTR)
		#endif
		#if !defined SPU_MAIN_REF
			#define SPU_MAIN_REF(REF) (REF)
		#endif
		#if !defined SPU_LOCAL_PTR
			#define SPU_LOCAL_PTR(PTR) (PTR)
		#endif
		#if !defined SPU_LOCAL_REF
			#define SPU_LOCAL_REF(REF) (REF)
		#endif
		#if !defined SPU_LINK_PTR
			#define SPU_LINK_PTR(PTR, LINK) (PTR)
		#endif
		#if !defined SPU_LINK_REF
			#define SPU_LINK_REF(REF, LINK) (PTR)
		#endif
	#endif /* __cplusplus */
	#if !defined SPU_DOMAIN_MAIN
		#define SPU_DOMAIN_MAIN
	#endif
	#if !defined SPU_DOMAIN_LOCAL
		#define SPU_DOMAIN_LOCAL
	#endif
	#if !defined SPU_DOMAIN_LINK
		#define SPU_DOMAIN_LINK(ID)
	#endif
  #if !defined SPU_VERBATIM_BLOCK
    #define SPU_VERBATIM_BLOCK(X) ((void)0)
  #endif 
  #if !defined SPU_FRAME_PROFILER
		#define SPU_FRAME_PROFILER(X){}
  #endif
#endif /* __CRYCG__ */

#if defined(PS3) && !defined(__CRYCG_NOINLINE__)
# define __CRYCG_NOINLINE__ 
#endif
#if defined(PS3) && !defined(__CRYCG_PRESERVE__)
# define __CRYCG_PRESERVE__ 
#endif

//prefix of code generator referring to page names (later replaced by IDs)
#define PAGE_PREFIX "__spu_page_id_"
#define DECL_PAGE(a) extern vec_uchar16 __spu_page_id_##a;
#define PAGE_ID(a) __spu_page_id_##a

#define PAGE_CROSS_CALL_PREFIX "__spu_page_fnct_id_"
#define DECL_PAGE_CROSS_CALL(a) extern vec_ushort8 __spu_page_fnct_id_##a;
#define CROSS_CALL_ID(a) __spu_page_fnct_id_##a

#define PAGE_EXT_LIB_CALL_PREFIX "__spu_page_ext_lib_id_"
#define DECL_PAGE_EXT_LIB_CALL(a) extern vec_ushort8 __spu_page_ext_lib_id_##a;
#define EXT_LIB_CALL_ID(a) __spu_page_ext_lib_id_##a

#define PAGE_FUNC_PTR_CALL_PREFIX "__spu_page_fnct_ptr_"

#define SPU_JOB_VAR_PREFIX "__spu_global_job_var_"

//separator for ::
#define GLOB_VAR_SEP "__S"
#define GLOB_VAR_PREFIX "__spu_global_var_"

#if defined(__SPU__)
	//the name space "::" must be replaced by __
	#define DECL_GLOB_VAR(a) extern int __spu_global_var_##a;
	#define RESOLVE_GLOB_VAR_ADDR(a) __cache_resolve_global_var_addr(__spu_global_var_##a)
	//also referenced in SPUFuncPtr.h
	#define DECL_SPU_JOB_VAR(a) extern int __spu_global_job_var_##a;
	#define DECL_SPU_JOB_CLASSVAR(a) static int __spu_global_job_var_##a;
	#define SPU_JOB_VAR(a) __spu_global_job_var_##a

#else

	#define DECL_GLOB_VAR(a)
	#define RESOLVE_GLOB_VAR_ADDR(a)

	#define DECL_SPU_JOB_VAR(a)
	#define SPU_JOB_VAR(a)

#endif//__SPU__

#endif //_CRY_CACHE_H_
