#include "ParticleParams.h"

STRUCT_INFO_BEGIN(RandomColor)
	VAR_INFO(m_VarRandom)
	VAR_INFO(m_bRandomHue)
STRUCT_INFO_END(RandomColor)

STRUCT_INFO_T_BEGIN(TVarParam, class, S)
	VAR_INFO(m_Base)
	VAR_INFO_ATTRS(m_VarRandom, ATTR_INFO(Inline,1))
STRUCT_INFO_T_END(TVarParam, class, S)

STRUCT_INFO_T_BEGIN(TVarEParam, class, S)
	BASE_INFO(TVarParam<S>)
	VAR_INFO(m_VarEmitterStrength)
STRUCT_INFO_T_END(TVarEParam, class, S)

STRUCT_INFO_T_BEGIN(TVarEPParam, class, S)
	BASE_INFO(TVarEParam<S>)
	VAR_INFO(m_VarParticleLife)
STRUCT_INFO_T_END(TVarEPParam, class, S)

STRUCT_INFO_BEGIN(STextureTiling)
	VAR_INFO_ATTRS(nTilesX, ATTR_INFO(Min,1) ATTR_INFO(Max,256))
	VAR_INFO_ATTRS(nTilesY, ATTR_INFO(Min,1) ATTR_INFO(Max,256))
	VAR_INFO(nFirstTile)
	VAR_INFO_ATTRS(nVariantCount, ATTR_INFO(Min,1) ATTR_INFO(Max,256))
	VAR_INFO_ATTRS(nAnimFramesCount, ATTR_INFO(Min,1) ATTR_INFO(Max,256))
	VAR_INFO_ATTRS(fAnimFramerate, ATTR_INFO(SoftMax,60))
	VAR_INFO(bAnimCycle)
	VAR_INFO(bAnimBlend)
STRUCT_INFO_END(STextureTiling)

ENUM_INFO_BEGIN(EParticleFacing)
	ENUM_ELEM_INFO(, ParticleFacing_Camera)
	ENUM_ELEM_INFO(, ParticleFacing_Free)
	ENUM_ELEM_INFO(, ParticleFacing_Velocity)
	ENUM_ELEM_INFO(, ParticleFacing_Horizontal)
	ENUM_ELEM_INFO(, ParticleFacing_Water)
	ENUM_ELEM_INFO(, ParticleFacing_Terrain)
	ENUM_ELEM_INFO(, ParticleFacing_Decal)
ENUM_INFO_END(EParticleFacing)

ENUM_INFO_BEGIN(EParticlePhysicsType)
	ENUM_ELEM_INFO(, ParticlePhysics_None)
	ENUM_ELEM_INFO(, ParticlePhysics_SimpleCollision)
	ENUM_ELEM_INFO(, ParticlePhysics_SimplePhysics)
	ENUM_ELEM_INFO(, ParticlePhysics_RigidBody)
ENUM_INFO_END(EParticlePhysicsType)

ENUM_INFO_BEGIN(EParticleForceType)
	ENUM_ELEM_INFO(, ParticleForce_None)
	ENUM_ELEM_INFO(, ParticleForce_Wind)
	ENUM_ELEM_INFO(, ParticleForce_Gravity)
	ENUM_ELEM_INFO(, ParticleForce_Target)
ENUM_INFO_END(EParticleForceType)

ENUM_INFO_BEGIN(ETrinary)
	ENUM_ELEM_INFO(, Trinary_Both)
	ENUM_ELEM_INFO(, Trinary_If_True)
	ENUM_ELEM_INFO(, Trinary_If_False)
ENUM_INFO_END(ETrinary)

ENUM_INFO_BEGIN(EConfigSpecBrief)
	ENUM_ELEM_INFO(, ConfigSpec_Low)
	ENUM_ELEM_INFO(, ConfigSpec_Medium)
	ENUM_ELEM_INFO(, ConfigSpec_High)
	ENUM_ELEM_INFO(, ConfigSpec_VeryHigh)
ENUM_INFO_END(EConfigSpecBrief)

ENUM_INFO_BEGIN(ESoundControlTime)
	ENUM_ELEM_INFO(, SoundControlTime_EmitterLifeTime)
	ENUM_ELEM_INFO(, SoundControlTime_EmitterExtendedLifeTime)
	ENUM_ELEM_INFO(, SoundControlTime_EmitterPulsePeriod)
ENUM_INFO_END(ESoundControlTime)

STRUCT_INFO_BEGIN(ParticleParams)
	VAR_INFO(bEnabled)
	VAR_INFO(bContinuous)
	VAR_INFO_ATTRS(fCount, ATTR_INFO(SoftMax,1000))
	VAR_INFO(fEmitterLifeTime)
	VAR_INFO_ATTRS(fSpawnDelay, ATTR_INFO(SoftMin,0))
	VAR_INFO(fPulsePeriod)
	VAR_INFO(fParticleLifeTime)
	VAR_INFO(bRemainWhileVisible)

	VAR_INFO_ATTRS(bSecondGeneration, ATTR_INFO(Group,Spawning))
	VAR_INFO(bSpawnOnParentCollision)
	VAR_INFO(eAttachType)
	VAR_INFO(eAttachForm)
	VAR_INFO(vPositionOffset)
	VAR_INFO(vRandomOffset)
	VAR_INFO(fPosRandomOffset)
	VAR_INFO(fMaxOverdraw)

	VAR_INFO_ATTRS(fFocusAngle, ATTR_INFO(Group,Angles) ATTR_INFO(Max,180))
	VAR_INFO_ATTRS(fFocusAzimuth, ATTR_INFO(SoftMax,360))
	VAR_INFO(bFocusGravityDir)
	VAR_INFO_ATTRS(fEmitAngle, ATTR_INFO(Max,180))

	VAR_INFO_ATTRS(sSound, ATTR_INFO(Group,Sound))
	VAR_INFO(fSoundFXParam)
	VAR_INFO(eSoundControlTime)

	VAR_INFO_ATTRS(eFacing, ATTR_INFO(Group,Appearance))
	VAR_INFO(bOrientToVelocity)
	VAR_INFO(eBlendType)
	VAR_INFO(sTexture)
	VAR_INFO(bTextureUnstreamable)
	VAR_INFO(TextureTiling)
	VAR_INFO(sMaterial)
	VAR_INFO(sGeometry)
	VAR_INFO(bGeometryInPieces)
	VAR_INFO(bGeometryUnstreamable)
	VAR_INFO(bSoftParticle)
	VAR_INFO(bOceanParticle)
	VAR_INFO(fAlpha)
	VAR_INFO(cColor)

	VAR_INFO_ATTRS(fDiffuseLighting, ATTR_INFO(Group,Lighting) ATTR_INFO(SoftMax,1))
	VAR_INFO(fDiffuseBacklighting)
	VAR_INFO_ATTRS(fEmissiveLighting, ATTR_INFO(SoftMax,1))
	VAR_INFO_ATTRS(fEmissiveHDRDynamic, ATTR_INFO(SoftMin,-2) ATTR_INFO(SoftMax,2))
	VAR_INFO(bReceiveShadows)
	VAR_INFO(bCastShadows)
	VAR_INFO(bGlobalIllumination)
	VAR_INFO(LightSource)

	VAR_INFO_ATTRS(fSize, ATTR_INFO(Group,Size) ATTR_INFO(SoftMax,10))
	VAR_INFO_ATTRS(fStretch, ATTR_INFO(SoftMax,10))
	VAR_INFO_ATTRS(fTailLength, ATTR_INFO(SoftMax,10))
	VAR_INFO_ATTRS(fMinPixels, ATTR_INFO(SoftMax,10))

	VAR_INFO(Connection)

	VAR_INFO_ATTRS(fSpeed, ATTR_INFO(Group,Movement))
	VAR_INFO_ATTRS(fInheritVelocity, ATTR_INFO(SoftMin,0) ATTR_INFO(SoftMax,1))
	VAR_INFO_ATTRS(fAirResistance, ATTR_INFO(SoftMax,10))
	VAR_INFO_ATTRS(fRotationalDragScale, ATTR_INFO(SoftMax,1))
	VAR_INFO_ATTRS(fGravityScale, ATTR_INFO(SoftMin,0) ATTR_INFO(SoftMax,1))
	VAR_INFO(vAcceleration)
	VAR_INFO_ATTRS(fTurbulence3DSpeed, ATTR_INFO(SoftMax,10))
	VAR_INFO_ATTRS(fTurbulenceSize, ATTR_INFO(SoftMax,10))
	VAR_INFO_ATTRS(fTurbulenceSpeed, ATTR_INFO(SoftMin,-360) ATTR_INFO(SoftMax,360))

	VAR_INFO(TargetAttraction)

	VAR_INFO_ATTRS(vInitAngles, ATTR_INFO(Group,Rotation) ATTR_INFO(SoftMin,-180) ATTR_INFO(SoftMax,180))
	VAR_INFO_ATTRS(vRandomAngles, ATTR_INFO(Max,180))
	VAR_INFO_ATTRS(vRotationRate, ATTR_INFO(SoftMin,-360) ATTR_INFO(SoftMax,360))
	VAR_INFO_ATTRS(vRandomRotationRate, ATTR_INFO(SoftMax,360))

	VAR_INFO_ATTRS(ePhysicsType, ATTR_INFO(Group,Collision))
	VAR_INFO(bCollideTerrain)
	VAR_INFO(bCollideStaticObjects)
	VAR_INFO(bCollideDynamicObjects)
	VAR_INFO_ATTRS(sSurfaceType, ATTR_INFO(Select,Surface))
	VAR_INFO_ATTRS(fBounciness, ATTR_INFO(SoftMin,0) ATTR_INFO(SoftMax,1))
	VAR_INFO_ATTRS(fDynamicFriction, ATTR_INFO(SoftMax,10))
	VAR_INFO_ATTRS(fThickness, ATTR_INFO(SoftMax,1))
	VAR_INFO_ATTRS(fDensity, ATTR_INFO(SoftMax,2000))
	VAR_INFO_ATTRS(nMaxCollisionEvents, ATTR_INFO(SoftMax,8))

	VAR_INFO_ATTRS(bBindEmitterToCamera, ATTR_INFO(Group,Visibility))
	VAR_INFO(bMoveRelEmitter)
	VAR_INFO(bSpaceLoop)
	VAR_INFO_ATTRS(fCameraMaxDistance, ATTR_INFO(SoftMax,100))
	VAR_INFO_ATTRS(fCameraMinDistance, ATTR_INFO(SoftMax,100))
	VAR_INFO_ATTRS(fViewDistanceAdjust, ATTR_INFO(SoftMax,1))

	VAR_INFO_ATTRS(nDrawLast, ATTR_INFO(Min,-100) ATTR_INFO(Max,100)  )
	VAR_INFO(tVisibleIndoors)
	VAR_INFO(tVisibleUnderwater)

	VAR_INFO_ATTRS(eForceGeneration, ATTR_INFO(Group,Advanced))
	VAR_INFO_ATTRS(fFillRateCost, ATTR_INFO(SoftMax,10))
	VAR_INFO_ATTRS(fMotionBlurScale, ATTR_INFO(SoftMax,2))
	VAR_INFO(bNotAffectedByFog)
	VAR_INFO(bDrawNear)
	VAR_INFO(bNoOffset)
	VAR_INFO(bEncodeVelocity)

	VAR_INFO_ATTRS(eConfigMin, ATTR_INFO(Group,Configuration))
	VAR_INFO(eConfigMax)
	VAR_INFO(tDX11)
	VAR_INFO(tGPUComputation)
STRUCT_INFO_END(ParticleParams)

STRUCT_INFO_BEGIN(ParticleParams::SLightSource)
	VAR_INFO_ATTRS(fRadius, ATTR_INFO(SoftMax,8))
	VAR_INFO_ATTRS(fIntensity, ATTR_INFO(SoftMax,16))
	VAR_INFO_ATTRS(fHDRDynamic, ATTR_INFO(SoftMin,-2) ATTR_INFO(SoftMax,2))
STRUCT_INFO_END(ParticleParams::SLightSource)

STRUCT_INFO_BEGIN(ParticleParams::SConnection)
	VAR_INFO(bConnectParticles)
	VAR_INFO(bConnectToOrigin)
	VAR_INFO(bFluidTexture)
	VAR_INFO(fTextureFrequency)
STRUCT_INFO_END(ParticleParams::SConnection)

STRUCT_INFO_BEGIN(ParticleParams::STargetAttraction)
	VAR_INFO(bIgnore)
	VAR_INFO(bExtendSpeed)
	VAR_INFO(bShrink)
	VAR_INFO(bOrbit)
	VAR_INFO(fOrbitDistance)
STRUCT_INFO_END(ParticleParams::STargetAttraction)

STRUCT_INFO_BEGIN(ParticleParams::SStretch)
	BASE_INFO_ATTRS(TVarEPParam<UFloat16>, ATTR_INFO(SoftMax,10))
	VAR_INFO_ATTRS(fOffsetRatio, ATTR_INFO(SoftMin,-1) ATTR_INFO(SoftMax,1))
STRUCT_INFO_END(ParticleParams::SStretch)

STRUCT_INFO_BEGIN(ParticleParams::STailLength)
	BASE_INFO_ATTRS(TVarEPParam<UFloat16>, ATTR_INFO(SoftMax,10))
	VAR_INFO_ATTRS(nTailSteps, ATTR_INFO(SoftMax,16))
STRUCT_INFO_END(ParticleParams::STailLength)
