////////////////////////////////////////////////////////////////////////////
//
//  Crytek Engine Source File.
//  Copyright (C), Crytek Studios, 2002.
// -------------------------------------------------------------------------
//  File name:   ProjectDefines.h
//  Version:     v1.00
//  Created:     3/30/2004 by MartinM.
//  Compilers:   Visual Studio.NET
//  Description: to get some defines available in every CryEngine project 
// -------------------------------------------------------------------------
//  History:
//    July 20th 2004 - Mathieu Pinard
//    Updated the structure to handle more easily different configurations
//
////////////////////////////////////////////////////////////////////////////

#ifndef PROJECTDEFINES_H
#define PROJECTDEFINES_H

#if !defined GAME_IS_TECHDEMO
#	if defined(LINUX)
#		define EXCLUDE_SCALEFORM_SDK
#		define EXCLUDE_CRI_SDK
#		define EXCLUDE_GPU_PARTICLE_PHYSICS
# elif defined(XENON)
//#		define EXCLUDE_SCALEFORM_SDK
#		define EXCLUDE_CRI_SDK
#		define EXCLUDE_GPU_PARTICLE_PHYSICS
#	if !defined(_RELEASE)
#		define ENABLE_STATS_AGENT
#	endif
# elif defined(PS3)
//#		define EXCLUDE_PHYSICS_THREAD
//#		define EXCLUDE_SCALEFORM_SDK
#		define EXCLUDE_CRI_SDK
#		define EXCLUDE_GPU_PARTICLE_PHYSICS
#	if !defined(_RELEASE)
#		define ENABLE_STATS_AGENT
#	endif
# elif defined(WIN32) && defined(WIN64)
//#		define EXCLUDE_SCALEFORM_SDK
//#		define EXCLUDE_CRI_SDK
#		define EXCLUDE_GPU_PARTICLE_PHYSICS
# else
//#		define EXCLUDE_SCALEFORM_SDK
//#		define EXCLUDE_CRI_SDK
#		define EXCLUDE_GPU_PARTICLE_PHYSICS
#	endif
#endif

// For the Tech Demo, many third party library are disabled and we also disable DATAPROBE
#if defined GAME_IS_TECHDEMO
#	define EXCLUDE_SCALEFORM_SDK
#	define EXCLUDE_BINK_SDK
#	define EXCLUDE_CRI_SDK
#	define EXCLUDE_GPU_PARTICLE_PHYSICS
#endif

// see http://wiki/bin/view/CryEngine/TerrainTexCompression for more details on this
// 0=off, 1=on
#define TERRAIN_USE_CIE_COLORSPACE 0

// for consoles every bit of memory is important so files for documentation purpose are excluded
// they are part of regular compiling to verify the interface
#if defined(PS3) || defined(XENON)
#	define EXCLUDE_DOCUMENTATION_PURPOSE
#endif

#if defined(PS3) && !defined(_DEBUG)
//#	define EXCLUDE_NORMAL_LOG
#	define EXCLUDE_CVARHELP
#endif

#define EXCLUDE_UNIT_TESTS	0	
#ifdef RELEASE
#undef EXCLUDE_UNIT_TESTS
#define EXCLUDE_UNIT_TESTS	1
#endif

#if (defined(XENON) && !defined(_LIB)) || defined(WIN32)
  #define CAPTURE_REPLAY_LOG 1
#endif

#define OLD_VOICE_SYSTEM_DEPRECATED
//#define INCLUDE_PS3PAD
#define EXCLUDE_SCALEFORM_SDK
#define EXCLUDE_CRI_SDK

#ifdef PS3
  #ifdef ENABLE_MEMREPLAY
    #define CAPTURE_REPLAY_LOG 1
  #endif
  #if defined(JOB_LIB_COMP) || defined(__SPU__)
    #undef CAPTURE_REPLAY_LOG
  #endif
#endif

#if !defined(NOT_USE_CRY_MEMORY_MANAGER)
  // No replay functionality without the memory manager.
  #if CAPTURE_REPLAY_LOG
    #define MALLOC_DUMMY_WRAP 1
  #endif
  #undef CAPTURE_REPLAY_LOG
#endif

#ifdef CRYTEK_SDK_EVALUATION
//#	define USING_UNIKEY_SECURITY				// Wrapper for UniKey dongle management and security code
#	define USING_TAGES_SECURITY					// Wrapper for TGVM security
#	define USING_LICENSE_PROTECTION			// Wrapper for License Server protection
#endif

#if defined(RESOURCE_COMPILER) || defined(_RELEASE)
  #undef CAPTURE_REPLAY_LOG
#endif

#ifndef CAPTURE_REPLAY_LOG
  #define CAPTURE_REPLAY_LOG 0
#endif

#if (defined(XENON) || defined(PS3)) && defined(USING_LICENSE_PROTECTION)
#undef USING_LICENSE_PROTECTION
#undef USING_TAGES_SECURITY
#endif

#ifdef USING_TAGES_SECURITY
#	define TAGES_EXPORT __declspec(dllexport)
#else 
#	define TAGES_EXPORT
#endif // USING_TAGES_SECURITY


// test -------------------------------------
//#define EXCLUDE_CVARHELP

#define _DATAPROBE


#if defined(XENON) && defined(_RELEASE) && !defined(ENABLE_PROFILERS)
#define PURE_XENON_RELEASE
#undef ENABLE_FRAME_PROFILER
#endif


#include "ProjectDefinesInclude.h"

#endif // PROJECTDEFINES_H
