////////////////////////////////////////////////////////////////////////////
//
//  CryEngine Source File.
//  Copyright (C), Crytek.
// -------------------------------------------------------------------------
//  File name:   SysCallThread_PS3.h
//  Created:     22/03/2010 by Alex Weighell.
//  Description:
//  	This is a shared thread for PS3 operating system utilities that
//  	need to be on their own thread:
//
//   	Trophies, savedata, gamedata etc.
// -------------------------------------------------------------------------
//  History:
//
////////////////////////////////////////////////////////////////////////////

#ifndef __SYS_CALL_THREAD_H__
#define __SYS_CALL_THREAD_H__

#if defined(PS3)

#include <sys/types.h>

class CSysCallThread
{
public:	
	typedef void (*Handler)(uint64 eventId, uint64 data1, uint64 data2);
	typedef sys_event_port_t TEvent;	// Last time I checked sys_event_port_t was typedef'd to a uint32

	// QueueEvent:
	//   Queues up an 'event'. The 'event' id is obtained from RegisterHandler. The parameters
	//   'eventType', 'data1' and 'data2' are all user defined and passed through to the Handler callback.
	void 										QueueEvent(TEvent event, uint64 eventType, uint64 data1, uint64 data2);
	
	// RegisterHandler:
	//   Register an event handler 'callback'. The event id is returned and used for calling QueueEvent.
	//   Note: 'callback' must be multi-thread safe since it is executed on the SysProcessingThread.
	TEvent									RegisterHandler(Handler callback);
													CSysCallThread();
													~CSysCallThread();
protected:
	static void							SysProcessingThread(uint64 arg);

	sys_ppu_thread_t			  m_thread;
	sys_event_queue_t		    m_queue;
	TEvent									m_terminateEvent;
	volatile bool			    	m_threadHasStarted;
};

#endif // defined(PS3)

#endif // __SYS_CALL_THREAD_H__

