/********************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2006-2008.
---------------------------------------------------------------------
File name:   PS3PadWin.h
Description: JoyPad for PS3 in Windows
---------------------------------------------------------------------
History:
- 05:05:2008 : Created by Kevin Kirst

*********************************************************************/

#ifndef __PS3PADWIN_H__
#define __PS3PADWIN_H__

#if defined(USE_DXINPUT) && defined(INCLUDE_PS3PAD)

#include "InputDevice.h"
#include "libpad.h"
#include "PS3PadCommon.h"

class CPS3PadWin : public CInputDevice
{
public:
	CPS3PadWin(IInput& pInput, int deviceNo);
	virtual ~CPS3PadWin();

	// IInputDevice overrides
	virtual bool Init();
	virtual void Update(bool bFocus);
	virtual void ClearAnalogKeyState();
	virtual bool IsOfDeviceType( EInputDeviceType type ) const { return type == eIDT_Gamepad; }
	// ~IInputDevice overrides

	static bool InitLib();
	static void KillLib();

private:
	bool UpdateConnectionState(bool current);
	void ReadAxis(const CellPadData& crData);

	int m_deviceNo;			// device number (from 0 to CPS3Input::m_maxPads) for this device
	bool m_connected;
	int m_buttons[16];		//current 16 button values
	int m_buttonsLast[16];	//last updates 16 button values

	int m_xAxis[3];			//x-axis values
	int m_yAxis[3];			//y-axis values
	int m_zAxis;			//z-axis values
	int m_gyro;				//gyro values

#if defined(USE_LEAN_HACK)
	bool m_rotXLActive;
	bool m_rotXRActive;
	bool m_rotZDActive;
	bool m_rotZUActive;
#endif
};

#endif //defined(USE_DXINPUT) && !defined(WIN64)

#endif //__PS3PADWIN_H__
