#ifndef __XINPUTKEYBOARD_H__
#define __XINPUTKEYBOARD_H__
#pragma once

#ifdef USE_XENONINPUT

#include"InputDevice.h"

#if defined(USE_DXINPUT) || defined(USE_XENONINPUT)

#ifdef USE_XENONINPUT
#define VK_LWIN           0x5B
#define VK_RWIN           0x5C
#endif

#if defined(USE_DXINPUT)
#include <xinput.h>
#pragma comment(lib, "xinput.lib")
#elif defined(USE_XENONINPUT)
#include <xtl.h>
#endif

class		CXenonInput;

class CXInputKeyboard : public CInputDevice
{
public:
	CXInputKeyboard(CXenonInput& input);

	// IInputDevice overrides
	virtual bool Init();
	virtual void Update(bool bFocus);
	virtual const char *GetKeyName(const SInputEvent& event, bool bGUI);
	virtual bool IsOfDeviceType( EInputDeviceType type ) const { return false; }
	// ~IInputDevice overrides
private:
	void ProcessKey(uint32 key, bool pressed, WCHAR unicode, bool repeat=false);
	CXenonInput& rXenonInput;
};

#endif //defined(USE_DXINPUT) || defined(USE_XENONINPUT)

#endif //USE_XENONINPUT

#endif //__XINPUTKEYBOARD_H__
