/*
 * data for the gaussian encoding routines
 * should only be included from GaussianEncoding.cpp
 */

struct SSlotData
{
	uint32 low;
	int32 x;
};

static SSlotData SlotData3[6] = {
	{20,8},
	{19,7},
	{15,4},
	{13,3},
	{9,2},
	{0,0},
};

static SSlotData SlotData4[10] = {
	{71,16},
	{68,13},
	{65,11},
	{63,10},
	{60,9},
	{52,7},
	{47,6},
	{41,5},
	{26,3},
	{0,0},
};

static SSlotData SlotData5[15] = {
	{221,32},
	{217,28},
	{210,24},
	{205,22},
	{198,20},
	{194,19},
	{178,16},
	{172,15},
	{165,14},
	{148,12},
	{139,11},
	{118,9},
	{107,8},
	{95,7},
	{0,0},
};

static SSlotData SlotData6[17] = {
	{494,64},
	{483,54},
	{474,49},
	{456,43},
	{449,41},
	{430,37},
	{400,32},
	{392,31},
	{377,29},
	{351,26},
	{321,23},
	{288,20},
	{277,19},
	{213,14},
	{170,11},
	{141,9},
	{0,0},
};

static SSlotData SlotData7[22] = {
	{1271,128},
	{1255,114},
	{1234,103},
	{1204,93},
	{1180,87},
	{1145,80},
	{1121,76},
	{1094,72},
	{1055,67},
	{1020,63},
	{971,58},
	{927,54},
	{892,51},
	{828,46},
	{772,42},
	{697,37},
	{600,31},
	{565,29},
	{457,23},
	{382,19},
	{184,9},
	{0,0},
};

static SSlotData SlotData8[25] = {
	{2871,256},
	{2844,233},
	{2791,207},
	{2748,193},
	{2705,182},
	{2641,169},
	{2568,157},
	{2511,149},
	{2447,141},
	{2375,133},
	{2305,126},
	{2229,119},
	{2121,110},
	{2029,103},
	{1945,97},
	{1856,91},
	{1729,83},
	{1593,75},
	{1486,69},
	{1316,60},
	{1137,51},
	{928,41},
	{553,24},
	{23,1},
	{0,0},
};

static SSlotData SlotData9[27] = {
	{6414,512},
	{6361,470},
	{6283,431},
	{6185,398},
	{6072,370},
	{5971,350},
	{5857,331},
	{5731,313},
	{5594,296},
	{5458,281},
	{5317,267},
	{5174,254},
	{4993,239},
	{4836,227},
	{4668,215},
	{4473,202},
	{4330,193},
	{4025,175},
	{3789,162},
	{3599,152},
	{3320,138},
	{2984,122},
	{2631,106},
	{2192,87},
	{1685,66},
	{982,38},
	{0,0},
};

static SSlotData SlotData10[26] = {
	{12328,1024},
	{12224,938},
	{12047,850},
	{11843,783},
	{11649,735},
	{11423,690},
	{11168,648},
	{10942,616},
	{10660,581},
	{10388,551},
	{10107,523},
	{9787,494},
	{9462,467},
	{9110,440},
	{8745,414},
	{8323,386},
	{7888,359},
	{7496,336},
	{6936,305},
	{6440,279},
	{5818,248},
	{5122,215},
	{4304,178},
	{3310,135},
	{1814,73},
	{0,0},
};

static SSlotData SlotData11[27] = {
	{25154,2048},
	{24961,1888},
	{24602,1708},
	{24219,1581},
	{23792,1475},
	{23353,1388},
	{22881,1310},
	{22395,1241},
	{21847,1173},
	{21293,1112},
	{20708,1054},
	{20087,998},
	{19484,948},
	{18780,894},
	{18064,843},
	{17390,798},
	{16464,740},
	{15543,686},
	{14585,633},
	{13614,582},
	{12453,524},
	{11235,466},
	{9604,392},
	{7991,322},
	{5563,221},
	{637,25},
	{0,0},
};

static SSlotData SlotData12[28] = {
	{51792,4096},
	{51469,3825},
	{50723,3442},
	{49975,3192},
	{49136,2982},
	{48264,2808},
	{47332,2653},
	{46334,2511},
	{45322,2385},
	{44221,2263},
	{43099,2151},
	{41876,2040},
	{40576,1932},
	{39246,1830},
	{37843,1730},
	{36294,1627},
	{34788,1533},
	{32966,1426},
	{31198,1328},
	{29161,1221},
	{26975,1112},
	{24617,1000},
	{21905,877},
	{18863,745},
	{15139,590},
	{9804,377},
	{26,1},
	{0,0},
};

static SSlotData SlotData13[28] = {
	{105964,8192},
	{105300,7647},
	{103914,6938},
	{102382,6422},
	{100763,6015},
	{98987,5659},
	{97156,5354},
	{95194,5074},
	{93201,4825},
	{91185,4600},
	{88753,4356},
	{86410,4143},
	{83829,3928},
	{81172,3724},
	{78395,3526},
	{75513,3334},
	{72327,3135},
	{68956,2937},
	{65404,2740},
	{61638,2542},
	{57516,2336},
	{52978,2120},
	{47871,1888},
	{42115,1638},
	{35534,1364},
	{27029,1024},
	{14113,528},
	{0,0},
};

static SSlotData SlotData14[28] = {
	{212594,16384},
	{211285,15309},
	{208502,13884},
	{205426,12849},
	{202147,12027},
	{198685,11334},
	{195073,10731},
	{191212,10178},
	{187125,9666},
	{182783,9183},
	{178296,8734},
	{173491,8297},
	{168723,7899},
	{163274,7479},
	{157748,7084},
	{151796,6687},
	{145473,6292},
	{138942,5908},
	{131739,5508},
	{124269,5115},
	{116030,4703},
	{106893,4268},
	{97057,3821},
	{85578,3322},
	{72543,2779},
	{55990,2117},
	{31048,1159},
	{0,0},
};

static SSlotData SlotData15[29] = {
	{429545,32768},
	{426949,30650},
	{421418,27824},
	{415295,25764},
	{408831,24141},
	{401907,22752},
	{394673,21543},
	{386901,20430},
	{378701,19404},
	{370267,18466},
	{361228,17561},
	{351798,16703},
	{341883,15876},
	{331414,15070},
	{320231,14271},
	{308697,13502},
	{296432,12735},
	{283247,11959},
	{269247,11181},
	{254026,10380},
	{237982,9578},
	{220364,8739},
	{200784,7849},
	{178745,6891},
	{153172,5826},
	{122760,4610},
	{79459,2946},
	{27,1},
	{0,0},
};

static SSlotData SlotData16[29] = {
	{861699,65536},
	{856574,61355},
	{845394,55647},
	{833351,51596},
	{820290,48314},
	{806498,45548},
	{791991,43124},
	{776483,40904},
	{760434,38894},
	{743259,36982},
	{725428,35196},
	{706470,33470},
	{686494,31804},
	{665639,30199},
	{643830,28640},
	{620294,27070},
	{595706,25533},
	{569844,24011},
	{541686,22446},
	{512036,20885},
	{479893,19277},
	{444392,17586},
	{406009,15841},
	{362012,13928},
	{312328,11858},
	{251422,9422},
	{167574,6200},
	{27,1},
	{0,0},
};

static SSlotData SlotData17[29] = {
	{1730895,131072},
	{1720655,122746},
	{1698349,111376},
	{1674331,103300},
	{1648420,96784},
	{1620669,91215},
	{1591563,86354},
	{1560609,81926},
	{1528548,77913},
	{1494374,74110},
	{1458734,70541},
	{1421125,67117},
	{1381028,63773},
	{1339909,60608},
	{1295615,57442},
	{1249665,54377},
	{1200249,51287},
	{1148240,48227},
	{1092516,45131},
	{1033294,42014},
	{968850,38792},
	{899974,35512},
	{823281,32025},
	{736241,28241},
	{638026,24150},
	{519745,19420},
	{361008,13319},
	{27,1},
	{0,0},
};

static SSlotData SlotData18[29] = {
	{3472608,262144},
	{3452159,245555},
	{3407681,222899},
	{3359547,206720},
	{3307881,193732},
	{3252772,182667},
	{3194550,172935},
	{3132782,164093},
	{3068045,155990},
	{3000142,148436},
	{2928645,141278},
	{2852986,134395},
	{2774455,127847},
	{2691557,121465},
	{2603350,115161},
	{2511423,109030},
	{2413188,102888},
	{2309737,96801},
	{2199474,90673},
	{2080993,84435},
	{1953773,78072},
	{1814528,71440},
	{1662003,64507},
	{1492474,57136},
	{1295448,48928},
	{1062806,39626},
	{755264,27806},
	{2915,106},
	{0,0},
};

static SSlotData SlotData19[29] = {
	{6937261,524288},
	{6896163,490945},
	{6807354,445717},
	{6710934,413307},
	{6607008,387202},
	{6497006,365136},
	{6380186,345624},
	{6257609,328082},
	{6128213,311880},
	{5991723,296694},
	{5848736,282380},
	{5698035,268668},
	{5540295,255513},
	{5374090,242718},
	{5197578,230104},
	{5012339,217753},
	{4817963,205601},
	{4609410,193329},
	{4387792,181015},
	{4150166,168508},
	{3895001,155750},
	{3617617,142541},
	{3311768,128639},
	{2970236,113791},
	{2576225,97378},
	{2106973,78616},
	{1482689,54626},
	{27,1},
	{0,0},
};

static SSlotData SlotData20[29] = {
	{13910069,1048576},
	{13828210,982254},
	{13650648,891857},
	{13457859,827072},
	{13250798,775054},
	{13030204,730799},
	{12796702,691807},
	{12551043,656665},
	{12292498,624309},
	{12019863,593989},
	{11734797,565460},
	{11433429,538045},
	{11117937,511742},
	{10785528,486162},
	{10436261,461205},
	{10066206,436527},
	{9676370,412156},
	{9261377,387739},
	{8820680,363251},
	{8346588,338296},
	{7839225,312926},
	{7283583,286467},
	{6678279,258955},
	{5996934,229335},
	{5217680,196877},
	{4290733,159817},
	{3074060,113062},
	{609605,22147},
	{0,0},
};

static SSlotData SlotData21[29] = {
	{27806259,2097152},
	{27642352,1964327},
	{27287514,1783649},
	{26901221,1653838},
	{26486712,1549738},
	{26045918,1461327},
	{25579389,1383422},
	{25087922,1313111},
	{24568781,1248153},
	{24025711,1187765},
	{23452282,1130386},
	{22852347,1075820},
	{22220346,1023129},
	{21555950,972002},
	{20854718,921900},
	{20117194,872720},
	{19335384,823845},
	{18506237,775062},
	{17621446,725901},
	{16676993,676189},
	{15656121,625144},
	{14549174,572435},
	{13332937,517156},
	{11973555,458060},
	{10411858,393007},
	{8548100,318493},
	{6101819,224492},
	{972986,35360},
	{0,0},
};

static SSlotData SlotData22[29] = {
	{55665391,4194304},
	{55338224,3929293},
	{54627810,3567656},
	{53855033,3308087},
	{53026664,3100115},
	{52146065,2923509},
	{51213619,2767798},
	{50229752,2627049},
	{49195035,2497571},
	{48106409,2376509},
	{46960881,2261888},
	{45760341,2152700},
	{44498498,2047502},
	{43170119,1945280},
	{41767644,1845079},
	{40294114,1746825},
	{38729701,1649033},
	{37073904,1551623},
	{35307916,1453505},
	{33419092,1354090},
	{31384032,1252337},
	{29170772,1146951},
	{26741736,1036556},
	{24024184,918430},
	{20919888,789130},
	{17205824,640646},
	{12363121,454562},
	{2761111,100280},
	{0,0},
};

static SSlotData SlotData23[29] = {
	{111381378,8388608},
	{110727068,7858800},
	{109307158,7136066},
	{107760354,6616556},
	{106103695,6200712},
	{104341865,5847443},
	{102477259,5536130},
	{100509900,5254730},
	{98439214,4995663},
	{96264049,4753808},
	{93977216,4524992},
	{91573558,4306381},
	{89050168,4096022},
	{86391952,3891484},
	{83593657,3691565},
	{80640494,3494659},
	{77515976,3299361},
	{74201564,3104392},
	{70678620,2908669},
	{66901402,2709864},
	{62832121,2506407},
	{58410378,2295870},
	{53556117,2075260},
	{48131835,1839482},
	{41933309,1581301},
	{34532316,1285410},
	{24878670,914451},
	{6143116,223042},
	{0,0},
};

static SSlotData SlotData24[29] = {
	{222854603,16777216},
	{221545027,15717322},
	{218705178,14272422},
	{215615866,13234911},
	{212301622,12402921},
	{208775251,11695882},
	{205047324,11073537},
	{201115801,10511209},
	{196975950,9993249},
	{192622861,9509235},
	{188050556,9051758},
	{183245149,8614720},
	{178196683,8193877},
	{172885199,7785194},
	{167286687,7385229},
	{161388473,6991962},
	{155143186,6601589},
	{148521585,6212056},
	{141467551,5820150},
	{133913750,5422588},
	{125784720,5016163},
	{116947562,4595397},
	{107251341,4154739},
	{96419261,3683895},
	{84036655,3168130},
	{69257405,2577262},
	{50006829,1837541},
	{13319637,483471},
	{0,0},
};

static SSlotData SlotData25[29] = {
	{445762444,33554432},
	{443145405,31436261},
	{437464703,28545684},
	{431280956,26469169},
	{424653786,24805803},
	{417605525,23392700},
	{410151146,22148230},
	{402283682,21022956},
	{394003937,19987084},
	{385300041,19019344},
	{376149858,18103880},
	{366542768,17230196},
	{356442711,16388296},
	{345823282,15571246},
	{334635001,14771952},
	{322829869,13984851},
	{310347244,13204621},
	{297088521,12424676},
	{282994113,11641663},
	{267898277,10847165},
	{251637804,10034195},
	{233982081,9193539},
	{214577760,8311676},
	{192932716,7370818},
	{168156475,6338835},
	{138626804,5158267},
	{100185247,3681106},
	{27178209,986423},
	{0,0},
};

static SSlotData SlotData26[29] = {
	{891580523,67108864},
	{886345033,62871798},
	{874982706,57090848},
	{862618253,52939056},
	{849366805,49612991},
	{835268797,46786423},
	{820351715,44296188},
	{804615795,42045675},
	{788058537,39974343},
	{770653130,38039210},
	{752361153,36209140},
	{733142692,34461384},
	{712946072,32777885},
	{691701552,31143368},
	{669328312,29545045},
	{645720769,27971040},
	{620750250,26410274},
	{594255999,24851745},
	{566050001,23284756},
	{535856081,21695668},
	{503343197,20070155},
	{468027120,18388648},
	{429245009,16626139},
	{385941024,14743828},
	{336408688,12680721},
	{277350343,10319649},
	{200526073,7367611},
	{54941476,1993997},
	{0,0},
};

static const int MIN_SLOT_DATA = 3;
static const int MAX_SLOT_DATA = 26;

struct SGaussianCurve
{
	SSlotData * pData;
	size_t nEnts;
};

static SGaussianCurve Curves[MAX_SLOT_DATA - MIN_SLOT_DATA + 1] = {
#define ENT(n) {SlotData##n, sizeof(SlotData##n)/sizeof(*SlotData##n)}
	ENT(3),
	ENT(4),
	ENT(5),
	ENT(6),
	ENT(7),
	ENT(8),
	ENT(9),
	ENT(10),
	ENT(11),
	ENT(12),
	ENT(13),
	ENT(14),
	ENT(15),
	ENT(16),
	ENT(17),
	ENT(18),
	ENT(19),
	ENT(20),
	ENT(21),
	ENT(22),
	ENT(23),
	ENT(24),
	ENT(25),
	ENT(26),
#undef ENT
};
