#############################################################################
## Crytek Source File
## Copyright (C) 2006, Crytek Studios
##
## Creator: Sascha Demetrio
## Date: Jul 31, 2006
## Description: GNU-make based build system
#############################################################################

PROJECT_TYPE := module
PROJECT_VCPROJ := CryNetwork.vcproj

-include $(PROJECT_CODE)/Project_override.mk

PROJECT_CPPFLAGS += \
	-I$(CODE_ROOT)/CryEngine/CryCommon \
	-I$(CODE_ROOT)/SDKs \
	-I$(CODE_ROOT)/SDKs/Speex/include \
	-I$(CODE_ROOT)/SDKs/GameSpy/common

ifeq ($(ARCH),PS3-cell)
 # Exclude GameSpy.
 PROJECT_SOURCES_C_REMOVE := ../../SDKs/GameSpy/%
 PROJECT_SOURCES_CPP_REMOVE := Services/GameSpy/% ../../SDKs/GameSpy/% StdAfx.cpp
 PROJECT_SOURCES_H_REMOVE := ../../SDKs/GameSpy/% Services/GameSpy/%
 PROJECT_SOURCES_DIRS_REMOVE := ../../SDKs/GameSpy%
 # Exclude Live
 PROJECT_SOURCES_CPP_REMOVE += Lobby/Live/%
endif
# Linux-x86 and Linux-x86_64
ifeq ($(findstring Linux,$(ARCH)),Linux)
 # Exclude GameSpy.
 PROJECT_SOURCES_C_REMOVE := ../../SDKs/GameSpy/%
 PROJECT_SOURCES_CPP_REMOVE := Services/GameSpy/% ../../SDKs/GameSpy/%
 PROJECT_SOURCES_H_REMOVE := ../../SDKs/GameSpy/% Services/GameSpy/%
 PROJECT_SOURCES_DIRS_REMOVE := ../../SDKs/GameSpy%
 # Exclude Live
 PROJECT_SOURCES_CPP_REMOVE += Lobby/Live/%
 PROJECT_CPPFLAGS += -D_LINUX
endif

ifeq ($(MKOPTION_UNITYBUILD),1)
PROJECT_SOURCES_CPP_REMOVE += ../../SDKs/PunkBuster/pbcl.cpp \
	../../SDKs/PunkBuster/pbmd5.cpp \
	../../SDKs/PunkBuster/pbsdk.cpp \
	../../SDKs/PunkBuster/pbsv.cpp \
	AntiCheat/DefenceContext.cpp \
	AntiCheat/DefenceData.cpp \
	Compression/AdaptiveBoolPolicy.cpp \
	Compression/AdaptiveBoolPolicy2.cpp \
	Compression/AdaptiveFloat.cpp \
	Compression/AdaptiveFloatPolicy.cpp \
	Compression/AdaptiveOrientationPolicy.cpp \
	Compression/AdaptiveUnitVec3Policy.cpp \
	Compression/AdaptiveVec3Policy.cpp \
	Compression/AdaptiveVelocity.cpp \
	Compression/AdaptiveVelocityPolicy.cpp \
	Compression/ArithAlphabet.cpp \
	Compression/ArithModel.cpp \
	Compression/ArithPrimitives.cpp \
	Compression/BiggerOrSmallerPolicy.cpp \
	Compression/BoolCompress.cpp \
	Compression/BoolCompress2.cpp \
	Compression/CompressionManager.cpp \
	Compression/DefaultPolicy.cpp \
	Compression/EntityIdPolicy.cpp \
	Compression/FloatAsIntPolicy.cpp \
	Compression/GaussianEncoding.cpp \
	Compression/IntegerValuePredictor.cpp \
	Compression/JumpyPolicy.cpp \
	Compression/NoSendPolicy.cpp \
	Compression/OwnChannelCompressionPolicy.cpp \
	Compression/QuantizedVec3.cpp \
	Compression/Quantizer.cpp \
	Compression/RangedIntPolicy.cpp \
	Compression/SegmentedCompressionSpace.cpp \
	Compression/SerializationChunk.cpp \
	Compression/StationaryInteger.cpp \
	Compression/StringTable.cpp \
	Compression/StringTablePolicy.cpp \
	Compression/TimePolicy.cpp \
	Compression/Vec3TableCompressor.cpp \
	Context/Authentication.cpp \
	Context/BreakagePlayback.cpp \
	Context/CET_Server.cpp \
	Context/ClientContextView.cpp \
	Context/ContextEstablisher.cpp \
	Context/ContextView.cpp \
	Context/ContextViewStateManager.cpp \
	Context/PeerContextView.cpp \
	Context/DemoPlaybackListener.cpp \
	Context/DemoRecordListener.cpp \
	Context/History/AuthorityHistory.cpp \
	Context/History/ConfigurationHistory.cpp \
	Context/History/History.cpp \
	Context/History/MementoHistory.cpp \
	Context/History/ProfileHistory.cpp \
	Context/History/RegularlySyncedItem.cpp \
	Context/NetContext.cpp \
	Context/NetContextState.cpp \
	Context/ServerContextView.cpp \
	Context/SessionID.cpp \
	Context/SyncedFile.cpp \
	Context/SyncedFilePak.cpp \
	Context/SyncedFileSet.cpp \
	Context/UpdateAspectDataContext.cpp \
	Context/UpdateMessage.cpp \
	Context/VoiceContext.cpp \
	CryNetwork.cpp \
	Cryptography/Whirlpool.cpp \
	Cryptography/rijndael.cpp \
	Cryptography/StreamCipher.cpp \
	DebugKit/DebugKit.cpp \
	DebugKit/DebugOutput.cpp \
	DebugKit/Encoding.cpp \
	DebugKit/NetVis.cpp \
	DebugKit/NetworkInspector.cpp \
	DebugKit/ServerProfiler.cpp \
	DistributedLogger.cpp \
	Http/AutoConfigDownloader.cpp \
	Http/SimpleHttpServer.cpp \
	MementoMemoryManager.cpp \
	Lobby/CryStats.cpp \
	Lobby/CryLobby.cpp \
	Lobby/CryVoice.cpp \
	Lobby/LAN/CryLANMatchMaking.cpp \
	Lobby/LAN/CryLANLobby.cpp \
	Lobby/CryMatchMaking.cpp \
	Lobby/CryTelemetry.cpp \
	Lobby/PSN/CryPSNMatchMaking.cpp \
	Lobby/PSN/CryPSNLobby.cpp \
	Lobby/PSN/CryPSNSupport.cpp \
	Lobby/PSN/CryPSNVoice.cpp \
	Lobby/PSN/CryPSNSessionSupport.cpp \
	Lobby/CryRebroadcaster.cpp \
	NetCVars.cpp \
	NetLog.cpp \
	NetTimer.cpp \
	Network.cpp \
	NetProfile.cpp \
	RemoteControl/RemoteControl.cpp \
	Utils.cpp \
	WorkQueue.cpp \
	Services/NetworkACL/NetProfileTokens.cpp \
	Services/CryLAN/LanQueryListener.cpp \
	Services/ServiceManager.cpp \
	Streams/ByteStream.cpp \
	Streams/CompressingStream.cpp \
	Streams/SimpleInputStream.cpp \
	Streams/SimpleOutputStream.cpp \
	VOIP/IVoiceDecoder.cpp \
	VOIP/IVoiceEncoder.cpp \
	VOIP/SpeexCodec.cpp \
	VOIP/VoiceManager.cpp \
	VOIP/VoicePacket.cpp \
	Protocol/CTPEndpoint.cpp \
	Protocol/ExponentialKeyExchange.cpp \
	Protocol/FrameTypes.cpp \
	Protocol/MessageMapper.cpp \
	Protocol/MessageQueue.cpp \
	Protocol/NetChannel.cpp \
	Protocol/NetNub.cpp \
	Protocol/NullSendable.cpp \
	Protocol/PMTUDiscovery.cpp \
	Protocol/PacketRateCalculator.cpp \
	Protocol/Serialize.cpp \
	Protocol/StatsCollector.cpp \
	Socket/CompositeDatagramSocket.cpp \
	Socket/IDatagramSocket.cpp \
	Socket/ISocketIOManager.cpp \
	Socket/IStreamSocket.cpp \
	Socket/InternetSimulatorSocket.cpp \
	Socket/LocalDatagramSocket.cpp \
	Socket/NetAddress.cpp \
	Socket/SocketError.cpp \
	Socket/SocketIOManager360.cpp \
	Socket/SocketIOManagerIOCP.cpp \
	Socket/SocketIOManagerSelect.cpp \
	Socket/TCPStreamSocket.cpp \
	Socket/UDPDatagramSocket.cpp \
	Socket/WatchdogTimer.cpp

PROJECT_SOURCES_CPP_ADD += \
  CryNetwork_cont_uber.cpp\
  CryNetwork_main_uber.cpp\
  CryNetwork_utils_uber.cpp
endif

ifeq ($(ARCH),PS3-cell)
  PROJECT_SOURCES_C_REMOVE += ../../SDKs/Speex/libspeex/% \
    ../../SDKs/BigDigits/%
endif

# These will be needed once we're adding GameSpy to the build:
#ifeq ($(ARCH),PS3-cell)
# PROJECT_CPPFLAGS += -D_PS3 -DPS3_GAMESPY
#endif

# vim:ts=8:sw=8
