#include "StdAfx.h"
#include "IVoiceEncoder.h"

#if defined(XENON) && defined(_RELEASE)
#define ENABLE_VOICE 		0
#else
#define ENABLE_VOICE 		1
#endif

CVoiceEncodingSession::CVoiceEncodingSession( IVoiceEncoder * pEnc ) : m_pEnc(pEnc)
{
#if ENABLE_VOICE
	m_buildFragment.resize( pEnc->GetFrameSize() );
	m_buildPos = 0;
	m_seq = 0;
	++g_objcnt.voiceEncodingSession;
#endif
}

void CVoiceEncodingSession::AddVoiceFragment( int numSamples, const int16 * pSamples, IVoicePacketSink * pSink )
{
#if ENABLE_VOICE
	while (numSamples)
	{
		size_t copySize = min(m_buildFragment.size() - m_buildPos, size_t(numSamples));
		memcpy( &m_buildFragment[m_buildPos], pSamples, sizeof(int16)*copySize );
		m_buildPos += copySize;
		numSamples -= copySize;
		pSamples += copySize;
		if (m_buildPos == m_buildFragment.size())
		{
			TVoicePacketPtr pPacket = CVoicePacket::Allocate();
			pPacket->SetSeq(m_seq);
			m_pEnc->EncodeFrame( m_buildFragment.size(), &m_buildFragment[0], pPacket );
			m_buildPos = 0;
			m_seq++;
			pSink->AddPacket( pPacket );
		}
	}
#endif
}


void CVoiceEncodingSession::Reset( IVoicePacketSink * pSink )
{
#if ENABLE_VOICE
	//fill up with silence to compress current data
	if(m_buildPos)
	{
		memset(&m_buildFragment[m_buildPos],0,sizeof(int16)*(m_buildFragment.size()-m_buildPos));
		TVoicePacketPtr pPacket = CVoicePacket::Allocate();
		pPacket->SetSeq(m_seq);
		m_pEnc->EncodeFrame(m_buildFragment.size(),&m_buildFragment[0],pPacket);
		m_buildPos=0;
		m_seq++;
		pSink->AddPacket( pPacket );
	}
	m_pEnc->Reset();
#endif
}

CVoiceEncodingSession::~CVoiceEncodingSession()
{
#if ENABLE_VOICE
	SAFE_RELEASE(m_pEnc);
	--g_objcnt.voiceEncodingSession;
#endif
}
