////////////////////////////////////////////////////////////////////////////
//
//  Crytek Engine Source File.
//  Copyright (C), Crytek Studios, 2009.
// -------------------------------------------------------------------------
//  File name:   aescryptography.h
//  Version:     v1.00
//  Created:     06/08/2009 by Younggi Lim
//  Compilers:   Visual Studio.NET
//  Description: encrypt/decrypt file or buffer using rijndael algorithm
// -------------------------------------------------------------------------
//  History:
//
////////////////////////////////////////////////////////////////////////////

#include "StdAfx.h"

#ifdef USING_LICENSE_PROTECTION

#include "AesCryptography.h"
#include "rijndael.h"
#include <limits>

static uint8 KeyXorTable[] =
{
	0xF1,0x23,0x2F,0xF8,0xC2,0xDA,0x2B,0xFB,0x42,0xF8,0x98,0x9A,0xC2,0x32,0xDE,0x3D,
	0x31,0x2D,0x6F,0x08,0xC8,0x1A,0xCB,0xF0,0x92,0xF7,0x78,0x92,0xD2,0x37,0xDF,0xAD
};

static uint8 DataXorTable[] = 
{
	0xF0,0x20,0xAF,0xF7,0xE2,0x8A,0x9B,0xFB,0x4C,0xFC,0xF8,0xBA,0xC0,0x72,0xDF,0x2E
};

CAesCryptography::CAesCryptography()
{
	const int defaultKeyValueSize = 8;
	uint8 defaultKey[defaultKeyValueSize] = {0xFB,0x4C,0x78,0x92,0xD2,0xF8,0xC2,0xDA};
	SetKeyValue(defaultKey, defaultKeyValueSize);
}

CAesCryptography::CAesCryptography(const uint8* key, int keyLen)
{
	SetKeyValue(key, keyLen);
}

CAesCryptography::~CAesCryptography()
{
}

void CAesCryptography::SetKeyValue(const uint8* key, int keyLen)
{
	for(int i=0;i<KeyValueSize; ++i)
		m_keyValue[i] = key[i%keyLen]^KeyXorTable[i];
}


bool CAesCryptography::EncryptBuffer(const uint8* inputBuffer, uint32 inputBufferSize, uint8* outputBuffer)
{
	return CryptBufferImpl(eCD_Encrypt, inputBuffer, inputBufferSize, outputBuffer);
}

bool CAesCryptography::DecryptBuffer(const uint8* inputBuffer, uint32 inputBufferSize, uint8* outputBuffer)
{
	return CryptBufferImpl(eCD_Decrypt, inputBuffer, inputBufferSize, outputBuffer);
}

bool CAesCryptography::CryptBufferImpl( ECryptDirection dir, const uint8* inputBuffer, uint32 inputBufferSize, uint8* outputBuffer ) 
{
	Rijndael::Direction cryptDirection = Rijndael::Encrypt;
	if (eCD_Decrypt == dir)
		cryptDirection = Rijndael::Decrypt;

	Rijndael encryptObj;
	if (RIJNDAEL_SUCCESS != encryptObj.init(Rijndael::CBC, cryptDirection, m_keyValue, Rijndael::Key32Bytes))
		return false;

	uint32 encryptBufferSize = 0;
	if (eCD_Encrypt == dir)
		encryptBufferSize = encryptObj.blockEncrypt(inputBuffer, (int)inputBufferSize*CHAR_BIT, outputBuffer);
	else
		encryptBufferSize = encryptObj.blockDecrypt(inputBuffer, (int)inputBufferSize*CHAR_BIT, outputBuffer);
	encryptBufferSize /= CHAR_BIT;

	int addLen = inputBufferSize%CryptBlockSize;
	memcpy(outputBuffer+encryptBufferSize, inputBuffer+encryptBufferSize, addLen);
	for(int i=0; i<addLen; ++i)
		*(outputBuffer+encryptBufferSize+i) ^= DataXorTable[i];
	return true;
}

#endif // USING_LICENSE_PROTECTION